/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Workspace;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class P4Event {
    private IP4Resource resource;
    private IP4Resource[] resources;
    private EventType type;

    public P4Event(EventType type, P4Collection collection) {
        this.type = type;
        if (collection != null) {
            this.resources = collection.members();
        }
    }

    public P4Event(EventType type, IP4Resource resource) {
        this.type = type;
        this.resource = resource;
    }

    public P4Event(EventType type, IP4Resource[] resources) {
        this.type = type;
        this.resources = resources;
    }

    public EventType getType() {
        return this.type;
    }

    public IP4File[] getFiles() {
        HashSet<IP4File> files = new HashSet<IP4File>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                files.add((IP4File)resource);
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }

    public IP4File[] getOpenedFiles() {
        HashSet<IP4File> files = new HashSet<IP4File>();
        IP4File file = null;
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File && (file = (IP4File)resource).isOpened()) {
                files.add(file);
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }

    public IP4File[] getUnopenedFiles() {
        HashSet<IP4File> files = new HashSet<IP4File>();
        IP4File file = null;
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File && !(file = (IP4File)resource).isOpened()) {
                files.add(file);
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }

    public IFile[] getLocalFiles() {
        HashSet<IFile> files = new HashSet<IFile>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                IFile[] locals;
                IFile[] iFileArray = locals = ((IP4File)resource).getLocalFiles();
                int n3 = locals.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile local = iFileArray[n4];
                    if (local != null) {
                        files.add(local);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public IContainer[] getLocalContainers() {
        HashSet<IContainer> containers = new HashSet<IContainer>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            IContainer[] iContainerArray;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Folder) {
                IContainer[] locals = ((IP4Folder)resource).getLocalContainers();
                if (locals != null) {
                    iContainerArray = locals;
                    n4 = locals.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IContainer local = iContainerArray[n3];
                        containers.add(local);
                        ++n3;
                    }
                }
            } else if (resource instanceof IP4Connection) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                iContainerArray = projects;
                n4 = projects.length;
                n3 = 0;
                while (n3 < n4) {
                    IContainer project = iContainerArray[n3];
                    if (resource.equals(P4Workspace.getWorkspace().getConnection((IProject)project))) {
                        containers.add(project);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return containers.toArray(new IContainer[containers.size()]);
    }

    public IResource[] getLocalResources() {
        HashSet<IFile> resources = new HashSet<IFile>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            IFile[] iFileArray;
            IFile[] locals;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                iFileArray = locals = ((IP4File)resource).getLocalFiles();
                n4 = locals.length;
                n3 = 0;
                while (n3 < n4) {
                    IFile localFile = iFileArray[n3];
                    if (localFile != null) {
                        resources.add(localFile);
                    }
                    ++n3;
                }
            } else if (resource instanceof IP4Folder) {
                iFileArray = locals = ((IP4Folder)resource).getLocalContainers();
                n4 = locals.length;
                n3 = 0;
                while (n3 < n4) {
                    IFile localFolder = iFileArray[n3];
                    if (localFolder != null) {
                        resources.add(localFolder);
                    }
                    ++n3;
                }
            } else if (resource instanceof IP4Connection) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                iFileArray = projects;
                n4 = projects.length;
                n3 = 0;
                while (n3 < n4) {
                    IFile project = iFileArray[n3];
                    if (resource.equals(P4Workspace.getWorkspace().getConnection((IProject)project))) {
                        resources.add(project);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public IP4Container[] getContainers() {
        HashSet<IP4Container> containers = new HashSet<IP4Container>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Container parent;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Container) {
                containers.add((IP4Container)resource);
            } else if (resource instanceof IP4File && (parent = ((IP4File)resource).getParent()) != null) {
                containers.add(parent);
            }
            ++n2;
        }
        return containers.toArray(new IP4Container[containers.size()]);
    }

    public IP4Changelist[] getChangelists() {
        HashSet<IP4Changelist> changelists = new HashSet<IP4Changelist>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4PendingChangelist parent;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Changelist) {
                changelists.add((IP4Changelist)resource);
            } else if (resource instanceof IP4File && (parent = ((IP4File)resource).getChangelist()) != null) {
                changelists.add(parent);
            }
            ++n2;
        }
        return changelists.toArray(new IP4Changelist[changelists.size()]);
    }

    public IP4Job[] getJobs() {
        HashSet<IP4Job> jobs = new HashSet<IP4Job>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Job) {
                jobs.add((IP4Job)resource);
            }
            ++n2;
        }
        return jobs.toArray(new IP4Job[jobs.size()]);
    }

    public IP4Branch[] getBranches() {
        HashSet<IP4Branch> branches = new HashSet<IP4Branch>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Branch) {
                branches.add((IP4Branch)resource);
            }
            ++n2;
        }
        return branches.toArray(new IP4Branch[branches.size()]);
    }

    public IP4PendingChangelist[] getPending() {
        HashSet<IP4PendingChangelist> lists = new HashSet<IP4PendingChangelist>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4PendingChangelist) {
                lists.add((IP4PendingChangelist)resource);
            }
            ++n2;
        }
        return lists.toArray(new IP4PendingChangelist[lists.size()]);
    }

    public IP4Resource[] getResources() {
        if (this.resource != null) {
            return new IP4Resource[]{this.resource};
        }
        if (this.resources != null) {
            return this.resources;
        }
        return new IP4Resource[0];
    }

    public IP4Connection[] getCommonConnections() {
        HashSet<IP4Connection> connections = new HashSet<IP4Connection>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            IP4Connection connection = resource.getConnection();
            if (connection != null) {
                connections.add(connection);
            }
            ++n2;
        }
        return connections.toArray(new IP4Connection[connections.size()]);
    }

    public IP4Connection[] getConnections() {
        HashSet<IP4Connection> connections = new HashSet<IP4Connection>();
        IP4Resource[] iP4ResourceArray = this.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Connection) {
                connections.add((IP4Connection)resource);
            }
            ++n2;
        }
        return connections.toArray(new IP4Connection[connections.size()]);
    }

    public boolean contains(IP4Resource resource) {
        boolean contains = false;
        if (resource != null) {
            IP4Resource[] iP4ResourceArray = this.getResources();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource eventResource = iP4ResourceArray[n2];
                if (resource.equals(eventResource)) {
                    contains = true;
                    break;
                }
                ++n2;
            }
        }
        return contains;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)this.type);
        buffer.append(" - ");
        buffer.append("[");
        IP4Resource[] resources = this.getResources();
        int i = 0;
        while (i < resources.length) {
            buffer.append(resources[i].getName());
            if (i + 1 < resources.length) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static enum EventType {
        MOVE_ADDED,
        ADDED,
        REMOVED,
        CHANGED,
        OPENED,
        SUBMITTED,
        SUBMIT_FAILED,
        REVERTED,
        REFRESHED,
        RESOLVED,
        AVAILABLE,
        LOCKED,
        UNLOCKED,
        FIXED,
        UNFIXED,
        CREATE_CHANGELIST,
        DELETE_CHANGELIST,
        SUBMIT_CHANGELIST,
        IGNORED,
        CREATE_JOB,
        CREATE_BRANCH,
        CREATE_SHELVE,
        DELETE_SHELVE,
        UPDATE_SHELVE,
        ACTIVE_CHANGELIST,
        INACTIVE_CHANGELIST,
        SUBMIT_JOB,
        SUBMIT_SHELVEDCHANGELIST;

    }
}

