/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Container;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class P4Depot
extends P4Container {
    private IDepot depotData = null;
    private IP4Connection connection = null;
    private String localPath = null;
    private List<IStreamSummary> streams = null;

    public P4Depot(IDepot depotData, IP4Connection connection) {
        this.depotData = depotData;
        this.connection = connection;
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    public boolean isLocal() {
        ClientView view;
        IClient client;
        boolean local = false;
        if (this.connection != null && (client = this.connection.getClient()) != null && (view = client.getClientView()) != null) {
            String depotPath = this.getRemotePath();
            for (IClientViewMapping mapping : view) {
                if (this.isCaseSensitive()) {
                    if (!StringUtils.startsWith((CharSequence)mapping.getDepotSpec(), (CharSequence)depotPath)) continue;
                    local = true;
                    break;
                }
                if (!StringUtils.startsWithIgnoreCase((CharSequence)mapping.getDepotSpec(), (CharSequence)depotPath)) continue;
                local = true;
                break;
            }
        }
        return local;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    @Override
    public String getName() {
        if (this.depotData != null) {
            return this.depotData.getName();
        }
        return null;
    }

    @Override
    public IP4Container getParent() {
        return this.connection;
    }

    @Override
    public String getRemotePath() {
        String name = this.getName();
        if (name != null) {
            name = "//" + name;
        }
        return name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IClient getClient() {
        if (this.connection != null) {
            return this.connection.getClient();
        }
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean equals(Object otherDepot) {
        if (this == otherDepot) {
            return true;
        }
        if (otherDepot instanceof P4Depot) {
            return super.equals(otherDepot);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + P4CoreUtils.hashCode(this.connection) * 31;
    }

    @Override
    public String getClientPath() {
        return null;
    }

    public String getSuffix() {
        if (this.depotData != null) {
            return this.depotData.getSuffix();
        }
        return null;
    }

    public IDepot.DepotType getType() {
        if (this.depotData != null) {
            return this.depotData.getDepotType();
        }
        return null;
    }

    public List<IStreamSummary> getStreams() {
        this.members();
        return this.streams;
    }

    @Override
    public void refresh(int depth) {
        this.refreshStreams();
        super.refresh(depth);
    }

    private void refreshStreams() {
        if (this.getType() != IDepot.DepotType.STREAM) {
            return;
        }
        final ArrayList<IStreamSummary> streams = new ArrayList<IStreamSummary>();
        P4ClientOperation streamsOp = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                streams.addAll(P4Depot.this.getStreams(client));
            }
        };
        this.runOperation(streamsOp);
        this.streams = streams;
    }

    private List<IStreamSummary> getStreams(IClient client) throws P4JavaException {
        List<Object> streams = new ArrayList<IStreamSummary>();
        IP4Connection connection = this.getConnection();
        String path = this.getRemotePath();
        if (connection == null || path == null) {
            return streams;
        }
        if (!(client.getServer() instanceof IOptionsServer)) {
            return streams;
        }
        IOptionsServer os = (IOptionsServer)client.getServer();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(String.valueOf(this.getRemotePath()) + "/*");
        streams = os.getStreams(paths, null);
        return streams;
    }
}

