/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.client.SyncOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.callback.IStreamingCallback;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4Folder;
import com.perforce.team.core.p4java.P4ProgressListener;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class P4Container
extends P4Resource
implements IP4Container {
    protected IP4Resource[] cachedMembers = null;

    protected List<IFileSpec> convertToEllipsisSpecs(List<IFileSpec> specs) {
        ArrayList<IFileSpec> converted = new ArrayList<IFileSpec>();
        for (IFileSpec spec : specs) {
            String path = spec.getPreferredPathString();
            if (path == null) continue;
            path = String.valueOf(path) + "/...";
            converted.addAll(P4FileSpecBuilder.makeFileSpecList(new String[]{path}));
        }
        return converted;
    }

    protected String convertFromEllipsis(String path) {
        String converted = path;
        if (path != null) {
            if (path.endsWith("/...")) {
                converted = path.substring(0, path.lastIndexOf("/..."));
            } else if (path.endsWith(IP4Container.DIR_ELLIPSIS)) {
                converted = path.substring(0, path.lastIndexOf(IP4Container.DIR_ELLIPSIS));
            }
        }
        return converted;
    }

    protected List<IFileSpec> filterUnmapped(List<IFileSpec> specs) {
        ArrayList<IFileSpec> mapped = new ArrayList<IFileSpec>();
        for (IFileSpec spec : specs) {
            if (spec.isUnmap()) continue;
            mapped.add(spec);
        }
        return mapped;
    }

    protected List<IP4Container> getDirectories(IClient client, boolean all) throws P4JavaException {
        ArrayList<IP4Container> newResources = new ArrayList<IP4Container>();
        IP4Connection connection = this.getConnection();
        String path = this.getRemotePath();
        if (path != null) {
            boolean clientOnly = connection != null && connection.showClientOnly();
            boolean includeDeletes = connection != null && connection.showFoldersWithOnlyDeletedFiles();
            List<IFileSpec> dirs = client.getServer().getDirectories(P4FileSpecBuilder.makeFileSpecList(new String[]{String.valueOf(path) + "/*"}), clientOnly, includeDeletes, false);
            if ((dirs = P4FileSpecBuilder.getValidFileSpecs(dirs)).size() > 0) {
                int i = 0;
                while (i < dirs.size()) {
                    IFileSpec dir = dirs.get(i);
                    String dirName = dir.getOriginalPathString();
                    if (dirName != null) {
                        dirName = dirName.substring(dirName.lastIndexOf(47) + 1);
                        P4Folder folder = new P4Folder(this, dirName);
                        if (connection != null) {
                            connection.updateResource(folder);
                        }
                        if (all) {
                            folder.refresh(2);
                        }
                        newResources.add(folder);
                    }
                    ++i;
                }
            }
        }
        return newResources;
    }

    protected List<IP4File> getFiles(IClient client) throws P4JavaException {
        ArrayList<IP4File> newResources = new ArrayList<IP4File>();
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            String path = this.getRemotePath();
            if (path == null) {
                path = this.getLocalPath();
            }
            if (path != null) {
                path = String.valueOf(path) + "/*";
                FileStatOutputOptions outputOptions = null;
                if (connection.showClientOnly()) {
                    outputOptions = new FileStatOutputOptions();
                    outputOptions.setMappedFiles(true);
                }
                List files = client.getServer().getExtendedFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{path}), 0, -1, -1, outputOptions, null);
                ArrayList<IExtendedFileSpec> validFileSpecs = new ArrayList<IExtendedFileSpec>();
                for (IExtendedFileSpec file : files) {
                    if (!FileSpecOpStatus.VALID.equals((Object)file.getOpStatus())) continue;
                    if (file instanceof FileSpec) {
                        ((FileSpec)file).setClient(this.getClient());
                    }
                    validFileSpecs.add(file);
                }
                IP4File[] validFiles = connection.getFiles(validFileSpecs.toArray(new IFileSpec[0]));
                newResources.addAll(Arrays.asList(validFiles));
            }
        }
        return newResources;
    }

    @Override
    public IP4File[] getAllLocalFiles() {
        IP4File[] resources = new IP4File[]{};
        IClient client = this.getClient();
        if (client != null) {
            String path = this.getRemotePath();
            if (path == null) {
                path = this.getLocalPath();
            }
            if (path != null) {
                path = String.valueOf(path) + "/...";
                ArrayList<IP4File> newResources = new ArrayList<IP4File>();
                try {
                    List files = client.getServer().getExtendedFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{path}), 0, -1, -1, null, null);
                    for (IExtendedFileSpec file : files) {
                        if (!FileSpecOpStatus.VALID.equals((Object)file.getOpStatus())) continue;
                        if (file instanceof FileSpec) {
                            ((FileSpec)file).setClient(this.getClient());
                        }
                        IP4File p4File = null;
                        String local = P4Resource.normalizeLocalPath((IFileSpec)file);
                        if (local == null) continue;
                        IP4Resource p4Resource = this.getConnection().getResource(local);
                        if (p4Resource instanceof IP4File) {
                            p4File = (IP4File)p4Resource;
                            p4File.setFileSpec((IFileSpec)file);
                            newResources.add(p4File);
                            continue;
                        }
                        p4File = new P4File(this.getConnection(), local);
                        p4File.setFileSpec((IFileSpec)file);
                        newResources.add(p4File);
                        this.getConnection().updateResource(p4File);
                    }
                    resources = newResources.toArray(new IP4File[0]);
                }
                catch (P4JavaException e1) {
                    PerforceProviderPlugin.logError(e1);
                }
            }
        }
        return resources;
    }

    @Override
    public IP4Resource[] members() {
        if (this.needsRefresh && this.cachedMembers == null) {
            this.refresh();
        }
        return this.cachedMembers != null ? this.cachedMembers : new IP4Resource[]{};
    }

    @Override
    public int size() {
        return this.cachedMembers != null ? this.cachedMembers.length : 0;
    }

    @Override
    public String getActionPath() {
        String path = this.getRemoteActionPath();
        if (path == null) {
            path = this.getLocalActionPath();
        }
        return path;
    }

    private String getRemoteActionPath() {
        String path = this.getRemotePath();
        if (path != null) {
            path = String.valueOf(path) + "/...";
        }
        return path;
    }

    private String getLocalActionPath() {
        String path = this.getLocalPath();
        if (path != null) {
            path = String.valueOf(path) + IP4Container.DIR_ELLIPSIS;
        }
        return path;
    }

    @Override
    public String getActionPath(IP4Resource.Type type) {
        String path = null;
        if (type == IP4Resource.Type.REMOTE) {
            path = this.getRemoteActionPath();
        } else if (type == IP4Resource.Type.LOCAL) {
            path = this.getLocalActionPath();
        }
        if (path == null) {
            path = this.getActionPath();
        }
        return path;
    }

    @Override
    public void sync(final IProgressMonitor monitor) {
        P4ClientOperation operation = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                P4ProgressListener handler = P4CoreUtils.createStreamCallback(P4Container.this.getConnection(), CmdSpec.SYNC, monitor);
                SyncOptions syncOpts = new SyncOptions();
                syncOpts.setForceUpdate(false);
                syncOpts.setNoUpdate(false);
                syncOpts.setClientBypass(false);
                syncOpts.setServerBypass(false);
                client.sync(P4FileSpecBuilder.makeFileSpecList(new String[]{P4Container.this.getActionPath()}), syncOpts, (IStreamingCallback)handler, P4CoreUtils.getRandomInt());
            }
        };
        this.runOperation(operation);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public void refresh() {
        this.refresh(1);
    }

    @Override
    public void refresh(final int depth) {
        final ArrayList dirs = new ArrayList();
        P4ClientOperation dirsOp = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                if (depth == 1) {
                    dirs.addAll(P4Container.this.getDirectories(client, false));
                } else if (depth == 2) {
                    dirs.addAll(P4Container.this.getDirectories(client, true));
                }
            }
        };
        this.runOperation(dirsOp);
        final ArrayList files = new ArrayList();
        P4ClientOperation filesOp = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                files.addAll(P4Container.this.getFiles(client));
            }
        };
        this.runOperation(filesOp);
        if (files.size() > 0) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, new P4Collection(files.toArray(new IP4File[0]))));
        }
        ArrayList resources = new ArrayList();
        resources.addAll(dirs);
        resources.addAll(files);
        this.cachedMembers = resources.toArray(new IP4Resource[0]);
        this.needsRefresh = false;
    }
}

