/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.map;

import com.perforce.team.core.map.MapFlag;
import com.perforce.team.core.map.MapItem;
import com.perforce.team.core.map.MapParams;
import com.perforce.team.core.map.MapTableT;
import com.perforce.team.core.map.MapTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class MapTable {
    private static Comparator<MapItem> sortcmplhs = new Comparator<MapItem>(){

        @Override
        public int compare(MapItem e1, MapItem e2) {
            int r = e1.lhs().compare(e2.lhs());
            return r != 0 ? r : e2.slot() - e1.slot();
        }
    };
    private static Comparator<MapItem> sortcmprhs = new Comparator<MapItem>(){

        @Override
        public int compare(MapItem e1, MapItem e2) {
            int r = e1.rhs().compare(e2.rhs());
            return r != 0 ? r : e2.slot() - e1.slot();
        }
    };
    int count;
    MapItem entry;
    MapTree[] trees = new MapTree[2];

    public MapTable() {
        this.trees[0] = new MapTree();
        this.trees[1] = new MapTree();
    }

    public void reverse() {
        this.entry = this.entry.reverse();
    }

    public void insert(MapTable table, boolean fwd, boolean rev) {
        MapItem map = null;
        map = table.entry;
        while (map != null) {
            if (fwd) {
                this.insert(map.lhs().toString(), map.rhs().toString(), map.flag());
            }
            if (rev) {
                this.insert(map.rhs().toString(), map.lhs().toString(), map.flag());
            }
            map = map.next();
        }
        this.reverse();
    }

    public void insert(String lhs, String rhs, MapFlag mapFlag) {
        this.entry = new MapItem(this.entry, lhs, rhs, mapFlag, this.count++);
    }

    public MapItem[] sort(MapTableT direction) {
        if (this.trees[direction.ordinal()].sort != null) {
            return this.trees[direction.ordinal()].sort;
        }
        MapItem map = this.entry;
        ArrayList<MapItem> vecp = new ArrayList<MapItem>();
        while (map != null) {
            vecp.add(map);
            map = map.next();
        }
        MapItem[] vec = vecp.toArray(new MapItem[vecp.size()]);
        if (direction == MapTableT.LHS) {
            Arrays.sort(vec, sortcmplhs);
        } else {
            Arrays.sort(vec, sortcmprhs);
        }
        this.trees[direction.ordinal()].sort = vec;
        return vec;
    }

    private void makeTree(MapTableT dir) {
        int depth = 0;
        MapItem[] vec = this.sort(dir);
        this.trees[dir.ordinal()].tree = new MapItem[]{MapItem.tree(vec, 0, vec.length, dir, null, depth)};
    }

    public MapItem translate(MapTableT dir, String from, StringBuilder to) {
        MapItem map;
        if (!this.isValid()) {
            return null;
        }
        if (this.trees[dir.ordinal()].tree == null) {
            this.makeTree(dir);
        }
        if ((map = this.trees[dir.ordinal()].tree[0].match(dir, from)) != null) {
            MapParams params = new MapParams();
            map.ths(dir).match2(from, params);
            map.ohs(dir).expand(from, to, params);
        }
        return map;
    }

    public boolean isValid() {
        return this.entry != null;
    }
}

