/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.server.callback.ILogCallback;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.IProjectSettingsChangeListener;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Workspace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.osgi.framework.BundleContext;

public class PerforceProviderPlugin
extends Plugin {
    private static PerforceProviderPlugin instance;
    private static ListenerList settingsListeners;
    private static IWorkspaceRoot root;
    public static final String ID = "com.perforce.team.core";
    private static ConnectionParameters currParams;
    private boolean stopped = false;

    static {
        settingsListeners = new ListenerList();
    }

    public PerforceProviderPlugin() {
        instance = this;
    }

    public static void log(TeamException e) {
        instance.getLog().log(e.getStatus());
    }

    public static void log(IStatus status) {
        instance.getLog().log(status);
    }

    public static void logInfo(String message, Throwable throwable) {
        if (message != null || throwable != null) {
            if (message == null) {
                message = "";
            }
            Status status = new Status(1, ID, 0, message, throwable);
            if (instance != null) {
                instance.getLog().log((IStatus)status);
            }
        }
    }

    public static void logWarning(String message, Throwable throwable) {
        if (message != null || throwable != null) {
            if (message == null) {
                message = "";
            }
            Status status = new Status(2, ID, 0, message, throwable);
            instance.getLog().log((IStatus)status);
        }
    }

    public static void logError(String message, Throwable throwable) {
        if (message != null || throwable != null) {
            if (message == null) {
                message = "";
            }
            Status status = new Status(4, ID, 0, message, throwable);
            instance.getLog().log((IStatus)status);
        }
    }

    public static void logInfo(Throwable throwable) {
        if (throwable != null) {
            PerforceProviderPlugin.logInfo(throwable.getMessage(), throwable);
        }
    }

    public static void logWarning(Throwable throwable) {
        if (throwable != null) {
            PerforceProviderPlugin.logWarning(throwable.getMessage(), throwable);
        }
    }

    public static void logError(Throwable throwable) {
        if (throwable != null) {
            PerforceProviderPlugin.logError(throwable.getMessage(), throwable);
        }
    }

    public static void logInfo(String message) {
        if (message != null) {
            PerforceProviderPlugin.logInfo(message, null);
        }
    }

    public static void logWarning(String message) {
        if (message != null) {
            PerforceProviderPlugin.logWarning(message, null);
        }
    }

    public static void logError(String message) {
        if (message != null) {
            PerforceProviderPlugin.logError(message, null);
        }
    }

    public static String[] getResourcePath(IResource[] resources) {
        String[] paths = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            paths[i] = PerforceProviderPlugin.getResourcePath(resources[i]);
            ++i;
        }
        return paths;
    }

    public static String getResourcePath(IResource resource) {
        IPath path;
        String resourcePath = null;
        if (resource != null && (path = resource.getLocation()) != null) {
            resourcePath = path.toOSString();
        }
        return resourcePath;
    }

    public static PerforceProviderPlugin getPlugin() {
        return instance;
    }

    public static void addProjectSettingsChangeListener(IProjectSettingsChangeListener listener) {
        settingsListeners.add((Object)listener);
    }

    public static void removeProjectSettingsChangeListener(IProjectSettingsChangeListener listener) {
        settingsListeners.remove((Object)listener);
    }

    public static void broadcastProjectSettingsChanges(IProject project, ConnectionParameters params) {
        Object[] objectArray = settingsListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IProjectSettingsChangeListener)listener).projectSettingsChanged(project, params);
            ++n2;
        }
    }

    public static boolean manageProject(IProject project, ConnectionParameters params) {
        try {
            currParams = params;
            RepositoryProvider.map((IProject)project, (String)"com.perforce.team.core.PerforceTeamProvider");
            return true;
        }
        catch (TeamException e) {
            PerforceProviderPlugin.log(e);
            return false;
        }
    }

    public static ConnectionParameters getCurrParams() {
        return currParams;
    }

    public static void unmanageProject(IProject project) {
        try {
            RepositoryProvider.unmap((IProject)project);
        }
        catch (TeamException teamException) {
            // empty catch block
        }
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root == null) {
            root = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root;
    }

    public static IContainer getFolderForPath(IPath path) {
        IWorkspaceRoot root = PerforceProviderPlugin.getWorkspaceRoot();
        IContainer[] folders = root.findContainersForLocationURI(path.toFile().toURI());
        if (folders.length == 1) {
            return folders[0];
        }
        return root.getContainerForLocation(path);
    }

    public static IFile[] getResourcesForPath(String filePath) {
        if (filePath != null && !filePath.startsWith("//")) {
            Path path = new Path(filePath);
            IWorkspaceRoot root = PerforceProviderPlugin.getWorkspaceRoot();
            IFile file = root.getFileForLocation((IPath)path);
            if (file != null) {
                return new IFile[]{file};
            }
            IFile[] files = root.findFilesForLocationURI(path.toFile().toURI());
            if (files.length > 0) {
                return files;
            }
        }
        return null;
    }

    public static boolean isIgnoredHint(IResource resource) {
        if (Team.isIgnoredHint((IResource)resource)) {
            return true;
        }
        IContainer iResource = resource.getParent();
        while (iResource != null) {
            if (iResource.isDerived()) {
                return true;
            }
            iResource = iResource.getParent();
        }
        return false;
    }

    public static IFile[] getWorkspaceFiles(String filePath) {
        IFile[] files = null;
        if (filePath != null && (files = PerforceProviderPlugin.getResourcesForPath(filePath)) == null) {
            try {
                String newPath = new File(filePath).getCanonicalPath();
                if (!newPath.equals(filePath)) {
                    files = PerforceProviderPlugin.getResourcesForPath(newPath);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return files;
    }

    public static IFile getWorkspaceFile(String filePath) {
        IFile[] files = PerforceProviderPlugin.getWorkspaceFiles(filePath);
        return files == null ? null : files[0];
    }

    public static IFile[] getWorkspaceFiles(String[] paths) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        int i = 0;
        while (i < paths.length) {
            IFile file = PerforceProviderPlugin.getWorkspaceFile(paths[i]);
            if (file != null) {
                files.add(file);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static PerforceTeamProvider getPerforceProviderFor(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        return PerforceTeamProvider.getPerforceProvider(resource);
    }

    public static IResource getResource(Object object) {
        IFile[] files;
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        if (object instanceof IP4Resource && (files = PerforceProviderPlugin.getResourcesForPath(((IP4Resource)object).getLocalPath())) != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Log.setLogCallback((ILogCallback)new ILogCallback(){

            public void internalWarn(String warnString) {
                if (!PerforceProviderPlugin.this.stopped) {
                    PerforceProviderPlugin.logWarning(warnString);
                }
            }

            public void internalInfo(String infoString) {
                if (!PerforceProviderPlugin.this.stopped) {
                    PerforceProviderPlugin.logInfo(infoString);
                }
            }

            public void internalError(String errorString) {
                if (!PerforceProviderPlugin.this.stopped) {
                    PerforceProviderPlugin.logError(errorString);
                }
            }

            public void internalException(Throwable thr) {
                this.internalError(thr.getLocalizedMessage());
            }

            public void internalStats(String statsString) {
                this.internalInfo(statsString);
            }

            public ILogCallback.LogTraceLevel getTraceLevel() {
                return P4Workspace.getWorkspace().getTraceLevel();
            }

            public void internalTrace(ILogCallback.LogTraceLevel level, String traceString) {
                this.internalInfo(traceString);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspaceRoot root = PerforceProviderPlugin.getWorkspaceRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            PerforceTeamProvider provider = PerforceTeamProvider.getPerforceProvider((IResource)projects[i]);
            if (provider != null) {
                provider.setProjectProperties(provider.getProjectProperties(false));
            }
            ++i;
        }
        P4Workspace.getWorkspace().saveConnections();
        this.stopped = true;
        super.stop(context);
    }

    public static IFile[] getLocalFiles(String localPath) {
        IFile[] files = null;
        if (localPath != null) {
            Path path = new Path(localPath);
            files = PerforceProviderPlugin.getWorkspaceRoot().findFilesForLocationURI(path.toFile().toURI());
            if (files == null || files.length == 0) {
                File file = new File(localPath);
                try {
                    String checkedPath = file.getCanonicalPath();
                    if (!localPath.equals(checkedPath)) {
                        path = new Path(checkedPath);
                        files = PerforceProviderPlugin.getWorkspaceRoot().findFilesForLocationURI(path.toFile().toURI());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (files == null) {
            files = new IFile[]{};
        }
        return files;
    }

    public static IFile getLocalFile(String localPath) {
        return PerforceProviderPlugin.getWorkspaceFile(localPath);
    }

    public static IContainer[] getLocalContainers(String localPath) {
        IContainer[] containers = null;
        if (localPath != null) {
            Path path = new Path(localPath);
            containers = PerforceProviderPlugin.getWorkspaceRoot().findContainersForLocationURI(path.toFile().toURI());
            if (containers == null || containers.length == 0) {
                File file = new File(localPath);
                try {
                    String checkedPath = file.getCanonicalPath();
                    if (!localPath.equals(checkedPath)) {
                        path = new Path(checkedPath);
                        containers = PerforceProviderPlugin.getWorkspaceRoot().findContainersForLocationURI(path.toFile().toURI());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (containers == null) {
            containers = new IContainer[]{};
        }
        return containers;
    }
}

