/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import java.io.File;

public final class PerforceConnectionFactory {
    protected static final String DIR_WILDCARD_SUFFIX = String.valueOf(File.separatorChar) + "*";
    protected static final String P4_LOCATION = "<p4location>";

    private PerforceConnectionFactory() {
    }

    public static String[] formatFilenames(String[] paths) {
        String[] newpaths = new String[paths.length];
        int i = 0;
        while (i < paths.length) {
            newpaths[i] = PerforceConnectionFactory.formatFilename(paths[i]);
            ++i;
        }
        return newpaths;
    }

    public static String formatFilename(String path) {
        boolean wildSuff = false;
        if (path.endsWith(DIR_WILDCARD_SUFFIX)) {
            wildSuff = true;
            path = path.substring(0, path.length() - DIR_WILDCARD_SUFFIX.length());
        }
        if ((path.contains("/") || path.contains("\\")) && !path.startsWith("//") && !path.endsWith(DIR_WILDCARD_SUFFIX) && PerforceConnectionFactory.hasSpecialChars(path)) {
            StringBuffer buff = new StringBuffer(path);
            for (int j = 0; j != buff.length(); ++j) {
                char ch = buff.charAt(j);
                String replace = null;
                if (ch == '@') {
                    replace = "%40";
                } else if (ch == '#') {
                    replace = "%23";
                } else if (ch == '%') {
                    replace = "%25";
                } else if (ch == '*') {
                    replace = "%2A";
                }
                if (replace == null) continue;
                buff.replace(j, j + 1, replace);
                j += 2;
            }
            path = buff.toString();
        }
        if (wildSuff) {
            path = String.valueOf(path) + DIR_WILDCARD_SUFFIX;
        }
        return path;
    }

    public static boolean hasSpecialChars(String path) {
        if (path == null) {
            return false;
        }
        if (path.indexOf(64) > -1) {
            return true;
        }
        if (path.indexOf(35) > -1) {
            return true;
        }
        if (path.indexOf(37) > -1) {
            return true;
        }
        return path.indexOf(42) > -1;
    }
}

