/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.editor;

import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.search.query.QueryOptions;
import com.perforce.team.ui.P4FormUIUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.search.P4UiSearchPlugin;
import com.perforce.team.ui.search.editor.Messages;
import com.perforce.team.ui.search.query.P4SearchQuery;
import com.perforce.team.ui.search.query.SearchOptionsArea;
import com.perforce.team.ui.search.results.FileMatch;
import com.perforce.team.ui.search.results.ISearchResultProvider;
import com.perforce.team.ui.search.results.P4SearchResult;
import com.perforce.team.ui.search.results.RevisionMatch;
import com.perforce.team.ui.search.results.SearchLabelDecorator;
import com.perforce.team.ui.search.results.SearchResultsOpenHandler;
import com.perforce.team.ui.search.results.tree.SearchTreeContentProvider;
import com.perforce.team.ui.search.results.tree.SearchTreeLabelProvider;
import com.perforce.team.ui.search.results.tree.SearchTreeResultsSorter;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchAdapter;

public class ChangelistSearchPage
extends FormPage
implements ISearchResultProvider,
IEditorPart {
    private Section searchSection;
    private Text searchText;
    private Button searchButton;
    private SearchOptionsArea optionsArea;
    private Section resultsSection;
    private TreeViewer resultsViewer;
    private P4SearchResult result;
    private int fileCount = 0;
    private int matchCount = 0;
    private ISchedulingRule searchRule = P4Runner.createRule();
    public static final String ID = "changelistSearchPage";

    public ChangelistSearchPage(FormEditor editor) {
        super(editor, ID, Messages.ChangelistSearchPage_SearchPageTitle);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.setFocus();
        }
    }

    public void setFocus() {
        this.searchText.setFocus();
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout(1, true));
        this.createSearchArea(body, toolkit);
        this.createOptionsArea(body, toolkit);
        this.createResultsArea(body, toolkit);
    }

    private void createOptionsArea(Composite parent, final FormToolkit toolkit) {
        Section optionsSection = toolkit.createSection(parent, 258);
        optionsSection.setExpanded(false);
        optionsSection.setText(Messages.ChangelistSearchPage_SearchOptionsTitle);
        GridLayout osLayout = new GridLayout(1, true);
        osLayout.marginHeight = 0;
        osLayout.marginWidth = 0;
        optionsSection.setLayout((Layout)osLayout);
        optionsSection.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite area = toolkit.createComposite((Composite)optionsSection);
        GridLayout areaLayout = new GridLayout(1, true);
        areaLayout.marginHeight = 0;
        areaLayout.marginWidth = 0;
        area.setLayout((Layout)areaLayout);
        area.setLayoutData((Object)new GridData(4, 4, true, false));
        optionsSection.setClient((Control)area);
        this.optionsArea = new SearchOptionsArea(){

            @Override
            protected Button createButton(Composite parent, String text, int style) {
                return toolkit.createButton(parent, text, style);
            }
        };
        this.optionsArea.createControl(area, false);
    }

    private void createSearchArea(Composite parent, FormToolkit toolkit) {
        this.searchSection = toolkit.createSection(parent, 384);
        this.searchSection.setDescription(Messages.ChangelistSearchPage_SearchExpressionDescription);
        this.searchSection.setText(Messages.ChangelistSearchPage_SearchExpressionTitle);
        this.searchSection.setExpanded(true);
        GridLayout sLayout = new GridLayout(1, true);
        sLayout.marginWidth = 0;
        sLayout.marginHeight = 0;
        this.searchSection.setLayout((Layout)sLayout);
        this.searchSection.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite searchArea = toolkit.createComposite((Composite)this.searchSection);
        GridLayout saLayout = new GridLayout(3, false);
        saLayout.marginHeight = 0;
        saLayout.marginWidth = 0;
        searchArea.setLayout((Layout)saLayout);
        searchArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchSection.setClient((Control)searchArea);
        toolkit.createLabel(searchArea, Messages.ChangelistSearchPage_Pattern);
        this.searchText = toolkit.createText(searchArea, "", 0x800004);
        GridData stData = new GridData();
        stData.widthHint = 250;
        this.searchText.setLayoutData((Object)stData);
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && e.keyCode == 13 && ChangelistSearchPage.this.searchButton.isEnabled()) {
                    ChangelistSearchPage.this.search();
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangelistSearchPage.this.searchButton.setEnabled(ChangelistSearchPage.this.searchText.getText().length() > 0);
            }
        });
        this.searchButton = toolkit.createButton(searchArea, Messages.ChangelistSearchPage_Search, 8);
        Image searchImage = P4UiSearchPlugin.getDescriptor("icons/depot_search.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.searchButton, (Resource)searchImage);
        this.searchButton.setImage(searchImage);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistSearchPage.this.search();
            }
        });
        this.searchButton.setEnabled(false);
    }

    private void setEnabled(boolean enabled) {
        this.searchButton.setEnabled(enabled);
    }

    private void createResultsArea(Composite parent, FormToolkit toolkit) {
        this.resultsSection = toolkit.createSection(parent, 256);
        this.resultsSection.setExpanded(true);
        GridLayout rsLayout = new GridLayout(1, true);
        rsLayout.marginHeight = 0;
        rsLayout.marginWidth = 0;
        this.resultsSection.setLayout((Layout)rsLayout);
        this.resultsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite area = toolkit.createComposite((Composite)this.resultsSection);
        GridLayout areaLayout = new GridLayout(1, true);
        areaLayout.marginHeight = 0;
        areaLayout.marginWidth = 0;
        area.setLayout((Layout)areaLayout);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultsSection.setClient((Control)area);
        this.resultsViewer = new TreeViewer(toolkit.createTree(area, 4));
        this.resultsViewer.setAutoExpandLevel(2);
        SearchTreeLabelProvider searchLabelProvider = new SearchTreeLabelProvider(this, parent.getDisplay()){

            @Override
            public String getText(Object element) {
                if (element instanceof RevisionMatch) {
                    return ((RevisionMatch)element).getDepotPath();
                }
                return super.getText(element);
            }

            @Override
            public Image getImage(Object element) {
                if (element instanceof RevisionMatch) {
                    String name = ((RevisionMatch)element).getFile().getName();
                    ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
                    if (desc != null) {
                        return (Image)this.imageManager.get((DeviceResourceDescriptor)desc);
                    }
                }
                return super.getImage(element);
            }
        };
        SearchTreeContentProvider searchContentProvider = new SearchTreeContentProvider((StructuredViewer)this.resultsViewer){

            @Override
            public Object[] getElements(Object inputElement) {
                if (this.results.getMatchCount() > 0) {
                    return this.results.getElements();
                }
                return new Object[]{new NoResults(((P4SearchQuery)this.results.getQuery()).getText())};
            }
        };
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)searchLabelProvider, (ILabelDecorator)new SearchLabelDecorator(), null);
        this.resultsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.resultsViewer.setContentProvider((IContentProvider)searchContentProvider);
        this.resultsViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.resultsViewer.setSorter((ViewerSorter)new SearchTreeResultsSorter(){

            @Override
            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof RevisionMatch && e2 instanceof RevisionMatch) {
                    return ((RevisionMatch)e1).getDepotPath().compareToIgnoreCase(((RevisionMatch)e2).getDepotPath());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.resultsViewer.addDoubleClickListener((IDoubleClickListener)new SearchResultsOpenHandler());
        ToolBar toolbar = P4FormUIUtils.createSectionToolbar((FormToolkit)toolkit, (Section)this.resultsSection);
        ToolItem collapse = new ToolItem(toolbar, 8);
        collapse.setToolTipText(Messages.ChangelistSearchPage_CollapseAll);
        Image collapseImage = PerforceUIPlugin.getDescriptor((String)"normal/collapseall.png").createImage();
        collapse.setImage(collapseImage);
        P4UIUtils.registerDisposal((Widget)collapse, (Resource)collapseImage);
        collapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistSearchPage.this.resultsViewer.collapseAll();
            }
        });
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.result != null) {
            String fileInfo = null;
            String matchInfo = null;
            fileInfo = this.fileCount != 1 ? MessageFormat.format(Messages.ChangelistSearchPage_MultipleFiles, this.fileCount) : Messages.ChangelistSearchPage_SingleFile;
            matchInfo = this.matchCount != 1 ? MessageFormat.format(Messages.ChangelistSearchPage_MultipleMatches, this.matchCount) : Messages.ChangelistSearchPage_SingleMatch;
            this.resultsSection.setText(String.valueOf(Messages.ChangelistSearchPage_SearchResultsTitle) + fileInfo + matchInfo);
        } else {
            this.resultsSection.setText(Messages.ChangelistSearchPage_SearchResultsTitle);
        }
        this.resultsSection.layout();
    }

    private IP4Changelist getChangelist() {
        return (IP4Changelist)P4CoreUtils.convert((Object)this.getEditorInput(), IP4Changelist.class);
    }

    private void search() {
        final IP4Changelist list = this.getChangelist();
        if (list == null) {
            return;
        }
        String text = this.searchText.getText();
        if (text.length() == 0) {
            return;
        }
        this.setEnabled(false);
        final QueryOptions options = new QueryOptions(text);
        this.optionsArea.fillOptions(options);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.ChangelistSearchPage_SearchChangelist, Integer.toString(list.getId()));
            }

            public void run(IProgressMonitor monitor) {
                String suffix = "";
                if (list instanceof IP4SubmittedChangelist) {
                    suffix = "@" + list.getId();
                } else if (list instanceof IP4ShelvedChangelist) {
                    suffix = "@=" + list.getId();
                }
                IP4Resource[] iP4ResourceArray = list.getFiles();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource file = iP4ResourceArray[n2];
                    String path = file.getActionPath();
                    if (path != null) {
                        options.addPath(String.valueOf(path) + suffix);
                    }
                    ++n2;
                }
                if (options.getPaths().length > 0) {
                    P4SearchQuery query = new P4SearchQuery(list.getConnection(), options);
                    query.run(monitor);
                    ChangelistSearchPage.this.result = (P4SearchResult)query.getSearchResult();
                    Object[] elements = ChangelistSearchPage.this.result.getElements();
                    ChangelistSearchPage.this.fileCount = elements.length;
                    ChangelistSearchPage.this.matchCount = 0;
                    Object[] objectArray = elements;
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Match[] matches;
                        Object element = objectArray[n4];
                        Match[] matchArray = matches = ChangelistSearchPage.this.result.getMatches(element);
                        int n5 = matches.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Match match = matchArray[n6];
                            if (IFileLineMatch.MatchType.MATCH == ((FileMatch)match).getMatch().getType()) {
                                ChangelistSearchPage changelistSearchPage = ChangelistSearchPage.this;
                                changelistSearchPage.matchCount = changelistSearchPage.matchCount + 1;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (P4UIUtils.okToUse((Widget)ChangelistSearchPage.this.getPartControl())) {
                                ChangelistSearchPage.this.resultsViewer.setInput((Object)ChangelistSearchPage.this.result);
                                ChangelistSearchPage.this.updateTitle();
                                ChangelistSearchPage.this.setEnabled(true);
                            }
                        }
                    });
                } else {
                    PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChangelistSearchPage.this.setEnabled(true);
                        }
                    });
                }
            }
        }, (ISchedulingRule)this.searchRule);
    }

    @Override
    public P4SearchResult getResult() {
        return this.result;
    }

    private static class NoResults
    extends WorkbenchAdapter {
        private String text;

        public NoResults(String searchText) {
            this.text = searchText;
        }

        public String getLabel(Object object) {
            return MessageFormat.format(Messages.ChangelistSearchPage_NoSearchResults, this.text);
        }
    }
}

