/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model;

import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.PropertyElement;
import org.eclipse.core.runtime.Assert;

public abstract class BranchGraphElement
extends PropertyElement
implements IBranchGraphElement {
    private final String id;
    private String name;
    private IBranchGraph graph;

    public BranchGraphElement(String id, String name, IBranchGraph graph) {
        this.id = id;
        this.name = name;
        this.graph = graph;
        Assert.isNotNull((Object)this.id, (String)"Id of branch graph element cannot be null");
        Assert.isTrue((this.id.length() > 0 ? 1 : 0) != 0, (String)"Id of branch graph element cannot be empty");
    }

    public BranchGraphElement(String id, IBranchGraph graph) {
        this(id, id, graph);
    }

    public BranchGraphElement(String id, String name) {
        this(id, id, null);
    }

    @Override
    public boolean setName(String name) {
        boolean set = false;
        if (name != null && name.length() > 0 && !name.equals(this.name)) {
            String previous = this.name;
            this.name = name;
            this.changeSupport.firePropertyChange("name", previous, this.name);
            set = true;
        }
        return set;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IBranchGraphElement) {
            IBranchGraphElement other = (IBranchGraphElement)obj;
            IBranchGraph graph = this.getGraph();
            IBranchGraph otherGraph = other.getGraph();
            if (graph == null) {
                return otherGraph == null && this.getId().equals(other.getId());
            }
            return this.getId().equals(other.getId());
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IBranchGraph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(IBranchGraph graph) {
        this.graph = graph;
    }
}

