/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder.xml;

import com.perforce.team.core.mergequest.builder.xml.IElementBuilder;
import com.perforce.team.core.mergequest.builder.xml.MappingBuilder;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import org.w3c.dom.Element;

public class BranchSpecMappingBuilder
extends MappingBuilder
implements IElementBuilder {
    public static final String BRANCH_SPEC_MAPPING_ELEMENT = "branchSpecMapping";

    @Override
    public IBranchGraphElement initialize(Element element, IBranchGraph graph) {
        BranchSpecMapping mapping = null;
        String id = element.getAttribute("id");
        if (id.length() > 0) {
            mapping = graph.createBranchSpecMapping(id);
            this.loadMappingFields(element, mapping);
            graph.add(mapping);
        }
        return mapping;
    }

    @Override
    public void save(Element parent, IBranchGraphElement element) {
        if (element instanceof BranchSpecMapping) {
            BranchSpecMapping mapping = (BranchSpecMapping)element;
            Element mappingElement = parent.getOwnerDocument().createElement(BRANCH_SPEC_MAPPING_ELEMENT);
            this.saveMappingFields(mappingElement, mapping);
            parent.appendChild(mappingElement);
        }
    }
}

