/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model;

import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.factory.GraphFactory;
import com.perforce.team.core.mergequest.model.factory.IBranchGraphElementFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;

public class BranchGraphContainer
extends PlatformObject
implements IBranchGraphContainer {
    private Map<String, IBranchGraph> graphs = new LinkedHashMap<String, IBranchGraph>();
    private IBranchGraphElementFactory graphFactory = new GraphFactory();

    @Override
    public IBranchGraph createGraph(String id) {
        return (IBranchGraph)this.graphFactory.create(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(IBranchGraph graph) {
        boolean added = false;
        if (graph != null) {
            Map<String, IBranchGraph> map = this.graphs;
            synchronized (map) {
                if (!this.graphs.containsKey(graph.getId())) {
                    this.graphs.put(graph.getId(), graph);
                    added = true;
                }
            }
        }
        return added;
    }

    @Override
    public IBranchGraph getGraph(String id) {
        return id != null ? this.graphs.get(id) : null;
    }

    @Override
    public boolean remove(IBranchGraph graph) {
        return graph != null ? this.graphs.remove(graph.getId()) != null : false;
    }

    @Override
    public IBranchGraph[] getGraphs() {
        return this.graphs.values().toArray(new IBranchGraph[this.graphs.size()]);
    }

    @Override
    public int size() {
        return this.graphs.size();
    }

    @Override
    public void setGraphs(IBranchGraph[] graphs) {
        this.graphs.clear();
        if (graphs != null && graphs.length > 0) {
            IBranchGraph[] iBranchGraphArray = graphs;
            int n = graphs.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchGraph graph = iBranchGraphArray[n2];
                this.add(graph);
                ++n2;
            }
        }
    }

    @Override
    public IBranchGraph getGraphByName(String name) {
        IBranchGraph graph = null;
        if (name != null) {
            IBranchGraph[] iBranchGraphArray = this.getGraphs();
            int n = iBranchGraphArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchGraph potential = iBranchGraphArray[n2];
                if (name.equals(potential.getName())) {
                    graph = potential;
                    break;
                }
                ++n2;
            }
        }
        return graph;
    }

    @Override
    public IBranchGraph importGraph(IBranchGraph graph) {
        IBranchGraph newGraph = null;
        if (graph != null) {
            String id = graph.getId();
            if (this.graphs.containsKey(id)) {
                id = null;
            }
            newGraph = this.createGraph(id);
            newGraph.setName(graph.getName());
            newGraph.setConnection(graph.getConnection());
            IBranchGraphElement[] iBranchGraphElementArray = graph.getElements();
            int n = iBranchGraphElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchGraphElement element = iBranchGraphElementArray[n2];
                if (graph.remove(element)) {
                    newGraph.add(element);
                }
                ++n2;
            }
            newGraph.updateFactories();
            if (!this.add(newGraph)) {
                newGraph = null;
            }
        }
        return newGraph;
    }
}

