/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder.xml;

import com.perforce.team.core.mergequest.builder.xml.ElementBuilder;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import org.w3c.dom.Element;

public class BranchBuilder
extends ElementBuilder {
    public static final String BRANCH_ELEMENT = "branch";

    @Override
    public IBranchGraphElement initialize(Element element, IBranchGraph graph) {
        Branch branch = null;
        String id = element.getAttribute("id");
        if (id.length() > 0) {
            String branchName = element.getAttribute("name");
            String type = element.getAttribute("type");
            branch = graph.createBranch(id);
            branch.setType(type);
            branch.setName(branchName);
            int x = this.getInteger(element, "x");
            int y = this.getInteger(element, "y");
            int width = this.getInteger(element, "width");
            int height = this.getInteger(element, "height");
            branch.setLocation(x, y);
            branch.setSize(width, height);
            graph.add(branch);
        }
        return branch;
    }

    @Override
    public void save(Element parent, IBranchGraphElement element) {
        if (element instanceof Branch) {
            Branch branch = (Branch)element;
            Element branchElement = parent.getOwnerDocument().createElement(BRANCH_ELEMENT);
            branchElement.setAttribute("id", branch.getId());
            branchElement.setAttribute("name", branch.getName());
            branchElement.setAttribute("type", branch.getType());
            branchElement.setAttribute("x", Integer.toString(branch.getX()));
            branchElement.setAttribute("y", Integer.toString(branch.getY()));
            branchElement.setAttribute("width", Integer.toString(branch.getWidth()));
            branchElement.setAttribute("height", Integer.toString(branch.getHeight()));
            parent.appendChild(branchElement);
        }
    }
}

