/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder;

import com.perforce.team.core.mergequest.builder.xml.XmlBranchGraphBuilder;
import com.perforce.team.core.mergequest.model.IBranchGraphContainer;
import com.perforce.team.core.mergequest.model.factory.IContainerFactory;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Assert;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DepotPathBranchGraphBuilder
extends XmlBranchGraphBuilder {
    private IP4Connection connection;
    private String path;

    public DepotPathBranchGraphBuilder(IP4Connection connection, String path) {
        Assert.isNotNull((Object)connection, (String)"Connection cannot be null");
        Assert.isNotNull((Object)path, (String)"Path cannot be null");
        this.connection = connection;
        this.path = path;
    }

    public DepotPathBranchGraphBuilder(IContainerFactory factory, IP4Connection connection, String path) {
        super(factory);
        Assert.isNotNull((Object)connection, (String)"Connection cannot be null");
        Assert.isNotNull((Object)path, (String)"Path cannot be null");
        this.connection = connection;
        this.path = path;
    }

    @Override
    public IBranchGraphContainer load() throws IOException {
        IBranchGraphContainer container = null;
        InputStream stream = null;
        IP4File file = this.connection.getFile(this.path);
        if (file != null) {
            stream = file.getRemoteContents();
        }
        IOException ioException = null;
        try {
            try {
                if (stream != null) {
                    container = this.unformat(new InputSource(stream));
                }
                if (container == null) {
                    container = this.unformat(null);
                }
            }
            catch (SAXException e) {
                ioException = new IOException(e);
                throw ioException;
            }
            catch (IOException e) {
                ioException = e;
                throw ioException;
            }
        }
        finally {
            this.logLoadException(ioException);
        }
        return container;
    }

    @Override
    public void persist(IBranchGraphContainer container) {
    }
}

