/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java.synchronize;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.P4Collection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;

public class PerforceSyncFile
extends CachedResourceVariant {
    private IP4File p4File;
    private VariantType type;

    public PerforceSyncFile(IP4File file, VariantType type) {
        IFileSpec spec;
        this.p4File = file;
        this.type = type;
        if (this.p4File.isUnresolved() && (spec = this.p4File.getIntegrationSpec()) == null) {
            this.updateBaseNoResolve(this.p4File);
        }
    }

    private InputStream getUnresolvedBaseStream(IP4File file) {
        int base;
        InputStream stream = null;
        IFileSpec spec = file.getIntegrationSpec();
        if (spec != null && (base = spec.getStartFromRev()) >= 0) {
            String from = spec.getFromFile();
            if (from != null) {
                if ((file = file.getConnection().getFile((IFileSpec)new FileSpec(from))) != null) {
                    stream = file.getRemoteContents(base);
                }
            } else {
                stream = file.getRemoteContents(base);
            }
        }
        return stream;
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        InputStream reader = null;
        switch (this.type) {
            case BASE: {
                if (this.p4File.isUnresolved()) {
                    reader = this.getUnresolvedBaseStream(this.p4File);
                    if (reader != null) break;
                    this.updateBaseNoResolve(this.p4File);
                    reader = this.getUnresolvedBaseStream(this.p4File);
                    break;
                }
                reader = this.p4File.getRemoteContents(this.p4File.getHaveRevision());
                break;
            }
            case REMOTE: {
                reader = this.p4File.getRemoteContents(this.p4File.getHeadRevision());
                break;
            }
        }
        if (reader == null) {
            reader = new ByteArrayInputStream(new byte[0]);
        }
        this.setContents(reader, monitor);
    }

    private void updateBase(IP4File file) {
        P4Collection collection = new P4Collection();
        collection.add(file);
        collection.resolve(new ResolveFilesAutoOptions().setShowActionsOnly(true).setShowBase(true));
    }

    private void updateBaseNoResolve(IP4File file) {
        P4Collection collection = new P4Collection();
        collection.add(file);
    }

    protected String getCacheId() {
        return String.valueOf(this.p4File.getRemotePath()) + this.getContentIdentifier();
    }

    protected String getCachePath() {
        return String.valueOf(this.p4File.getRemotePath()) + this.getContentIdentifier();
    }

    public byte[] asBytes() {
        return this.getCachePath().getBytes(CharsetDefs.DEFAULT);
    }

    public String getContentIdentifier() {
        StringBuilder revision = new StringBuilder();
        switch (this.type) {
            case BASE: {
                if (this.p4File.isUnresolved()) {
                    IFileSpec spec = this.p4File.getIntegrationSpec();
                    if (spec == null) {
                        this.updateBaseNoResolve(this.p4File);
                    }
                    if (spec == null || spec.getStartFromRev() < 0) break;
                    String fromFile = spec.getFromFile();
                    if (fromFile != null) {
                        int lastSlash = fromFile.lastIndexOf(47);
                        if (lastSlash >= 0 && lastSlash + 1 < fromFile.length()) {
                            revision.append(fromFile.substring(lastSlash + 1));
                        } else {
                            revision.append(fromFile);
                        }
                    }
                    revision.append('#');
                    revision.append(spec.getStartFromRev());
                    break;
                }
                if (this.p4File.openedForDelete()) {
                    revision.append('#');
                    revision.append(this.p4File.getHeadRevision());
                    break;
                }
                revision.append('#');
                revision.append(this.p4File.getHaveRevision());
                break;
            }
            case REMOTE: {
                revision.append('#');
                revision.append(this.p4File.getHeadRevision());
                break;
            }
        }
        if (revision.length() == 0) {
            revision.append("#0");
        }
        return revision.toString();
    }

    public String getName() {
        return this.p4File.getName();
    }

    public boolean isContainer() {
        return false;
    }

    public IP4File getFile() {
        return this.p4File;
    }

    public static enum VariantType {
        BASE,
        REMOTE;

    }
}

