/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Changelist;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4ShelveFile;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class P4ShelvedChangelist
extends P4Changelist
implements IP4ShelvedChangelist {
    private boolean hasReview;

    public P4ShelvedChangelist(IP4Connection connection, IChangelist changelist, boolean readOnly) {
        super(connection, changelist);
        this.readOnly = readOnly;
    }

    @Override
    public IP4Resource[] getFiles() {
        ArrayList<IP4Resource> files = new ArrayList<IP4Resource>();
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4ShelveFile) {
                files.add(resource);
            }
            ++n2;
        }
        return files.toArray(new IP4Resource[files.size()]);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IP4ShelvedChangelist && super.equals(obj);
    }

    @Override
    public void refresh() {
        IP4Connection connection = this.getConnection();
        final int id = this.getId();
        if (id > 0 && connection != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    IServer server = client.getServer();
                    if (server != null) {
                        HashSet<P4ShelveFile> resources = new HashSet<P4ShelveFile>();
                        FileStatOutputOptions options = new FileStatOutputOptions();
                        options.setShelvedFiles(true);
                        List files = server.getExtendedFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{"//..."}), 0, -1, id, options, null);
                        for (IExtendedFileSpec file : files) {
                            if (!P4ShelvedChangelist.this.isValidFileSpec(file)) continue;
                            P4File p4File = new P4File((IFileSpec)file, P4ShelvedChangelist.this, true);
                            P4ShelveFile shelveFile = new P4ShelveFile(P4ShelvedChangelist.this.getChangelist(), p4File, P4ShelvedChangelist.this.readOnly);
                            resources.add(shelveFile);
                        }
                        P4ShelvedChangelist.this.cachedFiles = resources;
                    }
                }
            };
            this.runOperation(op);
        }
        this.needsRefresh = false;
    }

    @Override
    public IFileSpec[] unshelve() {
        return this.unshelve(-1);
    }

    @Override
    public IFileSpec[] unshelve(int toChangelist) {
        return this.unshelve(null, toChangelist);
    }

    @Override
    public IFileSpec[] unshelve(IP4Resource[] files) {
        return this.unshelve(files, -1);
    }

    @Override
    public IFileSpec[] unshelve(IP4Resource[] files, int toChangelist) {
        return this.unshelve(files, toChangelist, false);
    }

    @Override
    public IFileSpec[] unshelve(IP4Resource[] files, final int toChangelist, final boolean overwrite) {
        final int id = this.getId();
        final ArrayList unshelveSpecs = new ArrayList();
        if (id > 0) {
            final ArrayList<IFileSpec> specs = new ArrayList<IFileSpec>();
            if (files != null) {
                ArrayList<String> actionPaths = new ArrayList<String>();
                IP4Resource[] iP4ResourceArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource file = iP4ResourceArray[n2];
                    String path = file.getActionPath(IP4Resource.Type.REMOTE);
                    if (path != null) {
                        actionPaths.add(path);
                    }
                    ++n2;
                }
                specs.addAll(P4FileSpecBuilder.makeFileSpecList(actionPaths.toArray(new String[actionPaths.size()])));
            }
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List output = client.unshelveChangelist(id, specs, toChangelist, overwrite, false);
                    unshelveSpecs.addAll(output);
                    P4ShelvedChangelist.this.handleErrors(output.toArray(new IFileSpec[output.size()]));
                }
            };
            this.runOperation(op);
        }
        return unshelveSpecs.toArray(new IFileSpec[unshelveSpecs.size()]);
    }

    public String toString() {
        return ("P4ShelvedChangelist:[" + this.getDescription() + "]").replaceAll("[\n|\r]", "");
    }

    @Override
    public boolean hasReview() {
        return this.hasReview;
    }

    @Override
    public void setHasReview(boolean hasReview) {
        this.hasReview = hasReview;
    }
}

