/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4ChangelistRevision;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4ChangelistRevision;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Container;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;

public class P4Folder
extends P4Container
implements IP4Folder {
    private IP4Container parent;
    private String name;
    private IP4Connection connection;
    private String localPath = null;
    private String depotPath = null;

    public P4Folder(IP4Connection connection, String localPath, String depotPath) {
        if (connection != null) {
            int index;
            this.connection = connection;
            this.localPath = localPath;
            this.depotPath = depotPath;
            if (this.depotPath != null && (index = this.depotPath.lastIndexOf(47)) >= 0 && index + 1 < this.depotPath.length()) {
                this.name = this.depotPath.substring(index + 1);
            }
            this.parent = connection;
        }
    }

    public P4Folder(IP4Container parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public void edit(final int changelist) {
        String action;
        IClient client = this.getClient();
        if (client != null && (action = this.getActionPath()) != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    client.editFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{action}), false, false, changelist, null);
                }
            };
            this.runOperation(op);
        }
    }

    @Override
    public void delete(final int changelist) {
        String action;
        IClient client = this.getClient();
        if (client != null && (action = this.getActionPath()) != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    client.deleteFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{action}), changelist, false);
                }
            };
            this.runOperation(op);
        }
    }

    @Override
    public void revert() {
        String action;
        IClient client = this.getClient();
        if (client != null && (action = this.getActionPath()) != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    client.revertFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{action}), false, -1, false, false);
                }
            };
            this.runOperation(op);
        }
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String rpath = this.getRemotePath();
        if (rpath != null) {
            return rpath;
        }
        String lpath = this.getLocalPath();
        if (lpath != null) {
            return lpath;
        }
        return this.name;
    }

    @Override
    public String getRemotePath() {
        if (this.depotPath != null) {
            return this.depotPath;
        }
        if (this.parent != null && this.parent.getRemotePath() != null) {
            return String.valueOf(this.parent.getRemotePath()) + "/" + this.getName();
        }
        return null;
    }

    @Override
    public IP4Container getParent() {
        return this.parent;
    }

    public String toString() {
        String name = this.getName();
        if (name == null) {
            name = super.toString();
        }
        return name;
    }

    @Override
    public IClient getClient() {
        if (this.parent != null) {
            return this.parent.getClient();
        }
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.parent != null) {
            return this.parent.getConnection();
        }
        return null;
    }

    @Override
    public boolean equals(Object otherFolder) {
        if (this == otherFolder) {
            return true;
        }
        if (otherFolder instanceof IP4Folder) {
            IP4Folder folder = (IP4Folder)otherFolder;
            if (!this.connectionEquals(folder)) {
                return false;
            }
            if (this.parent != null && this.parent.equals(folder.getParent())) {
                if (this.getRemotePath() != null && this.getRemotePath().equals(folder.getRemotePath())) {
                    return true;
                }
                if (this.getRemotePath() == null && folder.getRemotePath() == null && this.getLocalPath() != null && this.getLocalPath().equals(folder.getLocalPath())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        String path = this.getRemotePath();
        if (path == null) {
            path = this.getLocalPath();
        }
        int hash = path != null ? path.hashCode() : super.hashCode();
        return hash;
    }

    @Override
    public String getClientPath() {
        return null;
    }

    @Override
    public IContainer[] getLocalContainers() {
        return PerforceProviderPlugin.getLocalContainers(this.getLocalPath());
    }

    @Override
    public String getFirstWhereRemotePath() {
        String path;
        final String[] firstRemotePathMapping = new String[1];
        IClient client = this.getClient();
        if (client != null && (path = this.getLocalPath()) != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{path});
                    specs = P4Folder.this.convertToEllipsisSpecs(specs);
                    specs = client.where(specs);
                    specs = P4FileSpecBuilder.getValidFileSpecs(specs);
                    if ((specs = P4Folder.this.filterUnmapped(specs)).size() >= 1) {
                        firstRemotePathMapping[0] = P4Folder.this.convertFromEllipsis(specs.get(0).getDepotPathString());
                    }
                }
            };
            this.runOperation(op);
        }
        return firstRemotePathMapping[0];
    }

    @Override
    public void updateLocation() {
        final String path = this.getRemotePath();
        if (path != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    IStreamSummary summary;
                    IP4Stream p4stream;
                    String stream;
                    List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{path});
                    specs = P4Folder.this.convertToEllipsisSpecs(specs);
                    if (((IFileSpec)(specs = client.where(specs)).get(0)).getSeverityCode() >= 3) {
                        throw new P4JavaException(specs.get(0).getStatusMessage());
                    }
                    specs = P4FileSpecBuilder.getValidFileSpecs(specs);
                    specs = P4Folder.this.filterUnmapped(specs);
                    for (IFileSpec spec : specs) {
                        String newDepotPath = P4Folder.this.convertFromEllipsis(spec.getDepotPathString());
                        if (!path.equals(newDepotPath)) continue;
                        P4Folder.this.depotPath = newDepotPath;
                        P4Folder.this.localPath = P4Folder.this.convertFromEllipsis(spec.getLocalPathString());
                        break;
                    }
                    if (P4Folder.this.depotPath == null && (stream = P4Folder.this.getConnection().getClient().getStream()) != null && (p4stream = P4Folder.this.getConnection().getStream(stream)) != null && (summary = p4stream.getStreamSummary()) != null && StringUtils.equals((CharSequence)StringUtils.stripEnd((String)summary.getStream(), (String)"/"), (CharSequence)StringUtils.stripEnd((String)path, (String)"/"))) {
                        PerforceProviderPlugin.logInfo("Import stream as project...");
                        P4Folder.this.depotPath = path;
                        P4Folder.this.localPath = P4Folder.this.getConnection().getClientRoot();
                    }
                }
            };
            this.runOperation(op);
        }
    }

    @Override
    public IP4ChangelistRevision[] getCompleteHistory(IProgressMonitor monitor) {
        final HashMap revisions = new HashMap();
        monitor.setTaskName(MessageFormat.format(Messages.P4Folder_1, this.getName()));
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                List<IFileSpec> specs;
                Map history;
                String path = P4Folder.this.getActionPath();
                if (path != null && (history = server.getRevisionHistory(specs = P4FileSpecBuilder.makeFileSpecList(path), 0, false, false, true, false)) != null) {
                    for (List data : history.values()) {
                        if (data == null) continue;
                        for (IFileRevisionData revision : data) {
                            P4ChangelistRevision changelistRev = (P4ChangelistRevision)revisions.get(revision.getChangelistId());
                            if (changelistRev == null) {
                                changelistRev = new P4ChangelistRevision(P4Folder.this.getConnection());
                                revisions.put(revision.getChangelistId(), changelistRev);
                            }
                            changelistRev.add(revision);
                        }
                    }
                }
            }
        };
        this.runOperation(operation);
        return revisions.values().toArray(new IP4ChangelistRevision[revisions.size()]);
    }
}

