/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.core.file.IntegrationOptions;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.ChangelistSelection;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.LocalRevision;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4Revision;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.P4ShelveFile;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class P4File
extends P4Resource
implements IP4File {
    private IFileSpec fileSpec;
    private IP4Container parent;
    private String localPath = null;
    private IFileSpec[] integSpecs = null;

    public static boolean isActionDelete(FileAction action) {
        return FileAction.DELETE == action || FileAction.MOVE_DELETE == action;
    }

    public static boolean isActionEdit(FileAction action) {
        return FileAction.EDIT == action || FileAction.INTEGRATE == action;
    }

    public static boolean isActionAdd(FileAction action) {
        return FileAction.ADD == action || FileAction.BRANCH == action || FileAction.MOVE_ADD == action;
    }

    public P4File(IP4Connection connection, String localPath) {
        if (connection != null) {
            this.parent = connection;
            this.localPath = this.getLocalResourcePath(localPath);
        }
    }

    public P4File(IFileSpec fileSpec, IP4Container parent, boolean readOnly) {
        this(fileSpec, parent);
        this.readOnly = readOnly;
    }

    public P4File(IFileSpec fileSpec, IP4Container parent) {
        this.fileSpec = fileSpec;
        this.parent = parent;
        if (this.fileSpec != null) {
            this.localPath = this.getLocalResourcePath(this.fileSpec.getClientPathString());
        }
        this.updateServer();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IP4File)) {
            return false;
        }
        return super.equals(obj);
    }

    private List<IFileSpec> getActionSpec() {
        return P4FileSpecBuilder.makeFileSpecList(new String[]{this.getActionPath()});
    }

    private void updateServer() {
        IServer server;
        IP4Connection connection;
        if (this.fileSpec != null && (connection = this.getConnection()) != null && (server = connection.getServer()) != null && this.fileSpec instanceof FileSpec) {
            ((FileSpec)this.fileSpec).setServer(server);
        }
    }

    private void checkSpec() {
        if (this.fileSpec == null) {
            boolean retry = true;
            while (retry) {
                retry = false;
                try {
                    List specs;
                    IServer server;
                    IClient client = this.getClient();
                    if (client == null || (server = client.getServer()) == null || (specs = this.getClient().getServer().getDepotFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{this.getLocalPath()}), false)).size() != 1 || specs.get(0) == null || !FileSpecOpStatus.VALID.equals((Object)((IFileSpec)specs.get(0)).getOpStatus())) continue;
                    this.fileSpec = (IFileSpec)specs.get(0);
                    this.updateServer();
                }
                catch (P4JavaException e) {
                    retry = this.handleError(e);
                    PerforceProviderPlugin.logError(e);
                }
                catch (P4JavaError e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
        }
    }

    @Override
    public void add(final int changelist) {
        if (this.readOnly) {
            return;
        }
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                client.addFiles(P4File.this.getActionSpec(), false, changelist, null, true);
            }
        };
        this.runOperation(op);
    }

    @Override
    public void edit(final int changelist) {
        if (this.readOnly) {
            return;
        }
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                client.editFiles(P4File.this.getActionSpec(), false, false, changelist, null);
            }
        };
        this.runOperation(op);
    }

    @Override
    public void delete(final int changelist) {
        if (this.readOnly) {
            return;
        }
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                client.deleteFiles(P4File.this.getActionSpec(), changelist, false);
            }
        };
        this.runOperation(op);
    }

    @Override
    public int getHaveRevision() {
        int have = 0;
        if (this.fileSpec instanceof IExtendedFileSpec) {
            have = ((IExtendedFileSpec)this.fileSpec).getHaveRev();
            have = Math.max(0, have);
        }
        return have;
    }

    @Override
    public int getHeadRevision() {
        int head = 0;
        if (this.fileSpec instanceof IExtendedFileSpec) {
            head = ((IExtendedFileSpec)this.fileSpec).getHeadRev();
        } else if (this.fileSpec != null) {
            head = this.fileSpec.getStartRevision();
        }
        head = Math.max(0, head);
        return head;
    }

    @Override
    public IFileRevisionData[] getHistory() {
        return this.getHistory(true);
    }

    @Override
    public IFileSpec getP4JFile() {
        return this.fileSpec;
    }

    @Override
    public void ignore() {
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean isLocal() {
        if (this.fileSpec != null) {
            return this.fileSpec.getClientPath() != null;
        }
        return false;
    }

    @Override
    public boolean isRemote() {
        if (this.fileSpec instanceof IExtendedFileSpec) {
            return ((IExtendedFileSpec)this.fileSpec).getHeadRev() > 0;
        }
        return false;
    }

    @Override
    public boolean openedForAdd() {
        return P4File.isActionAdd(this.getAction());
    }

    @Override
    public boolean openedForDelete() {
        return P4File.isActionDelete(this.getAction());
    }

    @Override
    public boolean openedForEdit() {
        return P4File.isActionEdit(this.getAction());
    }

    @Override
    public void revert() {
        if (this.readOnly) {
            return;
        }
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                client.revertFiles(P4File.this.getActionSpec(), false, -1, false, false);
            }
        };
        this.runOperation(op);
    }

    @Override
    public void sync(IProgressMonitor monitor) {
    }

    @Override
    public String getAs(String contentType) {
        return null;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[0];
    }

    @Override
    public String getLocalPath() {
        if (this.fileSpec != null) {
            String path = this.fileSpec.getLocalPathString();
            if (path == null) {
                path = this.fileSpec.getClientPathString();
            }
            path = this.getLocalResourcePath(path);
            return path;
        }
        if (this.localPath != null) {
            return this.localPath;
        }
        return null;
    }

    @Override
    public String getName() {
        int lastSlash;
        if (this.fileSpec != null) {
            int lastSlash2;
            String name = this.fileSpec.getDepotPathString();
            if (name == null) {
                name = this.fileSpec.getOriginalPathString();
            }
            if (name == null) {
                name = this.fileSpec.getPreferredPathString();
            }
            if (name != null && (lastSlash2 = name.lastIndexOf(47)) != -1 && lastSlash2 + 1 < name.length()) {
                return name.substring(lastSlash2 + 1);
            }
        }
        if (this.localPath != null && (lastSlash = this.localPath.lastIndexOf(File.separatorChar)) != -1 && lastSlash + 1 < this.localPath.length()) {
            return this.localPath.substring(lastSlash + 1);
        }
        return this.localPath;
    }

    @Override
    public String getRemotePath() {
        if (this.fileSpec != null) {
            return this.fileSpec.getDepotPathString();
        }
        return null;
    }

    @Override
    public IP4Container getParent() {
        return this.parent;
    }

    public String toString() {
        String name = this.getName();
        if (name == null) {
            name = super.toString();
        }
        return name;
    }

    @Override
    public IClient getClient() {
        if (this.parent != null) {
            return this.parent.getClient();
        }
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        if (this.parent != null) {
            return this.parent.getConnection();
        }
        return null;
    }

    @Override
    public String getActionPath() {
        String path = this.getRemotePath();
        if (path == null) {
            path = this.getLocalPath();
        }
        if (path == null && this.fileSpec != null) {
            path = this.fileSpec.getOriginalPathString();
        }
        return path;
    }

    @Override
    public String getActionPath(IP4Resource.Type type) {
        String path = null;
        if (type == IP4Resource.Type.REMOTE) {
            path = this.getRemotePath();
        } else if (type == IP4Resource.Type.LOCAL) {
            path = this.getLocalPath();
        }
        if (path == null) {
            path = this.getActionPath();
        }
        return path;
    }

    @Override
    public IFileRevisionData[] getHistory(final boolean displayBranching) {
        this.checkSpec();
        final ArrayList fileHistory = new ArrayList();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                List<IFileSpec> specs;
                Map history;
                String path = P4File.this.getActionPath();
                if (path != null && (history = server.getRevisionHistory(specs = P4FileSpecBuilder.makeFileSpecList(path), 0, false, displayBranching, true, false)) != null) {
                    for (List data : history.values()) {
                        if (data == null) continue;
                        fileHistory.addAll(data);
                    }
                }
            }
        };
        this.runOperation(operation);
        return fileHistory.toArray(new IFileRevisionData[fileHistory.size()]);
    }

    @Override
    public String getClientPath() {
        if (this.fileSpec != null) {
            return this.fileSpec.getClientPathString();
        }
        return null;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public String getHeadType() {
        if (this.fileSpec instanceof IExtendedFileSpec) {
            return ((IExtendedFileSpec)this.fileSpec).getHeadType();
        }
        if (this.fileSpec != null) {
            return this.fileSpec.getFileType();
        }
        return null;
    }

    @Override
    public String getOpenedType() {
        String type = null;
        if (this.fileSpec != null) {
            if (this.fileSpec instanceof IExtendedFileSpec) {
                type = ((IExtendedFileSpec)this.fileSpec).getOpenType();
            }
            if (type == null) {
                type = this.fileSpec.getFileType();
            }
        }
        return type;
    }

    @Override
    public FileAction getAction() {
        if (this.fileSpec != null) {
            return this.fileSpec.getAction();
        }
        return null;
    }

    @Override
    public FileAction getHeadAction() {
        if (this.fileSpec instanceof IExtendedFileSpec) {
            return ((IExtendedFileSpec)this.fileSpec).getHeadAction();
        }
        return null;
    }

    private void refreshFile() throws P4JavaException {
        this.integSpecs = null;
        IClient client = this.getClient();
        if (client != null) {
            try {
                List<IFileSpec> actionSpecs = this.getActionSpec();
                if (actionSpecs != null && !actionSpecs.isEmpty()) {
                    List specs = client.getServer().getExtendedFiles(this.getActionSpec(), 0, -1, -1, null, null);
                    if (specs.size() == 1) {
                        this.setFileSpec((IFileSpec)specs.get(0));
                    }
                } else {
                    this.fileSpec = null;
                }
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
    }

    @Override
    public void refresh() {
        if (this.readOnly) {
            return;
        }
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                this.refreshFile();
            }
            catch (P4JavaException e) {
                retry = this.handleError(e);
                PerforceProviderPlugin.logError(e);
            }
        }
    }

    @Override
    public boolean isSynced() {
        return (this.getHeadRevision() > 0 || this.getHaveRevision() > 0) && this.getHeadRevision() == this.getHaveRevision();
    }

    @Override
    public IP4PendingChangelist getChangelist() {
        return this.getChangelist(false);
    }

    @Override
    public IP4PendingChangelist getChangelist(boolean fetchIfNotFound) {
        return this.getChangelist(fetchIfNotFound, false);
    }

    @Override
    public IP4PendingChangelist getChangelist(boolean fetchIfNotFound, boolean ignoreErrors) {
        IP4PendingChangelist list = null;
        IP4Connection connection = this.getConnection();
        if (connection != null && this.fileSpec != null && this.isOpened()) {
            list = connection.getPendingChangelist(this.fileSpec.getChangelistId(), fetchIfNotFound, ignoreErrors);
        }
        return list;
    }

    @Override
    public boolean isOpened() {
        return this.fileSpec != null && this.fileSpec.getAction() != null;
    }

    @Override
    public InputStream getRemoteContents() {
        if (this.fileSpec != null) {
            boolean retry = true;
            while (retry) {
                retry = false;
                try {
                    return this.fileSpec.getContents(true);
                }
                catch (P4JavaException e) {
                    retry = this.handleError(e);
                    PerforceProviderPlugin.logError(e);
                }
            }
        }
        return null;
    }

    @Override
    public InputStream getHeadContents() {
        return this.getRemoteContents(this.getHeadRevision());
    }

    @Override
    public InputStream getHaveContents() {
        return this.getRemoteContents(this.getHaveRevision());
    }

    @Override
    public InputStream getRemoteContents(int revision) {
        InputStream stream = this.getRemoteContents("#" + Integer.toString(revision));
        return stream;
    }

    @Override
    public InputStream getRemoteContents(String revision) {
        final InputStream[] stream = new InputStream[1];
        if (this.fileSpec != null) {
            String path = this.fileSpec.getDepotPathString();
            if (path == null) {
                path = this.fileSpec.getOriginalPathString();
            }
            path = String.valueOf(path) + revision;
            final List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{path});
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    stream[0] = server.getFileContents(specs, false, true);
                }
            };
            this.runOperation(operation);
        }
        return stream[0];
    }

    @Override
    public void refresh(int depth) {
        this.refresh();
    }

    private void updateChangelists(int previousChangelist, int newChangelist, P4Collection refreshEventContainer) {
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            IP4PendingChangelist newList;
            IP4PendingChangelist oldList;
            if (previousChangelist > -1 && previousChangelist != newChangelist && (oldList = connection.getPendingChangelist(previousChangelist, false, true)) != null && oldList.removeFile(this)) {
                if (refreshEventContainer != null) {
                    refreshEventContainer.add(oldList);
                } else {
                    P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, oldList));
                }
            }
            if (newChangelist > -1 && newChangelist != previousChangelist && (newList = connection.getPendingChangelist(newChangelist, this.isOpened(), true)) != null) {
                newList.addFile(this);
            }
        }
    }

    @Override
    public void setFileSpec(IFileSpec spec) {
        this.setFileSpec(spec, null, true);
    }

    @Override
    public void setFileSpec(IFileSpec spec, final P4Collection refreshEventContainer, final boolean updateChangelist) {
        final int previousChangelist = this.getChangelistId();
        if (spec != null && FileSpecOpStatus.VALID == spec.getOpStatus()) {
            String depot;
            int lastSlash;
            IP4Connection connection;
            this.fileSpec = spec;
            int newChangelist = this.getChangelistId();
            this.updateServer();
            this.localPath = this.getLocalResourcePath(this.fileSpec.getClientPathString());
            if (this.fileSpec.getDepotPath() != null && this.parent instanceof IP4Connection && (connection = this.getConnection()) != null && (lastSlash = (depot = this.fileSpec.getDepotPathString()).lastIndexOf(47)) >= 0) {
                String parentPath = depot.substring(0, lastSlash);
                this.parent = connection.getFolder(parentPath, false);
            }
            this.notifyListeners(new P4Event(P4Event.EventType.REFRESHED, this));
            connection = this.getConnection();
            if (connection != null) {
                connection.updateResource(this);
                if (updateChangelist) {
                    this.updateChangelists(previousChangelist, newChangelist, refreshEventContainer);
                }
            }
        } else if (this.fileSpec != null) {
            Tracing.printExecTime3(Policy.DEBUG_TIME, "P4File", "setFileSpec ", new Tracing.IRunnable(){

                @Override
                public void run() throws Throwable {
                    IP4Connection connection;
                    P4File.this.fileSpec = null;
                    int newChangelist = P4File.this.getChangelistId();
                    if (updateChangelist) {
                        P4File.this.updateChangelists(previousChangelist, newChangelist, refreshEventContainer);
                    }
                    if ((connection = P4File.this.getConnection()) != null) {
                        connection.removeFileFromChangelists(P4File.this);
                    }
                    P4File.this.notifyListeners(new P4Event(P4Event.EventType.REFRESHED, P4File.this));
                }
            });
        }
    }

    @Override
    public void setParent(IP4Container parent) {
        this.parent = parent;
    }

    @Override
    public IFile[] getLocalFiles() {
        return PerforceProviderPlugin.getLocalFiles(this.getLocalPath());
    }

    @Override
    public IFile getLocalFileForLocation() {
        return PerforceProviderPlugin.getLocalFile(this.getLocalPath());
    }

    @Override
    public boolean move(IP4File toFile, boolean useMoveCommand) {
        return this.move(toFile, useMoveCommand, 0);
    }

    @Override
    public boolean move(IP4File toFile, boolean useMoveCommand, int changelist) {
        return this.move(toFile, useMoveCommand, changelist, false);
    }

    @Override
    public boolean move(IP4File toFile, boolean useMoveCommand, int changelist, boolean bypassClient) {
        ChangelistSelection selection = new ChangelistSelection(changelist, true);
        return this.move(toFile, useMoveCommand, selection, bypassClient);
    }

    @Override
    public boolean move(IP4File toFile, boolean useMoveCommand, ChangelistSelection selection, boolean bypassClient) {
        if (this.readOnly) {
            return false;
        }
        if (toFile != null && selection != null) {
            IClient client = this.getClient();
            IP4Connection connection = this.getConnection();
            if (client != null && connection != null) {
                if (!useMoveCommand) {
                    return this.classicMove(client, toFile, selection.getId(), bypassClient);
                }
                return this.newMove(client, toFile, selection, bypassClient);
            }
        }
        return false;
    }

    private boolean classicMove(IClient client, IP4File toFile, int changelist, boolean bypassClient) {
        String newPath = toFile.getLocalPath();
        IFileSpec currentSpec = this.fileSpec;
        if (currentSpec != null && newPath != null) {
            FileSpec toSpec = new FileSpec(newPath);
            try {
                IntegrationOptions options = new IntegrationOptions();
                options.setDontCopyToClient(bypassClient);
                client.integrateFiles(changelist, false, options, null, currentSpec, (IFileSpec)toSpec);
                P4Collection toCollection = new P4Collection(new IP4Resource[]{toFile});
                toCollection.add(changelist);
                P4Collection fromCollection = new P4Collection(new IP4Resource[]{this});
                fromCollection.revert();
                fromCollection.delete(changelist);
                return true;
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return false;
    }

    private boolean newMove(IClient client, IP4File toFile, ChangelistSelection selection, boolean bypassClient) {
        String newPath = toFile.getLocalPath();
        IServer server = client.getServer();
        IFileSpec currentSpec = this.fileSpec;
        if (currentSpec != null && newPath != null && server != null) {
            FileSpec toSpec = new FileSpec(newPath);
            try {
                P4Collection fromCollection = new P4Collection(new IP4Resource[]{this});
                fromCollection.edit();
                String fromFilePath = this.getMovedFile();
                int id = selection.isExplicitSelection() ? selection.getId() : -1;
                List<IFileSpec> outputSpecs = server.moveFile(id, false, bypassClient, null, currentSpec, (IFileSpec)toSpec);
                outputSpecs = P4FileSpecBuilder.getValidFileSpecs(outputSpecs);
                if (outputSpecs.size() == 1) {
                    IP4Connection connection;
                    P4Collection refreshCollection = new P4Collection();
                    if (fromFilePath != null && (connection = this.getConnection()) != null) {
                        IP4File fromFile = connection.getFile(fromFilePath);
                        refreshCollection.add(fromFile);
                    }
                    refreshCollection.add(this);
                    refreshCollection.add(toFile);
                    refreshCollection.refresh();
                    return true;
                }
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return false;
    }

    @Override
    public String getResolvePath() {
        IFileSpec integSpec;
        String resolvePath = null;
        if (this.integSpecs != null && this.integSpecs.length != 0 && (resolvePath = (integSpec = this.integSpecs[0]).getFromFile()) != null) {
            int start = integSpec.getStartFromRev();
            int end = integSpec.getEndFromRev();
            if (start > -1 && end > -1) {
                resolvePath = String.valueOf(resolvePath) + "#" + (start + 1) + ",#" + end;
            }
        }
        return resolvePath;
    }

    @Override
    public void setIntegrationSpecs(IFileSpec[] integSpecs) {
        if (integSpecs != null && integSpecs.length != 0) {
            if (integSpecs[0].getOpStatus() == FileSpecOpStatus.VALID) {
                this.integSpecs = integSpecs;
            }
        } else {
            this.integSpecs = null;
        }
    }

    @Override
    public boolean isUnresolved() {
        if (this.fileSpec instanceof IExtendedFileSpec) {
            return ((IExtendedFileSpec)this.fileSpec).isUnresolved();
        }
        return false;
    }

    @Override
    public IFileSpec getIntegrationSpec() {
        if (this.integSpecs == null) {
            return null;
        }
        return this.integSpecs[0];
    }

    @Override
    public IFileSpec[] getIntegrationSpecs() {
        return this.integSpecs;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getLocalFileForLocation();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public int getHeadChange() {
        int headChange = 0;
        if (this.fileSpec instanceof IExtendedFileSpec) {
            headChange = ((IExtendedFileSpec)this.fileSpec).getHeadChange();
        }
        return headChange;
    }

    @Override
    public long getHeadTime() {
        Date date;
        long headTime = 0L;
        if (this.fileSpec instanceof IExtendedFileSpec && (date = ((IExtendedFileSpec)this.fileSpec).getHeadTime()) != null) {
            headTime = date.getTime();
        }
        return headTime;
    }

    @Override
    public String getClientName() {
        if (this.fileSpec != null) {
            return this.fileSpec.getClientName();
        }
        return null;
    }

    @Override
    public String getUserName() {
        if (this.fileSpec != null) {
            return this.fileSpec.getUserName();
        }
        return null;
    }

    @Override
    public int getChangelistId() {
        int changelist = -1;
        if (this.fileSpec != null) {
            changelist = this.fileSpec.getChangelistId();
        }
        return changelist;
    }

    @Override
    public FileSpecOpStatus getStatus() {
        FileSpecOpStatus status = FileSpecOpStatus.UNKNOWN;
        if (this.fileSpec != null) {
            status = this.fileSpec.getOpStatus();
        }
        return status;
    }

    @Override
    public String getStatusMessage() {
        String message = null;
        if (this.fileSpec != null) {
            message = this.fileSpec.getStatusMessage();
        }
        return message;
    }

    @Override
    public boolean isLocked() {
        boolean locked = false;
        if (this.fileSpec != null) {
            locked = this.fileSpec.isLocked();
        }
        return locked;
    }

    @Override
    public boolean openedElsewhere() {
        boolean elsewhere = false;
        if (this.fileSpec instanceof IExtendedFileSpec) {
            List otherActionList = ((IExtendedFileSpec)this.fileSpec).getOtherActionList();
            elsewhere = otherActionList != null && !otherActionList.isEmpty();
        }
        return elsewhere;
    }

    @Override
    public List<String> getOtherActions() {
        ArrayList others = null;
        if (this.fileSpec instanceof IExtendedFileSpec) {
            others = ((IExtendedFileSpec)this.fileSpec).getOtherActionList();
        }
        if (others == null) {
            others = new ArrayList();
        }
        return others;
    }

    @Override
    public List<String> getOtherChangelists() {
        ArrayList others = null;
        if (this.fileSpec instanceof IExtendedFileSpec) {
            others = ((IExtendedFileSpec)this.fileSpec).getOtherChangelist();
        }
        if (others == null) {
            others = new ArrayList();
        }
        return others;
    }

    @Override
    public List<String> getOtherEditors() {
        ArrayList others = null;
        if (this.fileSpec instanceof IExtendedFileSpec) {
            others = ((IExtendedFileSpec)this.fileSpec).getOtherOpenList();
        }
        if (others == null) {
            others = new ArrayList();
        }
        return others;
    }

    @Override
    public boolean openedByOwner() {
        boolean owned = false;
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            String owner = connection.getParameters().getUserNoNull();
            String username = this.getUserName();
            if (username != null) {
                owned = this.isCaseSensitive() ? owner.equals(username) : owner.equalsIgnoreCase(username);
            } else if (this.fileSpec instanceof IExtendedFileSpec) {
                String specOwner = ((IExtendedFileSpec)this.fileSpec).getActionOwner();
                owned = this.isCaseSensitive() ? owner.equals(specOwner) : owner.equalsIgnoreCase(specOwner);
            }
        }
        return owned;
    }

    @Override
    public boolean openedByOtherOwner() {
        boolean otherOwned = false;
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            String owner = connection.getParameters().getUserNoNull();
            String username = this.getUserName();
            if (username != null) {
                otherOwned = this.isCaseSensitive() ? !owner.equals(username) : !owner.equalsIgnoreCase(username);
            } else if (this.fileSpec instanceof IExtendedFileSpec) {
                String specOwner = ((IExtendedFileSpec)this.fileSpec).getActionOwner();
                otherOwned = this.isCaseSensitive() ? !owner.equals(specOwner) : !owner.equalsIgnoreCase(specOwner);
            }
        }
        return otherOwned;
    }

    @Override
    public boolean isHeadActionAdd() {
        return P4File.isActionAdd(this.getHeadAction());
    }

    @Override
    public boolean isHeadActionDelete() {
        return P4File.isActionDelete(this.getHeadAction());
    }

    @Override
    public boolean isHeadActionEdit() {
        return P4File.isActionEdit(this.getHeadAction());
    }

    @Override
    public IFileRevision[] getCompleteHistory(boolean includeBranches, IProgressMonitor monitor) {
        IFileRevisionData[] data;
        ArrayList<FileRevision> revisions = new ArrayList<FileRevision>();
        monitor.setTaskName(MessageFormat.format(Messages.P4File_3, this.getName()));
        IFileRevisionData[] iFileRevisionDataArray = data = this.getHistory(includeBranches);
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevisionData rev = iFileRevisionDataArray[n2];
            revisions.add(new P4Revision(this.getConnection(), rev));
            ++n2;
        }
        monitor.worked(1);
        monitor.setTaskName(MessageFormat.format(Messages.P4File_4, this.getName()));
        IFile localFile = this.getLocalFileForLocation();
        if (localFile != null) {
            try {
                IFileState[] states = localFile.getHistory(monitor);
                revisions.add(new LocalRevision(localFile, null));
                IFileState[] iFileStateArray = states;
                int n3 = states.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFileState state = iFileStateArray[n4];
                    revisions.add(new LocalRevision(localFile, state));
                    ++n4;
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (OperationCanceledException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        monitor.worked(1);
        return revisions.toArray(new IFileRevision[revisions.size()]);
    }

    @Override
    public IFileAnnotation[] getAnnotations(boolean followBranches) {
        return this.getAnnotations(followBranches, null);
    }

    @Override
    public IFileAnnotation[] getAnnotations() {
        return this.getAnnotations(false);
    }

    @Override
    public IFileAnnotation[] getAnnotations(boolean followBranches, IP4File.WhitespaceIgnoreType ignoreType) {
        return this.getAnnotations(followBranches, ignoreType, true);
    }

    @Override
    public IFileAnnotation[] getAnnotations(final boolean followBranches, final IP4File.WhitespaceIgnoreType ignoreType, final boolean outputChangeNumbers) {
        final ArrayList annotations = new ArrayList();
        String path = this.getActionPath();
        if (path != null) {
            final List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{path});
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    DiffType diffType = null;
                    if (ignoreType != null) {
                        switch (ignoreType) {
                            case ALL: {
                                diffType = DiffType.IGNORE_WS;
                                break;
                            }
                            case LINE_ENDINGS: {
                                diffType = DiffType.IGNORE_LINE_ENDINGS;
                                break;
                            }
                            case WHITESPACE: {
                                diffType = DiffType.IGNORE_WS_CHANGES;
                                break;
                            }
                        }
                    }
                    annotations.addAll(server.getFileAnnotations(specs, diffType, true, outputChangeNumbers, followBranches));
                }
            };
            this.runOperation(operation);
        }
        return annotations.toArray(new IFileAnnotation[annotations.size()]);
    }

    @Override
    public IP4ShelveFile[] getShelvedVersions() {
        final ArrayList shelved = new ArrayList();
        String path = this.getActionPath();
        final IP4Connection connection = this.getConnection();
        if (path != null && connection != null) {
            final List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{path});
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    if (connection.isShelvingSupported()) {
                        IServer server = client.getServer();
                        List lists = server.getChangelists(-1, specs, null, null, false, IChangelist.Type.SHELVED, true);
                        for (IChangelistSummary list : lists) {
                            if (list.getId() <= 0) continue;
                            Changelist fullList = new Changelist(list, server, false);
                            shelved.add(new P4ShelveFile((IChangelist)fullList, P4File.this, true));
                        }
                    }
                }
            };
            this.runOperation(operation);
        }
        return shelved.toArray(new IP4ShelveFile[shelved.size()]);
    }

    @Override
    public String getMovedFile() {
        if (this.fileSpec instanceof IExtendedFileSpec) {
            return ((IExtendedFileSpec)this.fileSpec).getMovedFile();
        }
        return null;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public File toFile() {
        String local = this.getLocalPath();
        File file = null;
        if (local != null) {
            file = new File(local);
        }
        return file;
    }
}

