/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4Job;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class P4Changelist
extends P4Resource
implements IP4Changelist,
Comparable<IP4Changelist> {
    public static final String EMPTY = "";
    public static final int SHORT_DESCRIPTION_LENGTH = 80;
    protected IP4Connection connection = null;
    protected IChangelist changelist = null;
    protected int id = -1;
    protected Set<IP4Resource> cachedFiles = Collections.synchronizedSet(new HashSet());

    public P4Changelist(IP4Connection connection) {
        this.connection = connection;
    }

    public P4Changelist(IP4Connection connection, IChangelist list) {
        this.connection = connection;
        this.changelist = list;
        if (this.changelist != null) {
            this.id = this.changelist.getId();
        }
    }

    protected boolean isValidFileSpec(IExtendedFileSpec spec) {
        return spec.getOpStatus() == FileSpecOpStatus.VALID && spec.getDepotPath() != null;
    }

    @Override
    public String getDescription() {
        if (this.changelist != null) {
            return this.changelist.getDescription();
        }
        return null;
    }

    @Override
    public void setDescription(String description) {
        if (this.changelist != null) {
            this.changelist.setDescription(description);
        }
    }

    @Override
    public String getActionPath() {
        return null;
    }

    @Override
    public String getActionPath(IP4Resource.Type type) {
        return null;
    }

    @Override
    public IClient getClient() {
        IClient client = null;
        if (this.connection != null) {
            client = this.connection.getClient();
        }
        return client;
    }

    @Override
    public String getClientPath() {
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getLocalPath() {
        return null;
    }

    @Override
    public String getName() {
        if (this.changelist != null) {
            return MessageFormat.format(Messages.P4Changelist_0, Integer.toString(this.changelist.getId()));
        }
        return EMPTY;
    }

    @Override
    public IP4Container getParent() {
        return null;
    }

    @Override
    public String getRemotePath() {
        return null;
    }

    @Override
    public IP4Resource[] members() {
        return this.cachedFiles.toArray(new IP4Resource[0]);
    }

    @Override
    public int size() {
        return this.cachedFiles.size();
    }

    @Override
    public IP4Job[] getJobs() {
        ArrayList<IP4Job> jobs = new ArrayList<IP4Job>();
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Job) {
                jobs.add((IP4Job)resource);
            }
            ++n2;
        }
        return jobs.toArray(new IP4Job[0]);
    }

    @Override
    public String getClientName() {
        String name = null;
        if (this.changelist != null) {
            name = this.changelist.getClientId();
        } else {
            IClient client = this.getClient();
            if (client != null) {
                name = client.getName();
            }
        }
        return name;
    }

    @Override
    public String getUserName() {
        String name = null;
        if (this.changelist != null) {
            return this.changelist.getUsername();
        }
        IClient client = this.getClient();
        if (client != null) {
            name = client.getOwnerName();
        }
        return name;
    }

    @Override
    public int compareTo(IP4Changelist o) {
        if (this.changelist != null && o.getChangelist() != null) {
            return this.changelist.getId() - o.getChangelist().getId();
        }
        if (this.isDefault() && o.isDefault()) {
            return this.getName().compareToIgnoreCase(o.getName());
        }
        return 0;
    }

    @Override
    public boolean isDefault() {
        if (this.changelist != null) {
            return this.changelist.getId() == 0;
        }
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public Date getDate() {
        if (this.changelist != null) {
            return this.changelist.getDate();
        }
        return null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ChangelistStatus getStatus() {
        if (this.changelist != null) {
            return this.changelist.getStatus();
        }
        return null;
    }

    @Override
    public void refresh() {
        if (this.changelist != null) {
            try {
                HashSet<IP4Resource> resources = new HashSet<IP4Resource>();
                List jobs = this.changelist.getJobs();
                for (IJob job : jobs) {
                    P4Job p4Job = new P4Job(job, this.getConnection(), this);
                    resources.add(p4Job);
                }
                List<IFileSpec> files = this.changelist.getFiles(true);
                files = P4FileSpecBuilder.getValidFileSpecs(files);
                for (IFileSpec file : files) {
                    IP4File p4File = null;
                    if (!this.readOnly) {
                        p4File = this.getConnection().getFile(file);
                    }
                    if (p4File == null) {
                        p4File = new P4File(file, this, this.readOnly);
                    }
                    resources.add(p4File);
                }
                this.cachedFiles = resources;
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        this.needsRefresh = false;
    }

    @Override
    public void refresh(int depth) {
        this.refresh();
    }

    @Override
    public IP4File[] getAllLocalFiles() {
        return null;
    }

    @Override
    public IChangelist getChangelist() {
        return this.changelist;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IP4Changelist) {
            IP4Changelist list = (IP4Changelist)obj;
            if (!this.connectionEquals(list)) {
                return false;
            }
            int id = this.getId();
            if (id > -1 && id == list.getId()) {
                String user = this.getUserName();
                String client = this.getClientName();
                if (user != null && client != null) {
                    if (this.isCaseSensitive()) {
                        return user.equals(list.getUserName()) && client.equals(list.getClientName());
                    }
                    return user.equalsIgnoreCase(list.getUserName()) && client.equalsIgnoreCase(list.getClientName());
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = this.getId();
        if (hash < 0) {
            hash = super.hashCode();
        }
        return hash;
    }

    @Override
    public String getShortDescription() {
        return this.getShortenedDescription(80);
    }

    @Override
    public String getShortenedDescription(int length) {
        String description = this.getDescription();
        if (length <= 0 || description == null) {
            return EMPTY;
        }
        StringBuilder desc = new StringBuilder(description.length() > length ? String.valueOf(description.substring(0, length - 1)) + "..." : description);
        int i = 0;
        while (i < desc.length()) {
            if (Character.isISOControl(desc.charAt(i))) {
                desc.setCharAt(i, ' ');
            }
            ++i;
        }
        return desc.toString();
    }

    @Override
    public IP4Job fix(IP4Job job) {
        IP4Job[] fixed;
        IP4Job fixedJob = null;
        if (job != null && (fixed = this.fix(new IP4Job[]{job})).length > 0) {
            fixedJob = fixed[0];
        }
        return fixedJob;
    }

    @Override
    public IP4Job[] fix(IP4Job[] jobs) {
        IServer server;
        ArrayList<P4Job> fixed = new ArrayList<P4Job>();
        IClient client = this.getClient();
        if (jobs != null && jobs.length > 0 && client != null && (server = client.getServer()) != null) {
            ArrayList<String> jobList = new ArrayList<String>();
            IP4Job[] iP4JobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Job job = iP4JobArray[n2];
                String id = job.getId();
                if (id != null) {
                    jobList.add(id);
                }
                ++n2;
            }
            try {
                List fixes = server.fixJobs(jobList, this.getId(), null, false);
                IP4Job[] iP4JobArray2 = jobs;
                int n3 = jobs.length;
                n = 0;
                while (n < n3) {
                    IP4Job job = iP4JobArray2[n];
                    String id = job.getId();
                    if (id != null) {
                        for (IFix fix : fixes) {
                            if (!id.equals(fix.getJobId())) continue;
                            P4Job fixedJob = new P4Job(job.getJob(), this.getConnection(), this);
                            this.addJob(fixedJob);
                            fixed.add(fixedJob);
                            break;
                        }
                    }
                    ++n;
                }
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return fixed.toArray(new IP4Job[0]);
    }

    @Override
    public IP4Job unfix(IP4Job job) {
        IP4Job[] unfixed;
        IP4Job unfixedJob = null;
        if (job != null && (unfixed = this.unfix(new IP4Job[]{job})).length > 0) {
            unfixedJob = unfixed[0];
        }
        return unfixedJob;
    }

    @Override
    public IP4Job[] unfix(IP4Job[] jobs) {
        IServer server;
        ArrayList<P4Job> unfixed = new ArrayList<P4Job>();
        IClient client = this.getClient();
        if (jobs != null && jobs.length > 0 && client != null && (server = client.getServer()) != null) {
            ArrayList<String> jobList = new ArrayList<String>();
            IP4Job[] iP4JobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Job job = iP4JobArray[n2];
                String id = job.getId();
                if (id != null) {
                    jobList.add(id);
                }
                ++n2;
            }
            try {
                List unfixes = server.fixJobs(jobList, this.getId(), null, true);
                IP4Job[] iP4JobArray2 = jobs;
                int n3 = jobs.length;
                n = 0;
                while (n < n3) {
                    IP4Job job = iP4JobArray2[n];
                    String id = job.getId();
                    if (id != null) {
                        for (IFix unfix : unfixes) {
                            if (!id.equals(unfix.getJobId())) continue;
                            P4Job unfixedJob = new P4Job(job.getJob(), this.getConnection(), this);
                            this.removeJob(unfixedJob);
                            unfixed.add(unfixedJob);
                            break;
                        }
                    }
                    ++n;
                }
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return unfixed.toArray(new IP4Job[0]);
    }

    @Override
    public void addJob(IP4Job job) {
        this.cachedFiles.add(job);
    }

    @Override
    public void removeJob(IP4Job job) {
        this.cachedFiles.remove(job);
    }

    @Override
    public String[] getJobIds() {
        final HashSet ids = new HashSet();
        final int id = this.getId();
        if (id > 0) {
            P4ServerOperation op = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    List fixes = server.getFixList(null, id, null, false, -1);
                    for (IFix fix : fixes) {
                        ids.add(fix.getJobId());
                    }
                }
            };
            this.runOperation(op);
        }
        return ids.toArray(new String[ids.size()]);
    }

    @Override
    public List<IExtendedFileSpec> getOpenedSpecs() {
        final ArrayList<IExtendedFileSpec> result = new ArrayList<IExtendedFileSpec>();
        final int id = this.getId();
        if (id > 0) {
            P4ServerOperation op = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    List simpleSpecs = server.getChangelistFiles(id);
                    FileStatOutputOptions options = new FileStatOutputOptions();
                    options.setOpenedFiles(true);
                    if (!simpleSpecs.isEmpty()) {
                        List specs = server.getExtendedFiles(simpleSpecs, 0, -1, id, options, null);
                        for (IExtendedFileSpec spec : specs) {
                            if (!P4Changelist.this.isValidFileSpec(spec)) continue;
                            result.add(spec);
                        }
                    }
                }
            };
            this.runOperation(op);
        }
        return result;
    }
}

