/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.BranchSpec;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.P4SubmittedChangelist;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class P4Branch
extends P4Resource
implements IP4Branch {
    private IP4Connection connection;
    private IBranchSpecSummary branch;

    public P4Branch(IP4Connection connection, IBranchSpecSummary branch, boolean needsRefresh) {
        this.connection = connection;
        this.branch = branch;
    }

    @Override
    public String getActionPath() {
        return null;
    }

    @Override
    public String getActionPath(IP4Resource.Type preferredType) {
        return null;
    }

    @Override
    public IClient getClient() {
        IClient client = null;
        if (this.connection != null) {
            client = this.connection.getClient();
        }
        return client;
    }

    @Override
    public String getClientPath() {
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getLocalPath() {
        return null;
    }

    @Override
    public String getName() {
        return this.branch != null ? this.branch.getName() : null;
    }

    @Override
    public IP4Container getParent() {
        return this.connection;
    }

    @Override
    public String getRemotePath() {
        return null;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public void refresh(int depth) {
        this.refresh();
    }

    @Override
    public void refresh() {
        final String name = this.getName();
        if (name != null) {
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    P4Branch.this.branch = (IBranchSpecSummary)server.getBranchSpec(name);
                    P4Branch.this.needsRefresh = false;
                }
            };
            this.runOperation(operation);
        }
    }

    @Override
    public Date getAccessTime() {
        return this.branch != null ? this.branch.getAccessed() : null;
    }

    @Override
    public String getDescription() {
        return this.branch != null ? this.branch.getDescription() : null;
    }

    @Override
    public String getOwner() {
        return this.branch != null ? this.branch.getOwnerName() : null;
    }

    @Override
    public Date getUpdateTime() {
        return this.branch != null ? this.branch.getUpdated() : null;
    }

    @Override
    public ViewMap<IBranchMapping> getView() {
        ViewMap view = null;
        if (this.branch instanceof BranchSpec) {
            view = ((BranchSpec)this.branch).getBranchView();
        }
        return view;
    }

    @Override
    public boolean isLocked() {
        return this.branch != null ? this.branch.isLocked() : false;
    }

    @Override
    public void update(IBranchSpec branch) throws P4JavaException {
        IServer server;
        IP4Connection connection;
        if (branch != null && (connection = this.getConnection()) != null && (server = connection.getServer()) != null) {
            try {
                server.updateBranchSpec(branch);
            }
            catch (P4JavaError error) {
                PerforceProviderPlugin.logError(error);
            }
        }
    }

    @Override
    public IP4SubmittedChangelist[] getInterchanges() {
        return this.getInterchanges(false);
    }

    @Override
    public IP4SubmittedChangelist[] getInterchanges(final boolean reverse) {
        final String name = this.getName();
        final IP4Connection connection = this.getConnection();
        final ArrayList lists = new ArrayList();
        if (name != null && connection != null) {
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List interchanges = client.getServer().getInterchanges(name, null, null, false, true, -1, reverse, false);
                    for (IChangelist list : interchanges) {
                        lists.add(new P4SubmittedChangelist(connection, list));
                    }
                }
            };
            this.runOperation(operation);
        }
        return lists.toArray(new IP4SubmittedChangelist[lists.size()]);
    }

    @Override
    public IFileDiff[] getDiffs() {
        return this.getDiffs(null, null);
    }

    @Override
    public IFileDiff[] getDiffs(final String sourceFilter, final String targetFilter) {
        final ArrayList diffs = new ArrayList();
        final String name = this.getName();
        if (name != null) {
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    FileSpec leftSpec = null;
                    FileSpec rightSpec = null;
                    if (sourceFilter != null) {
                        leftSpec = new FileSpec(sourceFilter);
                    }
                    if (targetFilter != null) {
                        rightSpec = new FileSpec(targetFilter);
                    }
                    List serverDiffs = server.getFileDiffs((IFileSpec)leftSpec, (IFileSpec)rightSpec, name, null, false, false, false);
                    diffs.addAll(serverDiffs);
                }
            };
            this.runOperation(operation);
        }
        return diffs.toArray(new IFileDiff[diffs.size()]);
    }
}

