/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.views.DragData;
import com.perforce.team.ui.views.SubmittedViewControl;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class SubmittedDropAdapter
extends ViewerDropAdapter {
    private SubmittedViewControl view;
    private TransferData currentTransfer;

    public SubmittedDropAdapter(SubmittedViewControl view) {
        super((Viewer)view.getViewer());
        this.view = view;
        this.setScrollExpandEnabled(false);
    }

    public void drop(DropTargetEvent event) {
        super.drop(event);
        event.detail = 4;
    }

    public boolean performDrop(Object data) {
        IStructuredSelection selection;
        if (data == null) {
            return false;
        }
        if (ResourceTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return this.doResourceDrop((IResource[])data);
        }
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return this.doFileDrop((String[])data);
        }
        if (data instanceof IStructuredSelection && (selection = (IStructuredSelection)data).size() == 1) {
            Object first = selection.getFirstElement();
            if (first instanceof IResource) {
                return this.doResourceDrop(new IResource[]{(IResource)first});
            }
            if (first instanceof IP4Resource) {
                return this.doP4ResourceDrop(new IP4Resource[]{(IP4Resource)first});
            }
            if (first instanceof IAdaptable) {
                Object adapted = ((IAdaptable)first).getAdapter(IResource.class);
                if (adapted instanceof IResource) {
                    return this.doResourceDrop(new IResource[]{(IResource)adapted});
                }
                adapted = ((IAdaptable)first).getAdapter(IP4Resource.class);
                if (adapted instanceof IP4Resource) {
                    return this.doP4ResourceDrop(new IP4Resource[]{(IP4Resource)adapted});
                }
            }
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        this.currentTransfer = transferType;
        if (ResourceTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(this.currentTransfer)) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            return selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1;
        }
        return false;
    }

    public boolean doFileDrop(String[] files) {
        IP4Resource[] depots;
        if (files.length != 1 || DragData.getConnection() == null) {
            return false;
        }
        IP4Connection con = DragData.getConnection();
        DragData.clear();
        IP4Resource resource = con.getResource(files[0]);
        if (resource == null && (depots = con.members()) != null) {
            IP4Resource[] iP4ResourceArray = depots;
            int n = depots.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource depot = iP4ResourceArray[n2];
                if (files[0].equals(depot.getRemotePath())) {
                    resource = depot;
                    break;
                }
                ++n2;
            }
        }
        if (resource != null) {
            this.view.showChangelists(resource);
            return true;
        }
        return false;
    }

    private boolean doP4ResourceDrop(IP4Resource[] resources) {
        if (resources.length != 1) {
            return false;
        }
        DragData.clear();
        if (resources[0] != null) {
            this.view.showChangelists(resources[0]);
            return true;
        }
        return false;
    }

    private boolean doResourceDrop(IResource[] resources) {
        if (resources.length != 1) {
            return false;
        }
        DragData.clear();
        IP4Resource resource = P4ConnectionManager.getManager().getResource(resources[0]);
        if (resource != null) {
            this.view.showChangelists(resource);
            return true;
        }
        return false;
    }
}

