/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.actions.OpenAction;
import com.perforce.team.ui.changelists.DecoratedChangelistLabelProvider;
import com.perforce.team.ui.p4java.actions.DiffDepotAction;
import com.perforce.team.ui.p4java.actions.EditJobAction;
import com.perforce.team.ui.p4java.actions.NewChangelistAction;
import com.perforce.team.ui.p4java.actions.RevertAction;
import com.perforce.team.ui.shelve.DiffShelveHeadAction;
import com.perforce.team.ui.shelve.OpenEditorAction;
import com.perforce.team.ui.swarmreview.PendingReviewManager;
import com.perforce.team.ui.swarmreview.ReviewManager;
import com.perforce.team.ui.views.AbstractPerforceViewControl;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.MenuFilter;
import com.perforce.team.ui.views.Messages;
import com.perforce.team.ui.views.PendingDragAdapter;
import com.perforce.team.ui.views.PendingDropAdapter;
import com.perforce.team.ui.views.ViewUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.progress.UIJob;

public class PendingViewControl
extends AbstractPerforceViewControl
implements IP4Listener,
IPropertyChangeListener {
    private static final String SHOW_OTHER_CHANGELISTS = "show_other_changeslists";
    private boolean isLoading = false;
    private TreeViewer viewer;
    private PerforceContentProvider provider;
    private Action refreshAction;
    private Action refreshListAction;
    private Action activateAction;
    private Action disactivateAction;
    private Action otherAction;
    private Action newChangelistAction;
    private Action openAction;
    private Action revertAction;
    private Action diffAction;
    private Action collapseAction;
    private boolean showOtherChanges;
    private IMemento memento;

    public PendingViewControl(IPerforceView view) {
        super(view);
        IPreferenceStore store = PendingViewControl.getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void setMemento(IMemento memento) {
        this.memento = memento;
    }

    public IMemento getMemento() {
        return this.memento;
    }

    public void saveState(IMemento memento) {
        memento.putInteger(SHOW_OTHER_CHANGELISTS, this.showOtherChanges ? 1 : 0);
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.pending_view");
        this.showMore = new Link(parent, 8);
        this.showMore.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.showMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingViewControl.this.showMore();
            }
        });
        this.retrieveCount = this.getMaxChangelists();
        this.updateMoreButton(false);
        this.viewer = new TreeViewer(parent);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setComparator(ViewUtil.getViewComparator());
        this.viewer.setUseHashlookup(true);
        this.provider = new PerforceContentProvider((StructuredViewer)this.viewer, true){

            @Override
            protected IP4Resource[] getMembers(IP4Container container) {
                if (container instanceof IP4PendingChangelist) {
                    return ((IP4PendingChangelist)container).getAllMembers();
                }
                return super.getMembers(container);
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)DecoratedChangelistLabelProvider.create());
        this.addContextMenu();
        this.initDragDrop(this.viewer);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PendingViewControl.this.handleDoubleClick(event);
            }
        });
        this.addProjectListeners();
        P4ConnectionManager.getManager().addListener(this);
    }

    @Override
    public void dispose() {
        this.removeProjectListeners();
        P4ConnectionManager.getManager().removeListener(this);
    }

    @Override
    public void refresh() {
        this.clearFetchCount();
        this.setViewerInput(this.p4Connection);
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void initDragDrop(TreeViewer viewer) {
        viewer.addDropSupport(19, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new PendingDropAdapter((Viewer)viewer));
        viewer.addDragSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new PendingDragAdapter((ISelectionProvider)viewer));
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IP4File) {
            OpenAction.openFile((IP4File)element);
        } else if (element instanceof IP4Job) {
            IP4Job job = (IP4Job)element;
            EditJobAction edit = new EditJobAction();
            edit.selectionChanged(null, (ISelection)new StructuredSelection((Object)job));
            edit.doubleClick(null);
        } else if (element instanceof IP4ShelveFile) {
            OpenEditorAction action = new OpenEditorAction();
            action.selectionChanged(null, (ISelection)new StructuredSelection(element));
            action.run(null);
        } else if (this.viewer.isExpandable(element)) {
            this.viewer.setExpandedState(element, !this.viewer.getExpandedState(element));
        }
    }

    private IP4PendingChangelist[] getSelectedLists() {
        ArrayList<IP4PendingChangelist> lists = new ArrayList<IP4PendingChangelist>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object select = objectArray[n2];
            if (select instanceof IP4PendingChangelist) {
                lists.add((IP4PendingChangelist)select);
            }
            ++n2;
        }
        return lists.toArray(new IP4PendingChangelist[lists.size()]);
    }

    private void addContextMenu() {
        Integer showOther;
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.refreshAction = new Action(Messages.PendingView_RefreshAllChangelists, plugin.getImageDescriptor("enabled/refresh.png")){

            public void run() {
                PendingViewControl.this.refresh();
            }
        };
        this.refreshListAction = new Action(Messages.PendingView_RefreshSelectedChangelists){

            public void run() {
                IP4PendingChangelist[] lists = PendingViewControl.this.getSelectedLists();
                if (lists.length > 0) {
                    IP4PendingChangelist[] iP4PendingChangelistArray = lists;
                    int n = lists.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4PendingChangelist list = iP4PendingChangelistArray[n2];
                        list.markForRefresh();
                        PendingViewControl.this.viewer.refresh((Object)list);
                        ++n2;
                    }
                }
            }
        };
        this.activateAction = new Action(Messages.PendingView_MakeActivePendingChangelist){

            public void run() {
                IP4PendingChangelist[] lists = PendingViewControl.this.getSelectedLists();
                if (lists.length == 1) {
                    lists[0].makeActive();
                }
            }
        };
        this.disactivateAction = new Action(Messages.PendingView_ClearAsActivePendingChangelist){

            public void run() {
                IP4PendingChangelist[] lists = PendingViewControl.this.getSelectedLists();
                if (lists.length == 1 && lists[0].isActive()) {
                    lists[0].getConnection().setActivePendingChangelist(-1);
                }
            }
        };
        this.openAction = new Action(Messages.PendingView_Open){

            public void run() {
                Object[] selection = ((IStructuredSelection)PendingViewControl.this.viewer.getSelection()).toArray();
                String[] paths = new String[selection.length];
                int i = 0;
                while (i < selection.length) {
                    if (selection[i] instanceof IP4File) {
                        paths[i] = ((IP4File)selection[i]).getLocalPath();
                    }
                    ++i;
                }
                OpenAction.openFiles(paths);
            }
        };
        this.otherAction = new Action(Messages.PendingView_ShowOtherClientsChangelists){

            public int getStyle() {
                return 2;
            }
        };
        this.showOtherChanges = false;
        if (this.memento != null && (showOther = this.memento.getInteger(SHOW_OTHER_CHANGELISTS)) != null && showOther == 1) {
            this.showOtherChanges = true;
        }
        this.otherAction.setChecked(this.showOtherChanges);
        this.otherAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty())) {
                    PendingViewControl.this.updateAndRefreshChanges(PendingViewControl.this.otherAction.isChecked());
                }
            }
        });
        this.refreshAction.setToolTipText(Messages.PendingView_RefreshPendingChangelists);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/refresh.png"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/refresh.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.refreshAction, "com.perforce.team.ui.pending_refresh");
        this.newChangelistAction = new Action(Messages.PendingView_NewPendingChangelist, plugin.getImageDescriptor("enabled/new_changelist.png")){

            public void run() {
                if (PendingViewControl.this.p4Connection != null) {
                    NewChangelistAction action = new NewChangelistAction();
                    action.setCollection(new P4Collection(new IP4Resource[]{PendingViewControl.this.p4Connection}));
                    action.runAction();
                }
            }
        };
        this.newChangelistAction.setToolTipText(Messages.PendingView_CreateNewPendingChangelist);
        this.newChangelistAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/new_changelist.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.newChangelistAction, "com.perforce.team.ui.pending_new_changelist");
        final RevertAction wrappedRevert = new RevertAction();
        this.revertAction = new Action(Messages.PendingView_RevertFiles, plugin.getImageDescriptor("normal/revert.png")){

            public void run() {
                wrappedRevert.selectionChanged(null, PendingViewControl.this.viewer.getSelection());
                wrappedRevert.runAction();
            }
        };
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                wrappedRevert.selectionChanged((IAction)PendingViewControl.this.revertAction, event.getSelection());
            }
        });
        this.diffAction = new Action(Messages.PendingView_DiffFileAgainstDepot, plugin.getImageDescriptor("normal/diff.png")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)PendingViewControl.this.viewer.getSelection();
                DiffDepotAction action = new DiffDepotAction();
                action.selectionChanged(null, (ISelection)selection);
                action.runAction();
                if (!selection.isEmpty()) {
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object select = objectArray[n2];
                        if (select instanceof IP4ShelveFile) {
                            DiffShelveHeadAction diffShelve = new DiffShelveHeadAction();
                            diffShelve.selectionChanged(null, (ISelection)new StructuredSelection(select));
                            diffShelve.run(null);
                        }
                        ++n2;
                    }
                }
            }
        };
        this.collapseAction = new Action(Messages.PendingView_CollapseAll){

            public void run() {
                PendingViewControl.this.viewer.collapseAll();
            }
        };
        this.collapseAction.setToolTipText(Messages.PendingView_CollapseAll);
        this.collapseAction.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/collapseall.png"));
        MenuManager manager = new MenuManager();
        Tree tree = this.viewer.getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("perforce.opengroup"));
                manager.add((IContributionItem)new Separator("perforce.group1"));
                IP4PendingChangelist[] lists = PendingViewControl.this.getSelectedLists();
                if (lists.length > 0) {
                    manager.add((IAction)PendingViewControl.this.refreshListAction);
                    if (lists.length == 1 && lists[0].isOnClient()) {
                        if (lists[0].isActive()) {
                            manager.add((IAction)PendingViewControl.this.disactivateAction);
                        } else {
                            manager.add((IAction)PendingViewControl.this.activateAction);
                        }
                    }
                }
                manager.add((IContributionItem)new Separator("perforce.group2"));
                manager.add((IContributionItem)new Separator("perforce.group3"));
                manager.add((IContributionItem)new Separator("perforce.group4"));
                manager.add((IContributionItem)new Separator("perforce.group5"));
                manager.add((IAction)PendingViewControl.this.refreshAction);
                manager.add((IContributionItem)new Separator("additions"));
                PendingViewControl.this.addPropertiesMenu(manager);
                PendingViewControl.this.addOpenMenu(manager);
                PendingViewControl.this.addOpenWithMenu(manager);
            }
        });
        manager.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.registerContextMenu(manager, (ISelectionProvider)this.viewer);
        manager.addMenuListener((IMenuListener)MenuFilter.createTeamMainFilter());
        IWorkbenchPartSite site = this.getView().getSite();
        if (site instanceof IViewSite) {
            IActionBars bars = ((IViewSite)site).getActionBars();
            IToolBarManager tbm = bars.getToolBarManager();
            tbm.add((IAction)this.refreshAction);
            tbm.add((IAction)this.newChangelistAction);
            tbm.add((IAction)this.revertAction);
            tbm.add((IAction)this.diffAction);
            tbm.add((IAction)this.collapseAction);
            tbm.update(false);
            IMenuManager pulldown = bars.getMenuManager();
            pulldown.add((IAction)this.otherAction);
            pulldown.update(false);
        }
    }

    private void addPropertiesMenu(IMenuManager menu) {
        Object[] selection = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        if (selection.length != 1) {
            return;
        }
        if (!(selection[0] instanceof IP4File)) {
            return;
        }
        IP4File file = (IP4File)selection[0];
        IFile resource = PerforceProviderPlugin.getWorkspaceFile((String)file.getLocalPath());
        if (resource != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new PropertyDialogAction(new IShellProvider(){

                public Shell getShell() {
                    return PendingViewControl.this.getView().getShell();
                }
            }, (ISelectionProvider)this.viewer));
        }
    }

    private void addOpenMenu(IMenuManager menu) {
        Object[] selection = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        if (selection.length > 0) {
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof IP4File)) {
                    return;
                }
                IP4File file = (IP4File)selection[0];
                IFile resource = PerforceProviderPlugin.getWorkspaceFile((String)file.getLocalPath());
                if (resource == null) {
                    return;
                }
                ++i;
            }
            menu.appendToGroup("perforce.opengroup", (IAction)this.openAction);
        }
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (!(o instanceof IP4File)) {
            return;
        }
        IP4File file = (IP4File)o;
        IFile resource = PerforceProviderPlugin.getWorkspaceFile((String)file.getLocalPath());
        if (resource == null) {
            return;
        }
        MenuManager submenu = new MenuManager(Messages.PendingView_OpenWith);
        IWorkbenchPartSite site = this.getView().getSite();
        if (site != null) {
            submenu.add((IContributionItem)new OpenWithMenu(site.getPage(), (IAdaptable)resource));
        }
        menu.appendToGroup("perforce.opengroup", (IContributionItem)submenu);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void showOtherChanges(boolean show) {
        this.otherAction.setChecked(show);
    }

    private void updateAndRefreshChanges(boolean show) {
        this.showOtherChanges = show;
        this.setViewerInput(this.p4Connection);
    }

    @Override
    protected void showNoConnection() {
        super.showNoConnection();
        this.viewer.setInput(null);
        this.setActionEnabled(false);
    }

    public void setActionEnabled(boolean enabled) {
        this.newChangelistAction.setEnabled(enabled);
        this.refreshAction.setEnabled(enabled);
        this.diffAction.setEnabled(enabled);
        this.revertAction.setEnabled(enabled);
        this.otherAction.setEnabled(enabled);
    }

    @Override
    protected void setViewerInput(final IP4Connection connection) {
        if (this.connectionOK(connection)) {
            this.showDisplayArea();
            this.isLoading = true;
            this.setActionEnabled(false);
            this.viewer.setInput((Object)new PerforceContentProvider.Loading());
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public String getTitle() {
                    return MessageFormat.format(Messages.PendingView_LoadPendingChangelistsFor, connection.getName());
                }

                public void run(IProgressMonitor monitor) {
                    if (connection != PendingViewControl.this.p4Connection) {
                        return;
                    }
                    final IP4PendingChangelist[] lists = connection.getPendingChangelists(PendingViewControl.this.showOtherChanges, PendingViewControl.this.getFetchCount());
                    ReviewManager<IP4PendingChangelist> swarmReviewManager = PendingReviewManager.getInstance(connection);
                    swarmReviewManager.init(null, true);
                    swarmReviewManager.createCache((IP4Changelist[])lists);
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).PendingViewControl.this.p4Connection == connection) {
                                if (lists != null && lists.length > 0) {
                                    PendingViewControl.this.viewer.setInput((Object)lists);
                                } else {
                                    PendingViewControl.this.showNoConnection();
                                }
                                PendingViewControl.this.isLoading = false;
                                PendingViewControl.this.setActionEnabled(true);
                            }
                        }
                    });
                }
            });
        } else {
            this.showNoConnection();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == "pref_retrieve_num_changes") {
            this.updateMoreButton(false);
            this.refresh();
        }
    }

    @Override
    public void showMore() {
        super.showMore();
        this.setViewerInput(this.p4Connection);
    }

    public boolean okToUse() {
        return this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed();
    }

    private void addLists(IP4Resource[] resources) {
        ArrayList<IP4PendingChangelist> newList = new ArrayList<IP4PendingChangelist>();
        IP4Connection connection = this.p4Connection;
        if (connection != null) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4PendingChangelist && ((IP4PendingChangelist)resource).getId() > 0 && connection.equals(resource.getConnection())) {
                    newList.add((IP4PendingChangelist)resource);
                }
                ++n2;
            }
            if (newList.size() > 0) {
                this.viewer.setInput((Object)connection.getPendingChangelists(this.showOtherChanges));
                Iterator iterator = newList.iterator();
                if (iterator.hasNext()) {
                    IP4PendingChangelist list = (IP4PendingChangelist)iterator.next();
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)list));
                    this.viewer.reveal((Object)list);
                }
            }
        }
    }

    private void handleUpdateEvent(Object[] elements) {
        this.viewer.update(elements, null);
    }

    private void handleJobEvent(IP4Resource[] resources, boolean reveal) {
        ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
        if (resources.length > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Container parent;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4Job && (parent = resource.getParent()) instanceof IP4PendingChangelist && !processed.contains(parent)) {
                    this.viewer.refresh((Object)parent);
                    processed.add((IP4PendingChangelist)parent);
                    if (reveal) {
                        this.viewer.reveal((Object)resource);
                    }
                }
                ++n2;
            }
        }
    }

    private void handleRemoveEvent(Object[] elements) {
        ArrayList<IP4PendingChangelist> removedList = new ArrayList<IP4PendingChangelist>();
        ArrayList<Object> removedObjs = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IP4PendingChangelist) {
                removedList.add((IP4PendingChangelist)obj);
            } else {
                removedObjs.add(obj);
            }
            ++n2;
        }
        if (removedList.size() > 0) {
            this.viewer.setInput((Object)this.getConnection().getPendingChangelists(this.showOtherChanges));
        }
        if (removedObjs.size() > 0) {
            this.viewer.remove(removedObjs.toArray());
        }
    }

    private void handleSubmitChangelistEvent(IP4PendingChangelist[] lists) {
        if (lists.length > 0) {
            this.handleRemoveEvent(Arrays.asList(lists).toArray(new Object[0]));
            ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
            IP4PendingChangelist[] iP4PendingChangelistArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                IP4PendingChangelist defaultChangelist;
                IP4PendingChangelist list = iP4PendingChangelistArray[n2];
                IP4Connection connection = list.getConnection();
                if (connection != null && (defaultChangelist = connection.getPendingChangelist(0)) != null && !processed.contains(defaultChangelist)) {
                    defaultChangelist.markForRefresh();
                    this.viewer.refresh((Object)defaultChangelist);
                    processed.add(defaultChangelist);
                }
                ++n2;
            }
        }
    }

    private void handleOpened(IP4File[] files) {
        ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
        IP4File[] iP4FileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IP4File file = iP4FileArray[n2];
            IP4PendingChangelist list = file.getChangelist();
            if (list != null && !processed.contains(list)) {
                this.viewer.refresh((Object)list);
                this.viewer.reveal((Object)file);
                processed.add(list);
            }
            ++n2;
        }
    }

    private void handleRefresh(IP4Resource[] resources) {
        if (resources.length == 0) {
            return;
        }
        ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
        ArrayList<IP4File> remove = new ArrayList<IP4File>();
        IP4Resource[] iP4ResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                IP4File file = (IP4File)resource;
                if (!file.isOpened()) {
                    remove.add(file);
                } else {
                    IP4PendingChangelist list = file.getChangelist();
                    if (list != null && !processed.contains(list)) {
                        this.viewer.refresh((Object)list);
                        if (this.viewer.getExpandedState((Object)list)) {
                            this.viewer.expandToLevel((Object)resource, 2);
                        }
                        processed.add(list);
                    }
                }
            } else if (resource instanceof IP4PendingChangelist && !processed.contains(resource)) {
                if (!this.viewer.getTree().isDisposed()) {
                    this.viewer.refresh((Object)resource);
                    if (this.viewer.getExpandedState((Object)resource)) {
                        this.viewer.expandToLevel((Object)resource, 2);
                    }
                }
                processed.add((IP4PendingChangelist)resource);
            }
            ++n2;
        }
        if (!remove.isEmpty()) {
            this.handleRemoveEvent(remove.toArray());
        }
    }

    public void resoureChanged(final P4Event event) {
        P4Event.EventType type = event.getType();
        if (type != P4Event.EventType.CREATE_CHANGELIST && type != P4Event.EventType.DELETE_CHANGELIST && type != P4Event.EventType.CHANGED && type != P4Event.EventType.FIXED && type != P4Event.EventType.UNFIXED && type != P4Event.EventType.REFRESHED && type != P4Event.EventType.OPENED && type != P4Event.EventType.REVERTED && type != P4Event.EventType.MOVE_ADDED && type != P4Event.EventType.SUBMITTED && type != P4Event.EventType.SUBMIT_FAILED && type != P4Event.EventType.SUBMIT_CHANGELIST && type != P4Event.EventType.DELETE_SHELVE && type != P4Event.EventType.UPDATE_SHELVE && type != P4Event.EventType.SUBMIT_SHELVEDCHANGELIST && type != P4Event.EventType.CREATE_SHELVE) {
            return;
        }
        final IP4Changelist[] lists = event.getChangelists();
        UIJob job = new UIJob(Messages.PendingView_UpdatingPendingChangelistView){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Tracing.printExecTime((boolean)Policy.DEBUG, (String)(String.valueOf(PendingViewControl.this.getClass().getSimpleName()) + ":resourceChanged()"), (String)event.toString(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (PendingViewControl.this.okToUse() && PendingViewControl.this.viewer.getInput() != null && !PendingViewControl.this.isLoading()) {
                            P4Event.EventType type = event.getType();
                            switch (type) {
                                case REFRESHED: 
                                case CREATE_SHELVE: 
                                case DELETE_SHELVE: 
                                case UPDATE_SHELVE: {
                                    PendingViewControl.this.handleRefresh(event.getResources());
                                    break;
                                }
                                case CHANGED: {
                                    PendingViewControl.this.handleUpdateEvent(event.getPending());
                                    break;
                                }
                                case FIXED: {
                                    PendingViewControl.this.handleJobEvent(event.getResources(), true);
                                    break;
                                }
                                case UNFIXED: {
                                    PendingViewControl.this.handleJobEvent(event.getResources(), false);
                                    break;
                                }
                                case CREATE_CHANGELIST: {
                                    PendingViewControl.this.addLists(event.getResources());
                                    break;
                                }
                                case DELETE_CHANGELIST: {
                                    PendingViewControl.this.handleRemoveEvent(event.getPending());
                                    break;
                                }
                                case SUBMIT_CHANGELIST: {
                                    PendingViewControl.this.handleSubmitChangelistEvent(event.getPending());
                                    break;
                                }
                                case SUBMIT_FAILED: {
                                    PendingViewControl.this.refresh();
                                    break;
                                }
                                case SUBMITTED: {
                                    PendingViewControl.this.handleRemoveEvent(event.getUnopenedFiles());
                                    break;
                                }
                                case REVERTED: {
                                    PendingViewControl.this.handleRefresh((IP4Resource[])lists);
                                    PendingViewControl.this.handleRemoveEvent(event.getFiles());
                                    break;
                                }
                                case OPENED: {
                                    PendingViewControl.this.handleOpened(event.getFiles());
                                    break;
                                }
                                case MOVE_ADDED: {
                                    PendingViewControl.this.refresh();
                                    break;
                                }
                                case SUBMIT_SHELVEDCHANGELIST: {
                                    PendingViewControl.this.refresh();
                                    break;
                                }
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    protected String getSelectedName() {
        return Messages.PendingView_PendingChangelists;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

