/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4DecoratedLabelProvider;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.actions.NewServerAction;
import com.perforce.team.ui.actions.OpenAction;
import com.perforce.team.ui.p4java.actions.RemoveServerAction;
import com.perforce.team.ui.p4java.actions.ServerInfoAction;
import com.perforce.team.ui.views.DepotDragAdapter;
import com.perforce.team.ui.views.MenuFilter;
import com.perforce.team.ui.views.Messages;
import com.perforce.team.ui.views.ViewUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class DepotView
extends ViewPart {
    private Composite displayArea;
    private Composite noServersArea;
    private Label noServersDefined;
    private TreeViewer viewer;
    private PerforceContentProvider contentProvider;
    private IP4Listener p4Listener = new IP4Listener(){

        public void resoureChanged(final P4Event event) {
            UIJob job = new UIJob(Messages.DepotView_RefreshingDepotViewTree){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Tracing.printExecTime((boolean)Policy.DEBUG, (String)(String.valueOf(((Object)((Object)DepotView.this)).getClass().getSimpleName()) + ":resourceChanged()"), (String)event.toString(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (DepotView.this.okToUse()) {
                                switch (event.getType()) {
                                    case ADDED: {
                                        DepotView.this.handleAdded(event);
                                        break;
                                    }
                                    case AVAILABLE: {
                                        DepotView.this.handleAvailable(event);
                                        break;
                                    }
                                    case CHANGED: {
                                        DepotView.this.handleChanged(event);
                                        break;
                                    }
                                    case REFRESHED: {
                                        DepotView.this.handleRefresh(event);
                                        break;
                                    }
                                    case REMOVED: {
                                        DepotView.this.handleRemoved(event);
                                        break;
                                    }
                                }
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        public String getName() {
            return ((Object)((Object)DepotView.this)).getClass().getSimpleName();
        }
    };
    private Action refreshAction;
    private Action addAction;
    private Action deleteAction;
    private Action propertiesAction;
    private Action deletedAction;
    private Action openAction;
    private Action collapseAction;
    private boolean showDeletedFiles;
    private IMemento memento;
    private Action filterClientAction;
    private boolean filterClientFiles;
    public static final String VIEW_ID = "com.perforce.team.ui.DepotView";
    private static final String TAG_SERVER = "server";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_PATH = "path";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";

    public boolean okToUse() {
        return this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public static DepotView getView() {
        return (DepotView)PerforceUIPlugin.getActivePage().findView(VIEW_ID);
    }

    public static DepotView showView() {
        try {
            return (DepotView)PerforceUIPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException e) {
            PerforceProviderPlugin.logError((Throwable)e);
            return null;
        }
    }

    private void handleChanged(P4Event changedEvent) {
        IP4Connection[] iP4ConnectionArray = changedEvent.getConnections();
        int n = iP4ConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Connection connection = iP4ConnectionArray[n2];
            if (connection.isOffline()) {
                this.viewer.refresh((Object)connection);
            } else {
                this.viewer.update((Object)connection, null);
            }
            ++n2;
        }
    }

    private void handleRemoved(P4Event removedEvent) {
        this.viewer.remove((Object[])removedEvent.getConnections());
        this.updateTopControl();
    }

    private void handleAdded(P4Event addedEvent) {
        ArrayList<IP4Connection> newConnections = new ArrayList<IP4Connection>();
        IP4Resource[] iP4ResourceArray = addedEvent.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Connection connection;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Connection && !(connection = (IP4Connection)resource).isDisposed()) {
                connection.setShowClientOnly(this.filterClientFiles);
                connection.setShowFoldersWIthOnlyDeletedFiles(this.showDeletedFiles);
                newConnections.add(connection);
            }
            ++n2;
        }
        if (newConnections.size() > 0) {
            this.viewer.setInput((Object)P4ConnectionManager.getManager().getConnections());
            Iterator iterator = newConnections.iterator();
            if (iterator.hasNext()) {
                IP4Connection connection = (IP4Connection)iterator.next();
                if (connection.isConnected() && !connection.isOffline()) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)connection));
                }
                this.updateTopControl();
                this.viewer.reveal((Object)connection);
            }
        }
    }

    private void handleAvailable(P4Event availableEvent) {
        this.viewer.refresh((Object)availableEvent.getConnections());
    }

    private void handleRemove(IP4File[] files) {
        if (files.length > 0) {
            ArrayList<IP4File> remove = new ArrayList<IP4File>();
            IP4File[] iP4FileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file = iP4FileArray[n2];
                if (!file.isOpened() && !file.isRemote()) {
                    remove.add(file);
                }
                ++n2;
            }
            if (!remove.isEmpty()) {
                this.viewer.remove((Object[])remove.toArray(new IP4File[remove.size()]));
            }
        }
    }

    private void handleRefresh(P4Event refreshEvent) {
        this.handleRemove(refreshEvent.getFiles());
        IP4Resource[] iP4ResourceArray = refreshEvent.getResources();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            try {
                this.viewer.refresh((Object)resource);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void saveState(IMemento memento) {
        if (PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.SAVE_EXPANDED_DEPOTS")) {
            Tree tree;
            ScrollBar bar;
            Object[] elements;
            Object[] expandedElements = this.viewer.getVisibleExpandedElements();
            if (expandedElements.length > 0) {
                IMemento expandedMem = memento.createChild(TAG_EXPANDED);
                int i = 0;
                while (i < expandedElements.length) {
                    IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                    IP4Resource element = (IP4Resource)expandedElements[i];
                    if (element instanceof IP4Connection || element instanceof IP4Container) {
                        elementMem.putString(TAG_SERVER, this.getServerString(element));
                        elementMem.putString(TAG_PATH, element.getActionPath());
                    }
                    ++i;
                }
            }
            if ((elements = ((IStructuredSelection)this.viewer.getSelection()).toArray()).length > 0) {
                IMemento selectionMem = memento.createChild(TAG_SELECTION);
                int i = 0;
                while (i < elements.length) {
                    IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_SERVER, this.getServerString(elements[i]));
                    elementMem.putString(TAG_PATH, ((IP4Resource)elements[i]).getActionPath());
                    ++i;
                }
            }
            int position = (bar = (tree = this.viewer.getTree()).getVerticalBar()) != null ? bar.getSelection() : 0;
            memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
            bar = tree.getHorizontalBar();
            position = bar != null ? bar.getSelection() : 0;
            memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
        }
    }

    private void restoreState(IMemento memento) {
        String posStr2;
        Tree tree;
        ScrollBar bar;
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                String paramString = elementMem[i].getString(TAG_SERVER);
                if (paramString != null) {
                    String path = elementMem[i].getString(TAG_PATH);
                    this.expandElement(paramString, path);
                }
                ++i;
            }
        }
        if ((childMem = memento.getChild(TAG_SELECTION)) != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                String paramString = elementMem[i].getString(TAG_SERVER);
                Object element = this.expandElement(paramString, elementMem[i].getString(TAG_PATH));
                list.add(element);
                ++i;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(list));
        }
        if ((bar = (tree = this.viewer.getTree()).getVerticalBar()) != null) {
            try {
                posStr2 = memento.getString(TAG_VERTICAL_POSITION);
                int position = new Integer(posStr2);
                bar.setSelection(position);
            }
            catch (NumberFormatException posStr2) {
                // empty catch block
            }
        }
        if ((bar = tree.getHorizontalBar()) != null) {
            try {
                posStr2 = memento.getString(TAG_HORIZONTAL_POSITION);
                int position = new Integer(posStr2);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private Object expandElement(String paramString, String path) {
        if (paramString == null || paramString.length() == 0 || paramString.indexOf(32) == -1) {
            return null;
        }
        if (path == null) {
            return null;
        }
        ConnectionParameters params = new ConnectionParameters(paramString);
        IP4Connection curr = null;
        if (P4ConnectionManager.getManager().containsConnection(params)) {
            curr = P4ConnectionManager.getManager().getConnection(params);
        }
        if (curr == null || curr.getConnection().isOffline()) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            this.viewer.setExpandedState((Object)curr, true);
            IP4Resource[] children = curr.members();
            boolean found = false;
            int i = 0;
            while (i < children.length) {
                IP4Resource child = children[i];
                if (name.equals(child.getName()) && child instanceof IP4Container) {
                    curr = (IP4Container)child;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) break;
        }
        this.viewer.setExpandedState((Object)curr, true);
        return curr;
    }

    private String getServerString(Object element) {
        ConnectionParameters params = null;
        if (element instanceof IP4Resource) {
            params = ((IP4Resource)element).getConnection().getParameters();
        }
        if (params != null) {
            return params.toString();
        }
        return "";
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.depot_view");
        this.displayArea = new Composite(parent, 0);
        StackLayout daLayout = new StackLayout();
        this.displayArea.setLayout((Layout)daLayout);
        this.noServersArea = new Composite(this.displayArea, 0);
        this.noServersArea.setLayout((Layout)new GridLayout(1, false));
        this.noServersArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.noServersDefined = new Label(this.noServersArea, 64);
        this.noServersDefined.setLayoutData((Object)new GridData(4, 4, true, true));
        this.noServersDefined.setText(Messages.DepotView_NoConnectionsCurrentlyDefined);
        this.viewer = new TreeViewer(this.displayArea);
        this.viewer.setUseHashlookup(true);
        this.noServersDefined.setBackground(this.viewer.getTree().getBackground());
        this.noServersArea.setBackground(this.viewer.getTree().getBackground());
        this.contentProvider = new PerforceContentProvider((StructuredViewer)this.viewer){

            @Override
            public Object[] getElements(Object inputElement) {
                return P4ConnectionManager.getManager().getConnections();
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)P4DecoratedLabelProvider.create());
        this.addContextMenu();
        this.viewer.setComparator(ViewUtil.getViewComparator());
        this.viewer.addDragSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()}, (DragSourceListener)new DepotDragAdapter((ISelectionProvider)this.viewer));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DepotView.this.handleDoubleClick(event);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean empty = DepotView.this.viewer.getSelection().isEmpty();
                DepotView.this.propertiesAction.setEnabled(!empty);
                DepotView.this.deleteAction.setEnabled(!empty);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DepotView.this.viewer.getSelection();
                if (selection.getFirstElement() instanceof IP4Resource) {
                    P4ConnectionManager.getManager().setSelection(((IP4Resource)selection.getFirstElement()).getConnection());
                }
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean selected = true;
                if (!DepotView.this.showDeletedFiles && element instanceof IP4File) {
                    IP4File file = (IP4File)element;
                    boolean bl = selected = !file.isHeadActionDelete();
                }
                if (selected && DepotView.this.filterClientFiles) {
                    if (element instanceof IP4Connection) {
                        selected = true;
                    } else if (element instanceof P4Depot) {
                        selected = ((P4Depot)element).isLocal();
                    } else if (element instanceof IP4File) {
                        IP4File resource = (IP4File)element;
                        selected = resource.getLocalPath() != null;
                    }
                }
                return selected;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IP4Connection[] connections = ViewUtil.getConnections(this.filterClientFiles, this.showDeletedFiles);
        this.viewer.setInput((Object)connections);
        P4ConnectionManager.getManager().addListener(this.p4Listener);
        if (this.memento != null && PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.SAVE_EXPANDED_DEPOTS")) {
            this.restoreState(this.memento);
        }
        this.contentProvider.setLoadAsync(true);
        daLayout.topControl = connections.length == 0 ? this.noServersArea : this.viewer.getControl();
        this.displayArea.layout();
    }

    public void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IP4File) {
            OpenAction.openFile((IP4File)element);
        } else if (this.viewer.isExpandable(element)) {
            this.viewer.setExpandedState(element, !this.viewer.getExpandedState(element));
        }
    }

    public void refresh(Object obj) {
        this.viewer.refresh(obj, true);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refresh() {
        if (this.okToUse()) {
            this.viewer.collapseAll();
            this.viewer.refresh();
            this.updateTopControl();
        }
    }

    private void updateTopControl() {
        if (this.okToUse()) {
            StackLayout layout = (StackLayout)this.displayArea.getLayout();
            Control previous = layout.topControl;
            layout.topControl = this.viewer.getTree().getItemCount() > 0 ? this.viewer.getControl() : this.noServersArea;
            if (previous != layout.topControl) {
                this.displayArea.layout();
            }
        }
    }

    public boolean getShowDeletedFiles() {
        return this.showDeletedFiles;
    }

    public boolean getShowFilterClient() {
        return this.filterClientFiles;
    }

    private void addContextMenu() {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        final NewServerAction newAction = new NewServerAction();
        final RemoveServerAction removeAction = new RemoveServerAction();
        final ServerInfoAction serverInfoAction = new ServerInfoAction();
        this.refreshAction = new Action(Messages.DepotView_Refresh, plugin.getImageDescriptor("enabled/refresh.png")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)DepotView.this.viewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object refresh = objectArray[n2];
                    if (refresh instanceof IP4Container) {
                        ((IP4Container)refresh).markForRefresh();
                        if (refresh instanceof IP4Connection) {
                            ((IP4Connection)refresh).refresh();
                        }
                    } else if (refresh instanceof IP4File) {
                        P4Collection collection = P4ConnectionManager.getManager().createP4Collection(new IP4Resource[]{(IP4File)refresh});
                        collection.refresh();
                    }
                    DepotView.this.viewer.refresh(refresh, true);
                    ++n2;
                }
            }
        };
        this.refreshAction.setToolTipText(Messages.DepotView_Refresh);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/refresh.png"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/refresh.png"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.refreshAction, "com.perforce.team.ui.depot_refresh");
        this.addAction = new Action(Messages.DepotView_NewConnection, plugin.getImageDescriptor("normal/add.png")){

            public void run() {
                newAction.selectionChanged(null, DepotView.this.viewer.getSelection());
                newAction.run((IAction)this);
            }
        };
        this.deleteAction = new Action(Messages.DepotView_RemoveConnection, plugin.getImageDescriptor("normal/delete.png")){

            public void run() {
                if (!DepotView.this.viewer.getSelection().isEmpty()) {
                    removeAction.selectionChanged((IAction)this, DepotView.this.viewer.getSelection());
                    removeAction.run((IAction)this);
                }
            }
        };
        this.deleteAction.setEnabled(false);
        this.propertiesAction = new Action(Messages.DepotView_ServerInformation, plugin.getImageDescriptor("normal/properties.png")){

            public void run() {
                if (!DepotView.this.viewer.getSelection().isEmpty()) {
                    serverInfoAction.selectionChanged((IAction)this, DepotView.this.viewer.getSelection());
                    serverInfoAction.run((IAction)this);
                }
            }
        };
        this.propertiesAction.setEnabled(false);
        this.openAction = new Action(Messages.DepotView_Open){

            public void run() {
                Object[] selection = ((IStructuredSelection)DepotView.this.viewer.getSelection()).toArray();
                ArrayList<String> paths = new ArrayList<String>();
                int i = 0;
                while (i < selection.length) {
                    String localPath;
                    if (selection[i] instanceof IP4File && (localPath = ((IP4File)selection[i]).getLocalPath()) != null) {
                        paths.add(localPath);
                    }
                    ++i;
                }
                OpenAction.openFiles(paths.toArray(new String[paths.size()]));
            }
        };
        this.filterClientAction = new Action(Messages.DepotView_FilterByClientWorkspace){

            public int getStyle() {
                return 2;
            }
        };
        this.filterClientFiles = plugin.getPreferenceStore().getBoolean("com.perforce.team.ui.depot.filter_client_files");
        this.filterClientAction.setChecked(this.filterClientFiles);
        this.filterClientAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.depot.filter_client_files", DepotView.this.filterClientAction.isChecked());
                DepotView.this.filterClientFiles = DepotView.this.filterClientAction.isChecked();
                IP4Connection[] iP4ConnectionArray = P4ConnectionManager.getManager().getConnections();
                int n = iP4ConnectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Connection connection = iP4ConnectionArray[n2];
                    connection.setShowClientOnly(DepotView.this.filterClientFiles);
                    ++n2;
                }
                DepotView.this.refresh();
            }
        });
        this.deletedAction = new Action(Messages.DepotView_ShowDeletedDepotFiles){

            public int getStyle() {
                return 2;
            }
        };
        this.showDeletedFiles = plugin.getPreferenceStore().getBoolean("com.perforce.team.ui.depot.show_deleted_files");
        this.deletedAction.setChecked(this.showDeletedFiles);
        this.deletedAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.depot.show_deleted_files", DepotView.this.deletedAction.isChecked());
                DepotView.this.showDeletedFiles = DepotView.this.deletedAction.isChecked();
                IP4Connection[] iP4ConnectionArray = P4ConnectionManager.getManager().getConnections();
                int n = iP4ConnectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Connection connection = iP4ConnectionArray[n2];
                    connection.setShowFoldersWIthOnlyDeletedFiles(DepotView.this.showDeletedFiles);
                    ++n2;
                }
                DepotView.this.refresh();
            }
        });
        this.collapseAction = new Action(Messages.DepotView_CollapseAll){

            public void run() {
                DepotView.this.viewer.collapseAll();
            }
        };
        this.collapseAction.setToolTipText(Messages.DepotView_CollapseAll);
        this.collapseAction.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/collapseall.png"));
        MenuManager manager = new MenuManager();
        Tree tree = this.viewer.getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("perforce.opengroup"));
                manager.add((IContributionItem)new Separator("perforce.group1"));
                manager.add((IAction)DepotView.this.refreshAction);
                manager.add((IContributionItem)new Separator("perforce.group2"));
                manager.add((IContributionItem)new Separator("perforce.group3"));
                manager.add((IContributionItem)new Separator("perforce.group4"));
                manager.add((IContributionItem)new Separator("perforce.group5"));
                manager.add((IAction)DepotView.this.addAction);
                manager.add((IAction)DepotView.this.deleteAction);
                manager.add((IContributionItem)new Separator("additions"));
                DepotView.this.addOpenMenu(manager);
                DepotView.this.addOpenWithMenu(manager);
            }
        });
        manager.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.noServersDefined.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
        manager.addMenuListener((IMenuListener)MenuFilter.createTeamMainFilter());
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tbm = bars.getToolBarManager();
        tbm.add((IAction)this.addAction);
        tbm.add((IAction)this.deleteAction);
        tbm.add((IAction)this.propertiesAction);
        tbm.add((IAction)this.refreshAction);
        tbm.add((IAction)this.collapseAction);
        tbm.update(false);
        IMenuManager pulldown = bars.getMenuManager();
        pulldown.add((IAction)this.deletedAction);
        pulldown.add((IAction)this.filterClientAction);
        pulldown.update(false);
    }

    private void addOpenMenu(IMenuManager menu) {
        IP4File depotFile;
        IFile workspaceFile;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IP4File && (workspaceFile = (depotFile = (IP4File)selection.getFirstElement()).getLocalFileForLocation()) != null) {
            menu.appendToGroup("perforce.opengroup", (IAction)this.openAction);
        }
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IP4File depotFile;
        IFile workspaceFile;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IP4File && (workspaceFile = (depotFile = (IP4File)selection.getFirstElement()).getLocalFileForLocation()) != null) {
            MenuManager submenu = new MenuManager(Messages.DepotView_OpenWith);
            submenu.add((IContributionItem)new OpenWithMenu(this.getViewSite().getPage(), (IAdaptable)workspaceFile));
            menu.appendToGroup("perforce.opengroup", (IContributionItem)submenu);
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        super.dispose();
        P4ConnectionManager.getManager().removeListener(this.p4Listener);
    }
}

