/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.p4java.actions.ViewChangelistAction;
import com.perforce.team.ui.timelapse.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class TimeLapseChangelistWidget {
    private ScrolledComposite scrolls;
    private Text revisionText;
    private Text submittedText;
    private Text userText;
    private Text workspaceText;
    private Text actionText;
    private Link changelistText;
    private Text typeText;
    private SourceViewer descriptionText;
    private IP4Revision currentRevision = null;

    public TimeLapseChangelistWidget(Composite parent) {
        this.scrolls = new ScrolledComposite(parent, 768);
        this.scrolls.setExpandHorizontal(true);
        this.scrolls.setExpandVertical(true);
        this.scrolls.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite displayArea = new Composite((Composite)this.scrolls, 0);
        this.scrolls.setContent((Control)displayArea);
        GridLayout daLayout = new GridLayout(4, false);
        displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        displayArea.setLayoutData((Object)daData);
        GridData threeColData = new GridData(4, 4, true, false);
        threeColData.horizontalSpan = 3;
        GridData oneColData = new GridData(4, 4, true, false);
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_Revision);
        this.revisionText = this.createText(displayArea, threeColData);
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_DateSubmitted);
        this.submittedText = this.createText(displayArea, oneColData);
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_Changelist);
        this.changelistText = new Link(displayArea, 0);
        this.changelistText.setLayoutData((Object)oneColData);
        this.changelistText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TimeLapseChangelistWidget.this.currentRevision != null) {
                    ViewChangelistAction view = new ViewChangelistAction();
                    view.view(TimeLapseChangelistWidget.this.currentRevision.getChangelist(), TimeLapseChangelistWidget.this.currentRevision.getConnection(), IChangelist.Type.SUBMITTED);
                }
            }
        });
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_Submitted);
        this.userText = this.createText(displayArea, oneColData);
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_PerforceFiletype);
        this.typeText = this.createText(displayArea, oneColData);
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_Workspace);
        this.workspaceText = this.createText(displayArea, oneColData);
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_Action);
        this.actionText = this.createText(displayArea, oneColData);
        this.createLabel(displayArea, Messages.TimeLapseChangelistWidget_Description);
        this.descriptionText = new SourceViewer(displayArea, null, 2826);
        TextSourceViewerConfiguration config = P4UIUtils.createSourceViewerConfiguration(new IAdaptable(){

            public Object getAdapter(Class adapter) {
                IP4Revision revision = TimeLapseChangelistWidget.this.currentRevision;
                if (revision != null) {
                    if (IP4Connection.class == adapter || IP4Resource.class == adapter) {
                        return revision.getConnection();
                    }
                    return Platform.getAdapterManager().getAdapter((Object)revision, adapter);
                }
                return null;
            }
        });
        this.descriptionText.configure((SourceViewerConfiguration)config);
        this.descriptionText.setDocument((IDocument)new Document());
        GridData dtData = new GridData(4, 4, true, true);
        dtData.horizontalSpan = 3;
        dtData.heightHint = P4UIUtils.computePixelHeight(this.descriptionText.getTextWidget().getFont(), 4);
        this.descriptionText.getTextWidget().setLayoutData((Object)dtData);
        this.scrolls.setMinSize(displayArea.computeSize(-1, -1));
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private Text createText(Composite parent, int flags, GridData data) {
        Text text = new Text(parent, flags);
        text.setLayoutData((Object)data);
        return text;
    }

    private Text createText(Composite parent, GridData data) {
        return this.createText(parent, 12, data);
    }

    public void showRevision(IP4Revision revision) {
        this.currentRevision = revision;
        if (revision != null) {
            this.revisionText.setText(revision.getContentIdentifier());
            this.submittedText.setText(P4UIUtils.formatDate(revision.getTimestamp()));
            this.changelistText.setText(MessageFormat.format("<a href=\"open\">{0,number,#}</a>", revision.getChangelist()));
            this.userText.setText(revision.getAuthor());
            this.typeText.setText(revision.getType());
            this.workspaceText.setText(revision.getClient());
            FileAction action = revision.getAction();
            if (action != null) {
                this.actionText.setText(action.toString().toLowerCase());
            } else {
                this.actionText.setText("");
            }
            String comment = revision.getComment();
            if (comment == null) {
                comment = "";
            }
            this.descriptionText.getTextWidget().setText(comment);
        } else {
            String empty = "";
            this.revisionText.setText(empty);
            this.submittedText.setText(empty);
            this.changelistText.setText(empty);
            this.userText.setText(empty);
            this.typeText.setText(empty);
            this.workspaceText.setText(empty);
            this.actionText.setText(empty);
            this.descriptionText.getTextWidget().setText(empty);
        }
    }

    public Control getControl() {
        return this.scrolls;
    }
}

