/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.dialogs;

import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4SubmittedFile;
import com.perforce.team.ui.swarmreview.dialogs.NewReviewDialog;
import com.perforce.team.ui.swarmreview.restapi.Result;
import com.perforce.team.ui.views.SubmittedView;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NewSubmittedReviewDialog
extends NewReviewDialog<IP4SubmittedChangelist> {
    public NewSubmittedReviewDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    TableViewer createShelvedFilesToBeReviewedGrid(Composite parent) {
        return null;
    }

    protected void okPressed() {
        try {
            this.checkedFiles = this.getSelectedItems();
            String desc = this.descriptionTextViewer.getTextWidget().getText().trim();
            if (desc.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Description", (String)"Please specify a description to continue.");
            } else {
                Result<Boolean> result = this.controller.requestReview(this.checkedFiles, desc);
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Request Review", (String)result.getMessage());
                if (result.isSuccessful()) {
                    this.updateReviewerGrid(this.controller.getSelectedReviewerUsers().toArray());
                    SubmittedView.getView().refresh();
                    super.close();
                } else {
                    this.cancelPressed();
                }
            }
        }
        catch (Exception ex) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Request Review", (String)ex.getMessage());
            super.okPressed();
        }
    }

    @Override
    TableViewer createFilesToBeReviewedGrid(Composite parent) {
        this.checkboxTableViewer = new TableViewer(parent, 67584);
        Table filesTable = this.checkboxTableViewer.getTable();
        filesTable.setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true);
        gd_table.heightHint = 248;
        filesTable.setLayoutData((Object)gd_table);
        this.setupColumns();
        return this.checkboxTableViewer;
    }

    @Override
    String getDialogTitle() {
        return "The following files will be sent for review:";
    }

    void setupColumns() {
        String[] titles = new String[]{"File Name", "Revision", "Action", "File Type", "In Folder"};
        int[] bounds = new int[]{200, 80, 80, 80, 800};
        TableViewerColumn col = this.createTableViewerColumn(this.checkboxTableViewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getName();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return String.valueOf(((P4SubmittedFile)element).getFile().getHeadRevision());
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getP4JFile().getAction().toString();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getP4JFile().getFileType();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.checkboxTableViewer, titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof P4SubmittedFile) {
                    return ((P4SubmittedFile)element).getFile().getP4JFile().getDepotPathString();
                }
                return null;
            }
        });
    }

    @Override
    IP4Resource[] getSelectedItems() {
        ArrayList<P4SubmittedFile> tableItems = new ArrayList<P4SubmittedFile>();
        TableItem[] titems = this.checkboxTableViewer.getTable().getItems();
        if (titems != null && titems.length > 0) {
            TableItem[] tableItemArray = titems;
            int n = titems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                if (data instanceof P4SubmittedFile) {
                    tableItems.add((P4SubmittedFile)data);
                }
                ++n2;
            }
        }
        return (IP4Resource[])tableItems.toArray(new P4SubmittedFile[tableItems.size()]);
    }
}

