/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.dialogs;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.swarmreview.ReviewManager;
import com.perforce.team.ui.swarmreview.ReviewerUser;
import com.perforce.team.ui.swarmreview.ReviewerUserList;
import com.perforce.team.ui.swarmreview.dialogs.ChkBoxSupport;
import com.perforce.team.ui.swarmreview.dialogs.SelectUsersDialog;
import com.perforce.team.ui.swarmreview.restapi.Result;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class NewReviewDialog<T extends IP4Changelist>
extends Dialog {
    TableViewer checkboxTableViewer;
    TableViewer shelfTableViewer;
    private TableViewer reviewerTableViewer;
    private Table reviewerTable;
    private Text textReviewer;
    TextViewer descriptionTextViewer;
    private Button revertButton;
    private Button removeButton;
    private boolean revertChecked;
    private boolean removeChecked;
    IP4Resource[] checkedFiles;
    ReviewManager<T> controller;
    private static final Image CHECKED = PerforceUIPlugin.getPlugin().getImageDescriptor("views/checked.gif").createImage();
    private static final Image UNCHECKED = PerforceUIPlugin.getPlugin().getImageDescriptor("views/unchecked.gif").createImage();

    public NewReviewDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67696);
    }

    public void setController(ReviewManager<T> controller) {
        this.controller = controller;
    }

    abstract TableViewer createFilesToBeReviewedGrid(Composite var1);

    abstract TableViewer createShelvedFilesToBeReviewedGrid(Composite var1);

    abstract IP4Resource[] getSelectedItems();

    abstract String getDialogTitle();

    public IP4Resource[] getCheckedFiles() {
        return this.checkedFiles;
    }

    public boolean isRevertChecked() {
        return this.revertChecked;
    }

    public boolean isRemoveChecked() {
        return this.removeChecked;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label lblTheFollowingFiles = new Label(container, 0);
        lblTheFollowingFiles.setText(this.getDialogTitle());
        this.checkboxTableViewer = this.createFilesToBeReviewedGrid(container);
        Object[] shelffiles = this.controller.getShelvedReviewFiles();
        if (shelffiles != null && shelffiles.length > 0) {
            Label lblShelvedFiles = new Label(container, 0);
            lblShelvedFiles.setText("The following shelved files will be part of the review:");
            this.shelfTableViewer = this.createShelvedFilesToBeReviewedGrid(container);
            this.shelfTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.shelfTableViewer.setInput((Object)shelffiles);
        }
        Label lblDescription = new Label(container, 0);
        lblDescription.setText("Review Description:");
        this.descriptionTextViewer = new TextViewer(container, 2048);
        StyledText styledText = this.descriptionTextViewer.getTextWidget();
        GridData gd_styledText = new GridData(4, 4, true, true, 1, 1);
        gd_styledText.heightHint = 281;
        styledText.setLayoutData((Object)gd_styledText);
        Label lblReviewers = new Label(container, 0);
        lblReviewers.setText("Reviewers:");
        this.reviewerTableViewer = this.createReviewerdGrid(container);
        this.createUserSearchPanel(container);
        this.checkboxTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Object[] files = this.controller.getReviewFiles();
        this.checkboxTableViewer.setInput((Object)files);
        this.populateControls();
        this.revertButton = new Button(container, 32);
        this.revertButton.setText(Messages.ConfirmShelveDialog_RevertCheckedOutFiles);
        this.removeButton = new Button(container, 32);
        this.removeButton.setText(Messages.ConfirmShelveDialog_RemoveFilesOpenedForAdd);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!NewReviewDialog.this.revertButton.getSelection()) {
                    NewReviewDialog.this.removeButton.setEnabled(false);
                    NewReviewDialog.this.removeButton.setSelection(false);
                    return;
                }
                NewReviewDialog.this.removeButton.setEnabled(true);
                NewReviewDialog.this.revertChecked = NewReviewDialog.this.revertButton.getSelection();
                NewReviewDialog.this.removeChecked = NewReviewDialog.this.removeButton.getSelection();
            }
        };
        this.revertButton.addSelectionListener((SelectionListener)listener);
        this.removeButton.addSelectionListener((SelectionListener)listener);
        listener.widgetSelected(null);
        return container;
    }

    private void populateControls() {
        this.descriptionTextViewer.getTextWidget().setText(this.controller.getChangelistDescription());
    }

    private void createUserSearchPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        GridData gd_composite = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_composite.widthHint = 552;
        composite.setLayoutData((Object)gd_composite);
        Label lblUser = new Label(composite, 0);
        lblUser.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUser.setText("User:");
        this.textReviewer = new Text(composite, 2048);
        GridData gd_text = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_text.widthHint = 239;
        this.textReviewer.setLayoutData((Object)gd_text);
        Button btnAddReviewer = new Button(composite, 0);
        btnAddReviewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!NewReviewDialog.this.textReviewer.getText().isEmpty()) {
                    Result<String> result = NewReviewDialog.this.controller.addReviewerByName(NewReviewDialog.this.textReviewer.getText());
                    if (result.isSuccessful()) {
                        NewReviewDialog.this.updateReviewerGrid(NewReviewDialog.this.controller.getSelectedReviewerUsers().toArray());
                        NewReviewDialog.this.textReviewer.setText("");
                    } else {
                        MessageDialog.openError((Shell)NewReviewDialog.this.getShell(), (String)"Add reviewer", (String)result.getMessage());
                    }
                }
            }
        });
        btnAddReviewer.setText("Add");
        Button btnBrowse = new Button(composite, 0);
        btnBrowse.setText("Browse");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectUsersDialog usersdialog = new SelectUsersDialog(NewReviewDialog.this);
                usersdialog.setSwarmReviewDialogController(NewReviewDialog.this.controller);
                usersdialog.open();
            }
        });
        Button btnRemoveReviewer = new Button(composite, 0);
        btnRemoveReviewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = NewReviewDialog.this.reviewerTable.getSelection();
                if (items != null && items.length > 0 && MessageDialog.openConfirm((Shell)NewReviewDialog.this.getShell(), (String)"Remove reviewer", (String)"Are you sure you want to remove selected reviewer?")) {
                    ReviewerUserList userList = new ReviewerUserList();
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        ReviewerUser user = (ReviewerUser)item.getData();
                        userList.addReviewer(user);
                        ++n2;
                    }
                    NewReviewDialog.this.controller.removeReviewer(userList);
                    NewReviewDialog.this.updateReviewerGrid(NewReviewDialog.this.controller.getSelectedReviewerUsers().toArray());
                }
            }
        });
        btnRemoveReviewer.setText("Remove");
    }

    protected void cancelPressed() {
        this.controller.clearSelectedChangelistData();
        this.controller.clearReviewers();
        super.cancelPressed();
    }

    void updateReviewerGrid(Object[] data) {
        this.reviewerTableViewer.setInput((Object)data);
    }

    private TableViewer createReviewerdGrid(Composite parent) {
        String[] titles = new String[]{"User", "Required", "Full Name"};
        int[] bounds = new int[]{100, 100, 100};
        this.reviewerTableViewer = new TableViewer(parent, 67586);
        this.reviewerTable = this.reviewerTableViewer.getTable();
        GridData gd_table_1 = new GridData(4, 4, true, true, 1, 1);
        gd_table_1.heightHint = 278;
        this.reviewerTable.setLayoutData((Object)gd_table_1);
        TableViewerColumn col = this.createTableViewerColumn(this.reviewerTableViewer, titles[0], bounds[0], 0, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReviewerUser) {
                    return ((ReviewerUser)element).getLogin();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.reviewerTableViewer, titles[1], bounds[1], 1);
        ChkBoxSupport chkEditor = this.getCheckBoxEditor(this.reviewerTableViewer);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReviewerUser) {
                    return null;
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof ReviewerUser) {
                    if (((ReviewerUser)element).isRequired()) {
                        return CHECKED;
                    }
                    return UNCHECKED;
                }
                return UNCHECKED;
            }
        });
        col.setEditingSupport((EditingSupport)chkEditor);
        col = this.createTableViewerColumn(this.reviewerTableViewer, titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReviewerUser) {
                    return ((ReviewerUser)element).getFullName();
                }
                return null;
            }
        });
        this.reviewerTable.setHeaderVisible(true);
        this.reviewerTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return this.reviewerTableViewer;
    }

    private ChkBoxSupport getCheckBoxEditor(TableViewer viewer) {
        return new ChkBoxSupport(viewer);
    }

    TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setFocus(TableViewer viewer) {
        viewer.getControl().setFocus();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(1367, 692);
    }
}

