/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview;

import com.google.gson.Gson;
import com.perforce.p4java.admin.IProperty;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.server.GetPropertyOptions;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import com.perforce.team.ui.LogListener;
import com.perforce.team.ui.swarmreview.ReviewModel;
import com.perforce.team.ui.swarmreview.ReviewerUserList;
import com.perforce.team.ui.swarmreview.apimodel.Review;
import com.perforce.team.ui.swarmreview.apimodel.SwarmAPIVersions;
import com.perforce.team.ui.swarmreview.apimodel.SwarmReview;
import com.perforce.team.ui.swarmreview.apimodel.SwarmReviewList;
import com.perforce.team.ui.swarmreview.restapi.APIClient;
import com.perforce.team.ui.swarmreview.restapi.APIException;
import com.perforce.team.ui.swarmreview.restapi.AuthScheme;
import com.perforce.team.ui.swarmreview.restapi.JsonString;
import com.perforce.team.ui.swarmreview.restapi.Response;
import com.perforce.team.ui.swarmreview.restapi.Result;
import com.perforce.team.ui.swarmreview.util.SwarmReviewUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.program.Program;

public abstract class ReviewManager<T extends IP4Changelist> {
    private static Properties eclipseExternalProps = new Properties();
    private static String VERSION = "9";
    private String AUTH_TOKEN;
    String SWARM_URL;
    protected IP4Connection connection;
    boolean canConnectToSwarm;
    Result<SwarmAPIVersions> swarmVersionResult;
    private LogListener logListener = new LogListener();
    final String SWARM_API_PATH = "/api/v" + VERSION + "/reviews";
    boolean ignoreSSL;
    ReviewModel<T> model;

    static {
        String props = System.getProperty("user.home");
        try {
            eclipseExternalProps.load(new FileInputStream(new File(props, "/p4eclipse/p4eclipse.properties")));
            if (!eclipseExternalProps.isEmpty()) {
                VERSION = eclipseExternalProps.getProperty("swarm.version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ReviewManager() {
        this.logListener.init();
    }

    public abstract boolean updateChangelist();

    public abstract Result<Boolean> isChangeListCandidateForNewReview(T var1);

    public abstract Result<Boolean> isChangeListCandidateForUpdateReview(T var1);

    public abstract Result<Boolean> isOpenChange(T var1);

    public abstract Result<Boolean> isOpenReview(T var1);

    public abstract void init(T var1, boolean var2);

    abstract void populateCurrentChangelistItems(T var1);

    public String getChangelistDescription() {
        return this.model.getPendingChangeList().getDescription();
    }

    public IP4Connection getConnection() {
        return this.connection;
    }

    public String getExternalProperty(String key) {
        return eclipseExternalProps.getProperty(key);
    }

    public void log(String msg) {
        this.logListener.info(0, msg);
    }

    public Object[] getFilesInSelectedChangelist() {
        return this.model.getFilesInSelectedChangelist() == null ? new Object[]{} : this.model.getFilesInSelectedChangelist();
    }

    public Object[] getReviewFiles() {
        if (this.model.getFilesInSelectedChangelist() == null || this.model.getFilesInSelectedChangelist().length == 0) {
            this.updatePendingFiles();
        }
        return this.model.getFilesInSelectedChangelist() == null ? new Object[]{} : this.model.getFilesInSelectedChangelist();
    }

    public Object[] getFilesInSelectedShelf() {
        return this.model.getFilesInSelectedShelf() == null ? new Object[]{} : this.model.getFilesInSelectedShelf();
    }

    public void clearSelectedChangelistData() {
        this.model.setSelectedChangelistData(new Object[0]);
    }

    public List<Integer> getChangeListIdsLinkedToSwarm() {
        return this.model.getChangeListIdsLinkedToSwarm();
    }

    public Integer getSwarmReviewIdFor(Integer changeListId) {
        return this.model.getSwarmReviewIdFor(changeListId);
    }

    public ReviewerUserList getSelectedReviewerUsers() {
        return this.model.getSelectedReviewerUserList();
    }

    public Object[] getShelvedReviewFiles() {
        if (this.model.getShelvedChangeList() == null || this.model.getFilesInSelectedShelf().length == 0) {
            this.updatePendingFiles();
        }
        return this.model.getFilesInSelectedShelf() == null ? new Object[]{} : this.model.getFilesInSelectedShelf();
    }

    private void updatePendingFiles() {
        if (this.model.getShelvedChangeList() != null) {
            IP4ShelvedChangelist shelvedChange = this.model.getShelvedChangeList();
            IP4Resource[] shelvedFiles = shelvedChange.getFiles();
            if (shelvedFiles.length == 0) {
                shelvedChange.refresh();
                shelvedFiles = shelvedChange.getFiles();
            }
            this.model.setFilesInSelectedShelf(shelvedFiles);
            IP4Resource[] pendingfiles = this.model.getFilesInSelectedChangelist();
            IP4Resource[] allFiles = new IP4Resource[pendingfiles.length + (this.model.getFilesInSelectedShelf() != null ? this.model.getFilesInSelectedShelf().length : 0)];
            ArrayList<IP4Resource> shelved = new ArrayList<IP4Resource>(Arrays.asList(this.model.getFilesInSelectedShelf()));
            ArrayList<IP4Resource> pending = new ArrayList<IP4Resource>(Arrays.asList(pendingfiles));
            pending.addAll(shelved);
            allFiles = pending.toArray(allFiles);
        }
    }

    public int getPendingFilesCount() {
        int x = 0;
        if (this.model.getFilesInSelectedChangelist() != null && this.model.getFilesInSelectedChangelist().length > 0) {
            IP4Resource[] files;
            IP4Resource[] iP4ResourceArray = files = this.model.getFilesInSelectedChangelist();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource file = iP4ResourceArray[n2];
                if (!(file instanceof IP4ShelveFile)) {
                    ++x;
                }
                ++n2;
            }
        }
        return x;
    }

    public ReviewerUserList getReviewerUsers() {
        ReviewerUserList users = this.model.getReviewerUsers();
        if (users == null || users.getSize() == 0) {
            this.initReviewers();
        }
        return this.model.getReviewerUsers();
    }

    private IP4Resource[] getIP4Resources(Object[] resources) {
        IP4Resource[] resourceFiles = new IP4Resource[resources.length];
        if (resources != null) {
            int x = 0;
            Object[] objectArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Object resource = objectArray[n2];
                if (resource instanceof IP4File) {
                    resourceFiles[x] = (IP4File)resource;
                }
                ++x;
                ++n2;
            }
        }
        return resourceFiles;
    }

    public void clearReviewers() {
        this.model.getReviewerUsers();
        this.getSelectedReviewerUsers().clearList();
        this.model.setSearchedSwarmReviewId(null);
    }

    public void clearState() {
        this.AUTH_TOKEN = null;
        if (!this.canConnectToSwarm) {
            this.SWARM_URL = null;
        }
        this.model.setSelectedChangelistData(null);
        this.model.setSwarmSpecificChangelist(null);
        this.model.setFilesInSelectedChangelist(null);
        this.model.setPendingChangeList(null);
        this.model.setShelvedChangeList(null);
        this.model.setFilesInSelectedShelf(null);
        this.clearReviewers();
    }

    public void clearSwarmState() {
        this.SWARM_URL = null;
        this.canConnectToSwarm = false;
        this.swarmVersionResult = null;
    }

    public void clearCache() {
        this.model.clearSwarmLinkedChangeCache();
    }

    String getBasicAuthTicket() {
        if (this.AUTH_TOKEN == null) {
            this.updateAuthToken();
        }
        return this.AUTH_TOKEN;
    }

    private void updateAuthToken() {
        this.AUTH_TOKEN = String.valueOf(this.connection.getServer().getUserName()) + ":" + this.connection.getServer().getAuthTicket();
    }

    public Result<String> getSwarmURL() {
        Result<String> urlResult = new Result<String>(true);
        try {
            boolean found;
            if (this.SWARM_URL == null) {
                GetPropertyOptions propOpts = new GetPropertyOptions();
                String key = "P4.Swarm.URL";
                propOpts.setName(key);
                if (this.connection != null && this.connection.getServer() != null) {
                    List values = this.connection.getServer().getProperty(propOpts);
                    for (IProperty prop : values) {
                        if (!key.equals(prop.getName())) continue;
                        this.SWARM_URL = prop.getValue();
                        if (this.SWARM_URL != null && this.SWARM_URL.endsWith("/")) {
                            this.SWARM_URL = this.SWARM_URL.substring(0, this.SWARM_URL.lastIndexOf("/"));
                        }
                        urlResult.withSuccess("P4 Code Review URL located", this.SWARM_URL);
                        return urlResult;
                    }
                }
            }
            boolean bl = found = this.SWARM_URL != null;
            if (found && this.SWARM_URL.endsWith("/")) {
                this.SWARM_URL = this.SWARM_URL.substring(0, this.SWARM_URL.lastIndexOf("/"));
            }
            urlResult.withValues(found, true, found ? "P4 Code Review URL located" : "P4 Code Review not found", false, this.SWARM_URL);
        }
        catch (P4JavaException ex) {
            urlResult.withValues(false, true, "P4 Code Review not found", true, this.SWARM_URL);
            return urlResult;
        }
        return urlResult;
    }

    public void initReviewers() {
        try {
            Server server = (Server)this.connection.getServer();
            List users = server.getUsers(null, -1);
            ReviewerUserList reviewerUsers = new ReviewerUserList(users);
            this.model.setReviewerUsers(reviewerUsers);
        }
        catch (Exception ex) {
            throw new P4JavaError((Throwable)ex);
        }
    }

    public void addReviewerUsers(ReviewerUserList reviewers) {
        ReviewerUserList selectedReviewerUsers = this.model.getSelectedReviewerUserList();
        selectedReviewerUsers.addUnique(reviewers);
        this.model.setSelectedReviewerUserList(selectedReviewerUsers);
        this.mapReviewerToChangelist(this.model.getPendingChangeList().getId(), this.model.getSelectedReviewerUserList());
    }

    public void removeReviewer(ReviewerUserList reviewers) {
        try {
            ReviewerUserList alreadySelected = this.model.getSelectedReviewerUserList();
            if (alreadySelected != null && alreadySelected.getSize() > 0) {
                alreadySelected.removeReviewers(reviewers);
                this.model.setSelectedReviewerUserList(alreadySelected);
                this.removeReviewerMappedToChangelist(this.model.getPendingChangeList().getId(), reviewers);
            }
        }
        catch (Exception ex) {
            throw new P4JavaError((Throwable)ex);
        }
    }

    public Result<String> addReviewerByName(String reviewerName) {
        Result<String> result = new Result<String>(true, "Successfully added");
        try {
            ArrayList<String> reviewerNameList = new ArrayList<String>();
            reviewerNameList.add(reviewerName);
            Server server = (Server)this.connection.getServer();
            IUser user = server.getUser(reviewerName);
            if (user != null) {
                ReviewerUserList users = new ReviewerUserList(new IUserSummary[]{user});
                this.addReviewerUsers(users);
            } else {
                result.withNoSuccess("User " + reviewerName + " does not exist", false, reviewerName);
            }
        }
        catch (Exception ex) {
            result.withNoSuccess(ex.getMessage(), true, reviewerName);
        }
        return result;
    }

    private void mapReviewerToChangelist(Integer changeId, ReviewerUserList reviewers) {
        ReviewerUserList rlist = this.model.getChangeListIdToReviewerUserMap().get(changeId);
        if (rlist == null) {
            rlist = new ReviewerUserList();
            rlist.addReviewers(reviewers);
            this.model.getChangeListIdToReviewerUserMap().put(changeId, rlist);
        }
        rlist.addUnique(reviewers);
        this.model.getChangeListIdToReviewerUserMap().put(changeId, rlist);
    }

    private void removeReviewerMappedToChangelist(Integer changeId, ReviewerUserList reviewers) {
        ReviewerUserList rlist = this.model.getChangeListIdToReviewerUserMap().get(changeId);
        rlist.removeReviewers(reviewers);
    }

    public String getChangeListDescriptionFor(String reviewId) {
        String description = "Review ID not found";
        try {
            this.model.setSwarmSpecificChangelist(null);
            this.model.setSearchedSwarmReviewId(null);
            Result<Response<JsonString>> apiResult = this.callAPI("GET", String.valueOf(this.SWARM_API_PATH) + "/" + reviewId, null, null);
            if (!apiResult.isSuccessful()) {
                return description;
            }
            Response<JsonString> response = apiResult.getResultData();
            boolean ok = response.isSuccessful();
            if (ok) {
                SwarmReview swarmreview = SwarmReviewUtil.generateSwarmReviewFromJSON(response.getResponseBody().getJasonString());
                description = swarmreview.getReview().getDescription();
                this.model.setSearchedSwarmReviewId((int)swarmreview.getReview().getId());
            }
        }
        catch (NumberFormatException ex) {
            description = "Error - input value must be a number";
        }
        catch (APIException ex) {
            description = "Error - " + ex.getMessage();
        }
        catch (P4JavaException ex) {
            description = "Error - " + ex.getMessage();
        }
        return description;
    }

    public boolean isUpdateReview() {
        Result<Boolean> isChangelistLinkedToSwarmReview = this.extractReviewResultForChangeList(this.model.getPendingChangeList().getId());
        if (isChangelistLinkedToSwarmReview.isSuccessful()) {
            return isChangelistLinkedToSwarmReview.getResultData();
        }
        return this.model.getSwarmSpecificChangelist() != null || this.model.getSearchedSwarmReviewId() != null;
    }

    List<IFileSpec> extractFileSpecList() {
        IP4Resource[] resources = this.getIP4Resources(this.model.getSelectedChangelistData());
        ArrayList<String> paths = new ArrayList<String>();
        if (resources != null && resources.length > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource != null && (path = resource.getActionPath()) != null) {
                    paths.add(path);
                }
                ++n2;
            }
        }
        List specs = P4FileSpecBuilder.makeFileSpecList((String[])paths.toArray(new String[paths.size()]));
        return specs;
    }

    public Result<Boolean> extractReviewResultForChangeList(int changeListId) {
        Result<Boolean> result = this.isChangeListLinkedToSwarmReview(changeListId);
        return result;
    }

    private boolean changeListInReviewFound(Integer changeListId) {
        this.model.setSwarmSpecificChangelist(null);
        boolean changelistInSwarm = this.model.isChangeInReview(changeListId);
        if (changelistInSwarm) {
            Integer reviewIdInSwarm = this.model.getSwarmReviewIdFor(changeListId);
            this.model.setSwarmSpecificChangelist(reviewIdInSwarm);
        }
        return changelistInSwarm;
    }

    public Result<Boolean> isChangeListLinkedToSwarmReview(Integer changeListId) {
        Result<Boolean> result = new Result<Boolean>(true, "");
        if (this.changeListInReviewFound(changeListId)) {
            return result.withSuccess("Changelist has a corresponding review in swarm", Boolean.TRUE);
        }
        if (changeListId > -1) {
            try {
                Result<SwarmReviewList> reviewListResult = this.extractReviewsForChangeList(changeListId);
                if (!reviewListResult.isError() && reviewListResult != null && reviewListResult.isSuccessful()) {
                    boolean isEmpty = reviewListResult.getResultData().isEmpty();
                    if (!isEmpty) {
                        for (Review review : reviewListResult.getResultData().getReviews()) {
                            this.model.addChangeIdsLinkedToSwarm(review.getId(), review.getChanges());
                        }
                        result.withSuccess("P4 Code Review, reviews for change " + changeListId + " successfully retrieved", Boolean.TRUE);
                    } else {
                        result.withNoSuccess("No reviews found for change " + changeListId, false, Boolean.FALSE);
                    }
                } else {
                    result.withNoSuccess(reviewListResult.getMessage(), reviewListResult.isError(), Boolean.FALSE);
                }
            }
            catch (Exception ex) {
                result.withNoSuccess(ex.getMessage(), Boolean.FALSE, Boolean.FALSE);
            }
        }
        return result;
    }

    List<Integer> extractIdsFromPendingChangeLists(T[] lists) {
        ArrayList<Integer> clIdList = new ArrayList<Integer>();
        if (lists != null) {
            T[] TArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                T list = TArray[n2];
                if (list != null) {
                    this.model.addP4Changelist(list);
                    clIdList.add(list.getId());
                }
                ++n2;
            }
        }
        return clIdList;
    }

    void refreshChangelist(T[] lists) {
        if (lists != null) {
            T[] TArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                T list = TArray[n2];
                if (list != null && list instanceof IP4PendingChangelist) {
                    IP4ShelvedChangelist shelved = ((IP4PendingChangelist)list).getShelvedChanges();
                    list.refresh();
                }
                ++n2;
            }
        }
    }

    public T getP4ChangelistById(T cl) {
        return (T)((IP4Changelist)this.model.getP4ChangeListIdToChangeListMap().get(String.valueOf(cl.getId()) + "@" + cl.getClientName()));
    }

    public void cacheChangesLinkedToSwarm(T[] lists) {
        this.model.setAllP4ChangeLists(new ArrayList<T>(Arrays.asList(lists)));
        List clIdsList = this.extractIdsFromPendingChangeLists((IP4Changelist[])lists);
        this.doCacheChangesInReview(clIdsList.toArray(new Integer[clIdsList.size()]));
        this.updateReviewStatusOfChangelists((IP4Changelist[])lists);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
            }
        });
    }

    public void createCache(T[] lists) {
        this.clearSwarmState();
        Result<Boolean> result = this.canWeConnectToSwarm();
        if (lists != null && lists.length > 0 && result.isSuccessful()) {
            this.cacheChangesLinkedToSwarm((IP4Changelist[])lists);
        }
    }

    public List<T> getAllP4ChangeLists() {
        return this.model.getAllP4ChangeLists();
    }

    private void updateReviewStatusOfChangelists(T[] lists) {
        List<Integer> changesInReview = this.getChangeListIdsLinkedToSwarm();
        if (changesInReview != null) {
            block0: for (Integer id : changesInReview) {
                T[] TArray = lists;
                int n = lists.length;
                int n2 = 0;
                while (n2 < n) {
                    T list = TArray[n2];
                    if (id.equals(list.getId())) {
                        list.setHasReview(true);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
    }

    public void doCacheChangesInReview(Integer ... changeListIds) {
        Result<Boolean> result = new Result<Boolean>(true, "");
        ArrayList<Integer> changeIdsNotInCache = new ArrayList<Integer>();
        Integer[] integerArray = changeListIds;
        int n = changeListIds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer cl = integerArray[n2];
            if (!this.model.isChangeInReview(cl)) {
                changeIdsNotInCache.add(cl);
            }
            ++n2;
        }
        if (!changeIdsNotInCache.isEmpty()) {
            try {
                boolean isEmpty;
                Result<SwarmReviewList> reviewListResult = this.extractReviewsForChangeList(changeIdsNotInCache.toArray(new Integer[changeIdsNotInCache.size()]));
                if (!reviewListResult.isError() && reviewListResult != null && reviewListResult.isSuccessful() && !(isEmpty = reviewListResult.getResultData().isEmpty())) {
                    for (Review review : reviewListResult.getResultData().getReviews()) {
                        this.model.addChangeIdsLinkedToSwarm(review.getId(), review.getChanges());
                    }
                }
            }
            catch (Exception ex) {
                result.withNoSuccess(ex.getMessage(), Boolean.FALSE, Boolean.FALSE);
            }
        }
    }

    public void openSwarmReviewOnline() throws Exception {
        Integer chglistid = this.model.getPendingChangeList().getId();
        Result<String> onlineURL = this.getSwarmURL();
        if (onlineURL.isSuccessful()) {
            String URL2 = String.valueOf(onlineURL.getResultData()) + "/reviews/" + this.model.getSwarmReviewIdFor(chglistid);
            this.open(URL2);
        }
    }

    public void openSwarmChangeOnline() throws Exception {
        Integer chglistid = this.model.getPendingChangeList().getId();
        Result<String> onlineURL = this.getSwarmURL();
        if (onlineURL.isSuccessful()) {
            String URL2 = String.valueOf(onlineURL.getResultData()) + "/changes/" + chglistid;
            this.open(URL2);
        }
    }

    private void open(String URL2) {
        Program.launch((String)URL2);
    }

    private Result<SwarmReviewList> extractReviewsForChangeList(Integer ... changeListIds) {
        Result<SwarmReviewList> result;
        block15: {
            SwarmReviewList reviewList = new SwarmReviewList();
            result = new Result<SwarmReviewList>(true, "");
            String clString = "";
            if (changeListIds != null) {
                Integer[] integerArray = changeListIds;
                int n = changeListIds.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer cl = integerArray[n2];
                    clString = String.valueOf(clString) + "change[]=" + cl + "&";
                    ++n2;
                }
            }
            try {
                Result<Boolean> canConnectResult = this.canWeConnectToSwarm();
                if (!canConnectResult.isSuccessful()) {
                    Result<SwarmReviewList> result2 = result.withNoSuccess(canConnectResult.getMessage(), canConnectResult.isError(), reviewList);
                    return result2;
                }
                Result<Response<JsonString>> appiResult = this.callAPI("GET", this.SWARM_API_PATH, clString, "fields=id,changes");
                if (!appiResult.isSuccessful()) {
                    Result<SwarmReviewList> result3 = result.withNoSuccess(appiResult.isReportInSilence(), appiResult.getMessage(), appiResult.isError(), reviewList);
                    return result3;
                }
                try {
                    boolean ok;
                    Response<JsonString> response = appiResult.getResultData();
                    boolean bl = ok = appiResult.isSuccessful() && response.isSuccessful();
                    if (ok) {
                        reviewList = SwarmReviewUtil.generateSwarmReviewListFromJSON(response.getResponseBody().getJasonString());
                        result.withSuccess("Reviews successfully retrieved", reviewList);
                        break block15;
                    }
                    result.withNoSuccess("No reviews found for change ", false, reviewList);
                }
                catch (P4JavaException ex) {
                    result.withNoSuccess(ex.getMessage(), true, reviewList);
                }
                catch (APIException ex) {
                    result.withNoSuccess(ex.getLocalisedMessage(), true, reviewList);
                }
            }
            finally {
                if (result == null || !result.isSuccessful()) {
                    this.clearCache();
                }
            }
        }
        return result;
    }

    Result<Response<JsonString>> callAPI(String method, String urlPart, String queryParams, String filter) throws P4JavaException {
        Result<Response<JsonString>> responseResult = new Result<Response<JsonString>>(true);
        Result<String> URLResult = this.getSwarmURL();
        if (URLResult == null || !URLResult.isSuccessful()) {
            return responseResult.withNoSuccess(true, "P4 Code Review not configured. Unable to find P4 Code Review URL" + URLResult.getMessage(), true, null);
        }
        if (URLResult != null && URLResult.getResultData() != null && URLResult.getResultData().isEmpty()) {
            return responseResult.withNoSuccess(false, "Unble to connect to P4 Code Review, Invalid URL", true, null);
        }
        String URL2 = URLResult.getResultData();
        if (urlPart != null && !urlPart.isEmpty()) {
            URL2 = String.valueOf(URL2) + urlPart;
        }
        Response<JsonString> response = new APIClient().secure(this.ignoreSSL).withValues(method, URL2, queryParams, filter).withAuth(AuthScheme.Basic, this.getBasicAuthTicket()).asJsonStringResponse();
        responseResult.withValues(response.isOK(), false, response.getResponseMessage(), false, response);
        return responseResult;
    }

    Result<Boolean> canContinue() {
        Result<String> urlCheck = this.getSwarmURL();
        if (!urlCheck.isSuccessful()) {
            return new Result<Boolean>(urlCheck, urlCheck.isSuccessful());
        }
        Result<Boolean> swarmConnectResult = this.canWeConnectToSwarm();
        if (!swarmConnectResult.isSuccessful()) {
            return new Result<Boolean>(swarmConnectResult, swarmConnectResult.isSuccessful());
        }
        return new Result<Boolean>(true).withSuccess("Can connect to Swarm", true);
    }

    public Result<Boolean> canWeConnectToSwarm() {
        try {
            if (!this.canConnectToSwarm) {
                this.swarmVersionResult = this.checkVersion(VERSION);
                this.canConnectToSwarm = this.swarmVersionResult.isSuccessful();
            }
            this.log(this.swarmVersionResult.getMessage());
        }
        catch (Exception ex) {
            return new Result<Boolean>(false, ex.getMessage());
        }
        return new Result<Boolean>(this.swarmVersionResult, this.swarmVersionResult.isSuccessful());
    }

    public Result<SwarmAPIVersions> checkVersion(String expectedVersion) {
        Result<SwarmAPIVersions> result;
        block12: {
            result = new Result<SwarmAPIVersions>(true, "");
            String apiVersion = expectedVersion != null ? expectedVersion : VERSION;
            SwarmAPIVersions swarmAPIVersions = new SwarmAPIVersions();
            try {
                Result<Response<JsonString>> apiresult = this.callAPI("GET", "/api/version", null, null);
                if (!apiresult.isSuccessful()) {
                    Result<SwarmAPIVersions> result2 = result.withNoSuccess(apiresult.isReportInSilence(), "Could not connect to Swarm. " + apiresult.getMessage(), apiresult.isError(), swarmAPIVersions);
                    return result2;
                }
                try {
                    Response<JsonString> res = apiresult.getResultData();
                    if (res.isOK()) {
                        Gson gson = new Gson();
                        String response = res.getResponseBody().getJasonString();
                        swarmAPIVersions = (SwarmAPIVersions)gson.fromJson(response, SwarmAPIVersions.class);
                        boolean versionSupported = swarmAPIVersions.isVersionSupported(apiVersion);
                        if (versionSupported) {
                            result.withSuccess("API Version: " + apiVersion + " is currently supported by P4 Code Review", swarmAPIVersions);
                        } else {
                            result.withNoSuccess("P4 Code Review does not support API Version: " + apiVersion + " Currently supported version is v" + VERSION, false, swarmAPIVersions);
                        }
                        break block12;
                    }
                    result.withNoSuccess(res.getResponseMessage(), false, swarmAPIVersions);
                }
                catch (P4JavaException e) {
                    result.withNoSuccess(e.getMessage(), true, swarmAPIVersions);
                }
                catch (APIException e) {
                    result.withNoSuccess(e.getMessage(), true, swarmAPIVersions);
                }
            }
            finally {
                this.swarmVersionResult = result;
                this.canConnectToSwarm = this.swarmVersionResult.isSuccessful();
            }
        }
        return result;
    }

    boolean isChangelistInReview(T pendingChangeList) {
        boolean inReview = false;
        if (pendingChangeList == null) {
            return false;
        }
        if (pendingChangeList != null) {
            T selectedChangelIst = this.getP4ChangelistById(pendingChangeList);
            inReview = selectedChangelIst.hasReview();
        }
        return inReview;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<Boolean> requestReview(Object[] checkedFiles, String description) {
        client = null;
        changelist = null;
        isNewReview = true;
        result = new Result<T>(true, "");
        try {
            result = this.canWeConnectToSwarm();
            if (!result.isSuccessful()) {
                var21_7 = result;
                return var21_7;
            }
            if (checkedFiles == null) {
                checkedFiles = this.getFilesInSelectedChangelist();
                this.model.setSelectedChangelistData(checkedFiles);
            } else {
                this.model.setSelectedChangelistData(checkedFiles);
            }
            server = this.connection.getServer();
            client = server.getCurrentClient();
            specs = this.extractFileSpecList();
            changelist = this.model.getPendingChangeList().getChangelist();
            if (changelist == null) {
                changelist = client.createChangelist((IChangelist)new Changelist(-1, client.getName(), server.getUserName(), ChangelistStatus.NEW, null, description, false, (Server)server));
            } else {
                currDescription = changelist.getDescription();
                if (description != null && !description.isEmpty()) {
                    changelist.setDescription(description);
                    changelist.update(false);
                }
                v0 = isNewReview = (resultInSwarm = this.isChangeListLinkedToSwarmReview(changelist.getId())).isError() != false || resultInSwarm.isSuccessful() == false || resultInSwarm.getResultData() == false;
                if (resultInSwarm.isError()) {
                    result.withNoSuccess(resultInSwarm.getMessage(), resultInSwarm.isError(), resultInSwarm.getResultData());
                    var21_8 = result;
                    return var21_8;
                }
            }
            shelvedFiles /* !! */  = new ArrayList<E>();
            if (!specs.isEmpty()) {
                reopened = client.reopenFiles(specs, changelist.getId(), null);
                changelist.refresh();
                shelvedFiles /* !! */  = client.shelveChangelist(changelist.getId(), specs, true, false, false);
            }
            if (shelvedFiles /* !! */ .size() <= 0) {
                if (this.model.getFilesInSelectedShelf() == null) return result;
                if (this.model.getFilesInSelectedShelf().length <= 0) return result;
            }
            shelveStatusMsg = "";
            for (IFileSpec spec : shelvedFiles /* !! */ ) {
                v1 = error = spec.getOpStatus() == FileSpecOpStatus.ERROR;
                if (!error) continue;
                shelveStatusMsg = String.valueOf(shelveStatusMsg) + spec.getStatusMessage();
            }
            if (!shelveStatusMsg.trim().isEmpty()) {
                var21_9 = result.withNoSuccess(shelveStatusMsg, true, false);
                return var21_9;
            }
            path = String.valueOf(this.SWARM_API_PATH) + "/";
            param = "change=" + changelist.getId();
            reviewers = this.model.getSelectedReviewerUserList();
            reviewerParam = "";
            requiredReviewerParam = "";
            for (String reviewer : reviewers.getReviewersNotRequired()) {
                reviewerParam = String.valueOf(reviewerParam) + "reviewers[]=" + reviewer + "&";
            }
            for (String reviewer : reviewers.getRequiredReviewers()) {
                requiredReviewerParam = String.valueOf(requiredReviewerParam) + "requiredReviewers[]=" + reviewer + "&";
            }
            if (!isNewReview) ** GOTO lbl83
            searchedReviewId = null;
            searchedReviewId = this.model.getSearchedSwarmReviewId();
            if (searchedReviewId != null) {
                path = String.valueOf(path) + searchedReviewId + "/changes/";
            } else {
                param = String.valueOf(param) + "&" + reviewerParam;
                param = String.valueOf(param) + "&" + requiredReviewerParam;
            }
            apiResult = this.callAPI("POST", path, param, null);
            if (!apiResult.isSuccessful()) {
                var21_10 = result.withNoSuccess("Unable to create review: " + apiResult.getMessage(), apiResult.isError(), false);
                return var21_10;
            }
            response = apiResult.getResultData();
            ok = response.isOK();
            if (ok) {
                result.withSuccess("Review created", Boolean.TRUE);
                return result;
            }
            result.withNoSuccess("Unable to create review: " + response.getResponseMessage(), false, false);
            return result;
lbl83:
            // 1 sources

            result.withSuccess("Review updated", Boolean.TRUE);
            return result;
        }
        catch (APIException ex) {
            result.withNoSuccess(ex.getMessage(), true, false);
            return result;
        }
        catch (P4JavaException ex) {
            result.withNoSuccess(ex.getMessage(), true, false);
            return result;
        }
        finally {
            this.clearState();
        }
    }
}

