/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.team.ui.streams.ModelObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StreamsFilterModel
extends ModelObject {
    public static final String NAME = "name";
    public static final String PARENT = "parent";
    public static final String OWNER = "owner";
    public static final String DEPOT = "depot";
    public static final String TYPE = "type";
    private String name = "";
    private String parent = "";
    private String owner = "";
    private String depot = "";
    private String type = "";
    private boolean showUnloadedOnly = false;

    public StreamsFilterModel() {
    }

    public StreamsFilterModel(String name, String parent, String owner, String depot, String type) {
        this.name(name).parent(parent).owner(owner).depot(depot).type(type);
    }

    public void reset() {
        this.name("").parent("").owner("").depot("").type("");
    }

    public StreamsFilterModel name(String name) {
        this.name = name;
        return this;
    }

    public StreamsFilterModel parent(String parent) {
        this.parent = parent;
        return this;
    }

    public StreamsFilterModel owner(String owner) {
        this.owner = owner;
        return this;
    }

    public StreamsFilterModel depot(String depot) {
        this.depot = depot;
        return this;
    }

    public StreamsFilterModel showUnloadedOnly(boolean showUnloadedOnly) {
        this.showUnloadedOnly = showUnloadedOnly;
        return this;
    }

    public StreamsFilterModel type(String type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
        this.firePropertyChange(PARENT, this.parent, this.parent);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.firePropertyChange(OWNER, this.owner, this.owner);
    }

    public String getDepot() {
        return this.depot;
    }

    public void setDepot(String depot) {
        this.depot = depot;
        this.firePropertyChange(DEPOT, this.depot, this.depot);
    }

    public String getType() {
        return this.type;
    }

    public boolean isShowUnloadedOnly() {
        return this.showUnloadedOnly;
    }

    public void setType(String type) {
        this.type = type;
        this.firePropertyChange(TYPE, this.type, this.type);
    }

    public boolean hasDepot() {
        return !StringUtils.isEmpty((CharSequence)this.getDepot());
    }

    public String getFilterString() {
        StringBuilder sb = new StringBuilder();
        if (!this.getName().isEmpty()) {
            sb.append(" Name=*" + this.getName().trim() + "*");
        }
        if (!this.getOwner().isEmpty()) {
            sb.append(" Owner=" + this.getOwner().trim());
        }
        if (!this.getType().isEmpty()) {
            sb.append(" Type=" + this.getType().trim());
        }
        if (!this.getParent().isEmpty()) {
            sb.append(" Parent=" + this.getParent().trim());
        }
        if (sb.length() > 0) {
            return sb.toString().trim();
        }
        return null;
    }

    public List<String> getPaths() {
        if (!StringUtils.isEmpty((CharSequence)this.getDepot())) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add("//" + this.getDepot().trim() + "/...");
            return paths;
        }
        return null;
    }

    public String getDepotString() {
        if (!StringUtils.isEmpty((CharSequence)this.getDepot())) {
            return "//" + this.getDepot().trim() + "/...";
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.getFilterString()) + this.getDepotString();
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.getFilterString()) && StringUtils.isEmpty((CharSequence)this.getDepotString());
    }
}

