/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.dialogs.FileListViewer;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.ShelveChangelistAction;
import com.perforce.team.ui.shelve.UpdateShelveDialog;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ShelveFileDialog
extends P4StatusDialog {
    private FileListViewer viewer;
    private IP4PendingChangelist list;
    private IP4Resource[] allFiles;
    private IP4Resource[] checkedFiles;
    private IP4Resource[] selectedFiles;
    private UpdateShelveDialog.Option option;
    private Label countLabel;

    public ShelveFileDialog(Shell parent, IP4PendingChangelist list, IP4Resource[] resources, IP4Resource[] checked) {
        this(parent, list, resources, checked, UpdateShelveDialog.Option.UPDATE);
    }

    public ShelveFileDialog(Shell parent, IP4PendingChangelist list, IP4Resource[] resources, IP4Resource[] checked, UpdateShelveDialog.Option option) {
        super(parent);
        this.setModalResizeStyle();
        if (option == UpdateShelveDialog.Option.DELETE) {
            this.setTitle(MessageFormat.format(Messages.ShelveFileDialog_DeleteShelvedFiles, list.getId()));
        } else {
            this.setTitle(MessageFormat.format(Messages.ShelveFileDialog_ShelveFiles, list.getId()));
        }
        this.allFiles = this.getFiles(resources);
        this.list = list;
        this.checkedFiles = checked != null ? checked : this.allFiles;
        this.option = option;
        this.setModalResizeStyle();
    }

    public IP4Resource[] getSelectedFiles() {
        return this.selectedFiles;
    }

    private void updateCount() {
        int count = this.viewer.getCheckedElements().length;
        int max = this.viewer.getTable().getItemCount();
        this.countLabel.setText(MessageFormat.format(Messages.ShelveFileDialog_FilesNumSelected, count, max));
        if (count == 0) {
            this.setErrorMessage(Messages.ShelveFileDialog_MustSelectAtLeastOneFile, null);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout cLayout = new GridLayout(2, false);
        cLayout.marginHeight = 0;
        cLayout.marginWidth = 0;
        composite.setLayout((Layout)cLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.countLabel = new Label(composite, 16384);
        GridData clData = new GridData(4, 4, true, false);
        clData.verticalIndent = 5;
        clData.horizontalSpan = 2;
        this.countLabel.setLayoutData((Object)clData);
        this.viewer = new FileListViewer(composite, this.allFiles, this.checkedFiles, false);
        ((GridData)this.viewer.getTable().getLayoutData()).horizontalSpan = 2;
        this.updateCount();
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ShelveFileDialog.this.updateCount();
            }
        });
        return dialogArea;
    }

    public void updateSelection() {
        Object[] elements = this.viewer.getCheckedElements();
        this.selectedFiles = new IP4Resource[elements.length];
        int i = 0;
        while (i < elements.length) {
            this.selectedFiles[i] = (IP4Resource)elements[i];
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        String okLabel = null;
        okLabel = this.option == UpdateShelveDialog.Option.DELETE ? Messages.ShelveFileDialog_Delete : Messages.ShelveFileDialog_Shelve;
        this.okStatusButton = this.createButton(parent, 0, okLabel, true);
        Button advanced = this.createButton(parent, 13, Messages.ShelveFileDialog_Advanced, false);
        advanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShelveFileDialog.this.updateSelection();
                ShelveFileDialog.this.cancelPressed();
                P4Runner.schedule((IP4Runnable)new P4Runnable(){

                    public void run(IProgressMonitor monitor) {
                        ShelveChangelistAction action = new ShelveChangelistAction();
                        action.updateShelveNumbered(ShelveFileDialog.this.list, ShelveFileDialog.this.selectedFiles, ShelveFileDialog.this.option);
                    }

                    public String getTitle() {
                        return MessageFormat.format(Messages.ShelveFileDialog_UpdatingShelvedChangelist, ShelveFileDialog.this.list.getId());
                    }
                });
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.updateSelection();
        super.okPressed();
    }
}

