/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4ShelvedChangelist;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.ShelveAction;
import com.perforce.team.ui.shelve.UpdateShelveDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ShelveChangelistAction
extends P4Action {
    @Override
    protected boolean isEnabledEx() {
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        boolean enabled = false;
        if (resource instanceof IP4PendingChangelist) {
            IP4PendingChangelist list = (IP4PendingChangelist)resource;
            enabled = list.isOnClient() && list.getConnection().isShelvingSupported();
        }
        return enabled;
    }

    @Override
    protected void runAction() {
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        if (resource instanceof IP4PendingChangelist) {
            this.shelve((IP4PendingChangelist)resource);
        }
    }

    private void shelveDefault(final IP4PendingChangelist list) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                list.refresh();
                ShelveAction action = new ShelveAction();
                action.selectionChanged(null, (ISelection)new StructuredSelection((Object[])list.members()));
                action.setAsync(ShelveChangelistAction.this.isAsync());
                action.run(null);
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    public void updateShelveNumbered(IP4PendingChangelist list, IP4Resource[] selected) {
        this.updateShelveNumbered(list, selected, UpdateShelveDialog.Option.UPDATE);
    }

    public void updateShelveNumbered(final IP4PendingChangelist list, final IP4Resource[] selected, final UpdateShelveDialog.Option option) {
        P4ShelvedChangelist shelvedList = new P4ShelvedChangelist(list.getConnection(), list.getChangelist(), true);
        shelvedList.refresh();
        final IP4Resource[] shelvedFiles = shelvedList.members();
        final IP4Resource[] pendingFiles = list.members();
        final UpdateShelveDialog.ShelveChange[][] changes = new UpdateShelveDialog.ShelveChange[1][];
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                UpdateShelveDialog dialog = new UpdateShelveDialog(P4UIUtils.getDialogShell(), list, selected, shelvedFiles, pendingFiles, option);
                if (dialog.open() == 0) {
                    UpdateShelveDialog.ShelveChange[] shelveUpdates;
                    changes[0] = dialog.getChanges();
                    if (changes[0] != null && changes[0].length > 0 && (shelveUpdates = changes[0]).length > 0) {
                        P4Collection collectionSelection;
                        if (shelveUpdates[0].option == UpdateShelveDialog.Option.REPLACE) {
                            list.replaceShelvedFiles();
                            collectionSelection = ShelveChangelistAction.this.createCollection(pendingFiles);
                        } else {
                            ArrayList<IP4File> deletes = new ArrayList<IP4File>();
                            ArrayList<IP4File> updates = new ArrayList<IP4File>();
                            UpdateShelveDialog.ShelveChange[] shelveChangeArray = shelveUpdates;
                            int n = shelveUpdates.length;
                            int n2 = 0;
                            while (n2 < n) {
                                UpdateShelveDialog.ShelveChange change = shelveChangeArray[n2];
                                if (change.option == UpdateShelveDialog.Option.DELETE) {
                                    deletes.add(change.file);
                                } else if (change.option == UpdateShelveDialog.Option.ADD || change.option == UpdateShelveDialog.Option.UPDATE) {
                                    updates.add(change.file);
                                }
                                ++n2;
                            }
                            if (deletes.size() > 0) {
                                list.deleteShelve(deletes.toArray(new IP4Resource[deletes.size()]));
                            }
                            if (updates.size() > 0) {
                                list.updateShelvedFiles(updates.toArray(new IP4Resource[updates.size()]));
                            }
                            collectionSelection = ShelveChangelistAction.this.createCollection(updates.toArray(new IP4Resource[0]));
                        }
                        if (dialog.isRevertChecked()) {
                            collectionSelection.revert(dialog.isRemoveChecked());
                            collectionSelection.refreshLocalResources(2);
                            collectionSelection.resetStateValidation();
                            ShelveChangelistAction.this.updateActionState();
                        }
                    }
                }
            }
        });
    }

    private void shelveNumbered(final IP4PendingChangelist list) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                list.refresh();
                if (list.isShelved()) {
                    ShelveChangelistAction.this.updateShelveNumbered(list, null);
                } else {
                    ShelveAction action = new ShelveAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection((Object[])list.members()));
                    action.setAsync(ShelveChangelistAction.this.isAsync());
                    action.run(null);
                }
            }

            public String getTitle() {
                return MessageFormat.format(Messages.ShelveChangelistAction_UpdatingShelvedChangelist, list.getId());
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    public void shelve(IP4PendingChangelist list) {
        if (list != null) {
            if (list.isDefault()) {
                this.shelveDefault(list);
            } else {
                this.shelveNumbered(list);
            }
        }
    }
}

