/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.server;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.P4ClientUtil;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.server.ClientWidget;
import com.perforce.team.ui.server.Messages;
import java.text.MessageFormat;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EditClientDialog
extends P4StatusDialog {
    private IP4Connection connection = null;
    private IClient spec;
    private Composite displayArea;
    private ClientWidget editor;

    public EditClientDialog(Shell parent, IP4Connection connection) throws P4JavaException {
        super(parent);
        this.setModalResizeStyle();
        this.connection = connection;
        if (this.connection != null) {
            String title = MessageFormat.format(Messages.EditClientDialog_Workspace, this.connection.getParameters().getClient(), this.connection.getParameters().getPort(), this.connection.getParameters().getUser());
            this.setTitle(title);
            this.spec = this.connection.getClient();
        }
        if (this.spec == null) {
            throw new P4JavaException(Messages.EditClientDialog_SpecNotFound);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okStatusButton = this.createButton(parent, 0, Messages.EditClientDialog_Save, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void create() {
        super.create();
        this.updateButtonsEnableState(ValidationStatus.error((String)Messages.EditClientDialog_ClientNotChanged));
    }

    public ClientWidget getClientWidget() {
        return this.editor;
    }

    public IClient getEditedSpec() {
        return this.editor.getCurrentSpec();
    }

    private void save() {
        this.editor.updateCurrentSpec();
        IClient newSpec = this.getEditedSpec();
        this.connection.updateClient(newSpec);
    }

    protected void okPressed() {
        this.save();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor = new ClientWidget(this.connection, this.spec);
        this.editor.createControl(this.displayArea);
        this.editor.setErrorDisplay(this);
        SWTUtils.addContentListener((Control)c, new Runnable(){

            @Override
            public void run() {
                EditClientDialog.this.computeChangeAndUpdateButton();
            }
        });
        return c;
    }

    protected void computeChangeAndUpdateButton() {
        this.editor.updateCurrentSpec();
        IClient newSpec = this.getEditedSpec();
        if (newSpec == null || !P4ClientUtil.isClientChanged((IClient)this.spec, (IClient)newSpec)) {
            this.okStatusButton.setEnabled(false);
        } else {
            this.okStatusButton.setEnabled(true);
        }
    }
}

