/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.resource;

import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.resource.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LazyResourceBrowserWidget
extends BaseErrorProvider {
    private IWorkbenchAdapter adapter = null;
    private TreeViewer viewer = null;

    public LazyResourceBrowserWidget(IWorkbenchAdapter adapter) {
        this.adapter = adapter;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public IP4Resource getSelectedResource() {
        Object first;
        IP4Resource selected = null;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IP4Resource) {
            selected = (IP4Resource)first;
        }
        return selected;
    }

    @Override
    public void validate() {
        IP4Resource selected = this.getSelectedResource();
        this.errorMessage = selected == null ? Messages.ResourceBrowserWidget_SelectAResource : null;
        super.validate();
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2820);
        GridData vData = new GridData(4, 4, true, true);
        vData.heightHint = P4UIUtils.computePixelHeight(this.viewer.getTree().getFont(), 15);
        vData.widthHint = 300;
        this.viewer.getTree().setLayoutData((Object)vData);
        this.viewer.setContentProvider((IContentProvider)new PerforceContentProvider((StructuredViewer)this.viewer, true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(false));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LazyResourceBrowserWidget.this.validate();
            }
        });
        this.validate();
        this.initControl();
    }

    private void initControl() {
        final PerforceContentProvider.Loading loading = new PerforceContentProvider.Loading();
        this.viewer.setInput((Object)loading);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return "Loading resources...";
            }

            public void run(IProgressMonitor monitor) {
                final Object[] resources = LazyResourceBrowserWidget.this.adapter.getChildren((Object)loading);
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!LazyResourceBrowserWidget.this.viewer.getControl().isDisposed()) {
                            LazyResourceBrowserWidget.this.viewer.remove((Object)loading);
                            LazyResourceBrowserWidget.this.viewer.setInput((Object)resources);
                            LazyResourceBrowserWidget.this.validate();
                        }
                    }
                });
            }
        });
    }
}

