/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.refactor;

import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.refactor.DeleteManager;
import com.perforce.team.ui.refactor.IDeleteManager;
import com.perforce.team.ui.refactor.IMoveManager;
import com.perforce.team.ui.refactor.IntegManager;
import com.perforce.team.ui.refactor.Move91Manager;
import com.perforce.team.ui.refactor.Move92Manager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MoveDeleteManager
implements IMoveDeleteHook {
    private IDeleteManager deleteManager = new DeleteManager();
    private IMoveManager integManager = new IntegManager();
    private IMoveManager move92Manager = new Move92Manager();
    private IMoveManager move91Manager = new Move91Manager();

    private static boolean prefMove() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_refactor_use_move");
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.deleteManager.delete(tree, file, updateFlags, monitor);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.deleteManager.delete(tree, folder, updateFlags, monitor);
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.deleteManager.delete(tree, project, updateFlags, monitor);
    }

    private IMoveManager getMoveManager(IResource resource) {
        IServer server;
        IP4Connection connection;
        IMoveManager manager = this.integManager;
        if (MoveDeleteManager.prefMove() && (connection = P4ConnectionManager.getManager().getConnection(resource.getProject())) != null && (server = connection.getServer()) != null) {
            try {
                if (server.supportsSmartMove()) {
                    manager = connection.isMoveServerOnlySupported() ? this.move92Manager : this.move91Manager;
                }
            }
            catch (P4JavaException e) {
                manager = this.integManager;
            }
        }
        return manager;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IMoveManager manager = this.getMoveManager((IResource)source);
        return manager.move(tree, source, destination, updateFlags, monitor);
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IMoveManager manager = this.getMoveManager((IResource)source);
        return manager.move(tree, source, destination, updateFlags, monitor);
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        IMoveManager manager = this.getMoveManager((IResource)source);
        return manager.move(tree, source, description, updateFlags, monitor);
    }
}

