/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.refactor;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ChangelistSelection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.refactor.IMoveManager;
import com.perforce.team.ui.refactor.MoveManager;
import com.perforce.team.ui.refactor.MoveSession;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class Move91Manager
extends MoveManager
implements IMoveManager {
    public Move91Manager() {
        super(true, true);
    }

    @Override
    protected boolean moveFile(IP4File fromFile, IP4File toFile, ChangelistSelection changelist) {
        return fromFile.move(toFile, true, changelist, false);
    }

    @Override
    protected void moveFolder(IFolder source, IFolder destination, List<IP4File> files, ChangelistSelection changelist, IProgressMonitor monitor, MoveSession session) {
        try {
            IResource[] members;
            if (session != null) {
                session.moved(source, destination);
            }
            IResource[] iResourceArray = members = source.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    IFile sourceFile = (IFile)resource;
                    IFile destinationFile = destination.getFile(resource.getName());
                    this.internalMoveFile(sourceFile, destinationFile, files, changelist, monitor, session);
                } else if (resource instanceof IFolder) {
                    this.moveFolder((IFolder)resource, destination.getFolder(resource.getName()), files, changelist, monitor, session);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }
}

