/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.refactor;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ChangelistSelection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.refactor.IMoveManager;
import com.perforce.team.ui.refactor.MoveManager;
import com.perforce.team.ui.refactor.MoveSession;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class IntegManager
extends MoveManager
implements IMoveManager {
    public IntegManager() {
        super(false, false);
    }

    @Override
    protected boolean moveFile(IP4File fromFile, IP4File toFile, ChangelistSelection changelist) {
        return fromFile.move(toFile, false, changelist, true);
    }

    @Override
    protected void preUpdateTree(IResourceTree tree, IFolder source, IFolder destination, int flags, IProgressMonitor monitor) {
        tree.standardMoveFolder(source, destination, flags, monitor);
    }

    @Override
    protected void preUpdateTree(IResourceTree tree, IFile source, IFile destination, int flags, IProgressMonitor monitor) {
        ResourceAttributes attributes;
        if (P4CoreUtils.isMac() && (attributes = source.getResourceAttributes()) != null && attributes.isReadOnly()) {
            attributes.setReadOnly(false);
            try {
                source.setResourceAttributes(attributes);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        tree.standardMoveFile(source, destination, flags, monitor);
    }

    @Override
    protected void moveFolder(IFolder source, IFolder destination, List<IP4File> files, ChangelistSelection changelist, IProgressMonitor monitor, MoveSession session) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = destination.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    IFile destinationFile = (IFile)resource;
                    IFile sourceFile = source.getFile(resource.getName());
                    this.internalMoveFile(sourceFile, destinationFile, files, changelist, monitor, session);
                } else if (resource instanceof IFolder) {
                    this.moveFolder(source.getFolder(resource.getName()), (IFolder)resource, files, changelist, monitor, session);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }
}

