/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.project;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.connection.BaseConnectionWizardPage;
import com.perforce.team.ui.project.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ConnectionSelectionPage
extends BaseConnectionWizardPage {
    private Composite displayArea;
    private Button newButton;
    private Button existingButton;
    private TableViewer connectionTable;
    private boolean newConnection = false;
    private IP4Connection selected = null;

    protected ConnectionSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ConnectionSelectionPage_ChoosePerforceConnectionTitle);
        this.setDescription(Messages.ConnectionSelectionPage_ChoosePerforceConnectionDescription);
    }

    public boolean isNewConnection() {
        return this.newConnection;
    }

    public boolean isExistingConnection() {
        return !this.newConnection;
    }

    public IP4Connection getConnection() {
        return this.selected;
    }

    public IP4Connection[] getConnections() {
        return (IP4Connection[])this.connectionTable.getInput();
    }

    private void validate() {
        String message = null;
        if (this.isExistingConnection() && this.getConnection() == null) {
            message = Messages.ConnectionSelectionPage_SelectExistingConnection;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionAdapter buttonAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionSelectionPage.this.newConnection = ConnectionSelectionPage.this.newButton.getSelection();
                if (ConnectionSelectionPage.this.newConnection) {
                    ConnectionSelectionPage.this.selected = null;
                    ConnectionSelectionPage.this.connectionTable.setSelection(null);
                }
                ConnectionSelectionPage.this.connectionTable.getTable().setEnabled(!ConnectionSelectionPage.this.newConnection);
                ConnectionSelectionPage.this.validate();
            }
        };
        this.newButton = new Button(this.displayArea, 16);
        this.newButton.setText(Messages.ConnectionSelectionPage_ConfigureNewConnection);
        this.newButton.addSelectionListener((SelectionListener)buttonAdapter);
        this.existingButton = new Button(this.displayArea, 16);
        this.existingButton.setText(Messages.ConnectionSelectionPage_UseExistingConnection);
        this.existingButton.addSelectionListener((SelectionListener)buttonAdapter);
        this.connectionTable = new TableViewer(this.displayArea, 2820);
        this.connectionTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.connectionTable.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider());
        this.connectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        IP4Connection[] connections = P4ConnectionManager.getManager().getConnections();
        this.connectionTable.setInput((Object)connections);
        if (connections.length > 0) {
            this.existingButton.setSelection(true);
            this.newConnection = false;
            this.selected = connections[0];
            this.connectionTable.setSelection((ISelection)new StructuredSelection((Object)this.selected));
        } else {
            this.newButton.setSelection(true);
            this.newConnection = true;
            this.connectionTable.getTable().setEnabled(false);
            this.connectionTable.setSelection(null);
        }
        this.connectionTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectionSelectionPage.this.selected = (IP4Connection)((IStructuredSelection)event.getSelection()).getFirstElement();
                ConnectionSelectionPage.this.validate();
            }
        });
        this.existingButton.addSelectionListener((SelectionListener)buttonAdapter);
        this.setControl((Control)this.displayArea);
    }

    public TableViewer getConnectionViewer() {
        return this.connectionTable;
    }
}

