/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.ui.p4java.dialogs.BrowseChangeListDialog;
import com.perforce.team.ui.p4java.dialogs.BrowseLabelDialog;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.VersionComboViewer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RevisionUptoWidget2
extends Composite
implements IntegrateToStreamDialog.IRevisionRangeWidget {
    private Button endButton;
    private VersionComboViewer endCombo;
    private Text endText;
    private Button endBrowseBtn;
    private Object endVer = null;
    private String endOption = null;
    private IP4Connection connection;

    public RevisionUptoWidget2(Composite parent, int style, String title, IP4Connection connection) {
        super(parent, style);
        this.connection = connection;
        this.createControl(this, title);
        this.init();
        this.addListeners();
    }

    private void init() {
        boolean enableEnd = true;
        if (this.endOption == null) {
            enableEnd = false;
        }
        this.endButton.setSelection(enableEnd);
        this.endCombo.setEnabled(enableEnd);
        this.endText.setEnabled(enableEnd);
        this.endBrowseBtn.setEnabled(enableEnd);
    }

    private void addListeners() {
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = RevisionUptoWidget2.this.endButton.getSelection();
                RevisionUptoWidget2.this.endCombo.setEnabled(enabled);
                RevisionUptoWidget2.this.endText.setEnabled(enabled);
                RevisionUptoWidget2.this.endBrowseBtn.setEnabled(RevisionUptoWidget2.this.endCombo.getSelectedObject() != null && enabled);
                if (!enabled) {
                    RevisionUptoWidget2.this.endOption = null;
                }
            }
        });
        this.endCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevisionUptoWidget2.this.endText.setText("");
                RevisionUptoWidget2.this.endOption = String.valueOf(RevisionUptoWidget2.this.getPrefix(RevisionUptoWidget2.this.endCombo)) + RevisionUptoWidget2.this.endText.getText();
                RevisionUptoWidget2.this.endBrowseBtn.setEnabled(RevisionUptoWidget2.this.endCombo.getSelectedObject() != null && RevisionUptoWidget2.this.endCombo.getSelectedObject() != VersionComboViewer.VersionType.Revision);
            }
        });
        this.endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RevisionUptoWidget2.this.endOption = String.valueOf(RevisionUptoWidget2.this.getPrefix(RevisionUptoWidget2.this.endCombo)) + RevisionUptoWidget2.this.endText.getText();
            }
        });
        this.endBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionComboViewer.VersionType type = RevisionUptoWidget2.this.endCombo.getSelectedObject();
                if (type != VersionComboViewer.VersionType.Revision) {
                    BrowseChangeListDialog dlg;
                    if (type == VersionComboViewer.VersionType.Label) {
                        BrowseLabelDialog dlg2 = new BrowseLabelDialog(RevisionUptoWidget2.this.getShell(), RevisionUptoWidget2.this.connection);
                        if (dlg2.open() == 0) {
                            RevisionUptoWidget2.this.endVer = dlg2.getSelectedLabel();
                            RevisionUptoWidget2.this.endText.setText(((IP4Label)RevisionUptoWidget2.this.endVer).getLabel().getName());
                        }
                    } else if (type == VersionComboViewer.VersionType.ChangeList && (dlg = new BrowseChangeListDialog(RevisionUptoWidget2.this.getShell(), RevisionUptoWidget2.this.connection)).open() == 0) {
                        RevisionUptoWidget2.this.endVer = dlg.getSelectedChangeList();
                        RevisionUptoWidget2.this.endText.setText(String.valueOf(((IP4Changelist)RevisionUptoWidget2.this.endVer).getChangelist().getId()));
                    }
                }
            }
        });
    }

    private void createControl(Composite parent, String title) {
        parent.setLayout((Layout)new FillLayout());
        Group limitArea = new Group(parent, 0);
        limitArea.setText(title);
        GridLayout laLayout = new GridLayout(4, false);
        limitArea.setLayout((Layout)laLayout);
        this.endButton = new Button((Composite)limitArea, 32);
        this.endButton.setText(Messages.RevisionUptoWidget2_RevisionsUpTo);
        this.endCombo = new VersionComboViewer((Composite)limitArea, 8);
        this.endCombo.setEnabled(false);
        this.endText = new Text((Composite)limitArea, 2052);
        this.endText.setEnabled(false);
        GridDataFactory.swtDefaults().hint(50, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.endText);
        this.endBrowseBtn = new Button((Composite)limitArea, 16384);
        this.endBrowseBtn.setText(Messages.RevisionUptoWidget2_Browse);
        this.endBrowseBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    private String getPrefix(VersionComboViewer combo) {
        VersionComboViewer.VersionType type = combo.getSelectedObject();
        if (type != null) {
            return type.getPrefix();
        }
        return "";
    }

    @Override
    public IStatus validate() {
        boolean hasEnd = this.endButton.getSelection();
        if (hasEnd) {
            if (this.endCombo.getSelectedObject() == null) {
                return ValidationStatus.error((String)Messages.RevisionUptoWidget2_VersionTypeNotSetError);
            }
            if (StringUtils.isEmpty((CharSequence)this.endText.getText())) {
                return ValidationStatus.error((String)Messages.RevisionUptoWidget2_VersionNotSetError);
            }
        }
        return ValidationStatus.ok();
    }

    @Override
    public String getStart() {
        return null;
    }

    @Override
    public String getEnd() {
        return this.endOption;
    }

    @Override
    public Composite getControl() {
        return this;
    }
}

