/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4FileIntegration;
import com.perforce.team.core.p4java.P4IntegrationOptions;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.SelectBranchDialog;
import com.perforce.team.ui.changelists.PendingCombo;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.p4java.dialogs.IntegOptionWidget;
import com.perforce.team.ui.p4java.dialogs.IntegrationPreviewDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.resource.ResourceBrowserDialog;
import com.perforce.team.ui.views.SessionManager;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class IntegrateDialog
extends P4StatusDialog {
    public static final String TRY_AUTO_RESOLVE = "com.perforce.team.ui.preferences.TRY_AUTO_RESOLVE";
    private Composite displayArea;
    private TabFolder specTabs;
    private TabItem fileTab;
    private Combo sourceText;
    private Combo targetText;
    private Button attemptSafeResolveButton;
    private TabItem branchTab;
    private Combo nameText;
    private Button limitButton;
    private Text limitText;
    private Button sourceButton;
    private Button targetButton;
    private Group limitArea;
    private Button startButton;
    private Button endButton;
    private Combo startCombo;
    private Combo endCombo;
    private Text startText;
    private Text endText;
    private Label startHelp;
    private Label endHelp;
    private PendingCombo changelistCombo;
    private Label progressLabel;
    private ProgressBar progressBar;
    private Button preview;
    private Button integrate;
    private boolean fileIntegration = true;
    private boolean isAddPreviouslyLinkedJobs = false;
    private IP4Resource resource = null;
    private String sourcePath = null;
    private String targetPath = null;
    private String startOption = null;
    private String branchName = null;
    private String endOption = null;
    private Button addPreviouslyLinkedJobButton;
    private Label linkedJobDisabledPrompt;
    private ModifyListener validateListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            IntegrateDialog.this.validate();
        }
    };
    private ModifyListener pathListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            IntegrateDialog.this.updatePaths();
        }
    };
    private IP4SubmittedChangelist defaultLimit = null;
    private P4IntegrationOptions defaultOptions;
    private P4IntegrationOptions integrationOptions;
    private IntegOptionWidget optionWidget = IntegOptionWidget.INTEG3;

    public IntegrateDialog(Shell parent, IP4Resource resource) {
        super(parent, Messages.getString("IntegrateDialog_Integrate"));
        this.setStatusLineAboveButtons(true);
        this.setModalResizeStyle();
        this.resource = resource;
        if (this.resource instanceof IP4Branch) {
            this.branchName = this.resource.getName();
        } else {
            this.sourcePath = this.resource.getActionPath();
            this.targetPath = this.resource.getActionPath();
        }
        this.initOptionWidget(resource);
    }

    public IntegrateDialog(Shell parent, IP4Connection connection, String sourcePath, String targetPath) {
        super(parent, Messages.getString("IntegrateDialog_Integrate"));
        this.setStatusLineAboveButtons(true);
        this.setModalResizeStyle();
        this.resource = connection;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.initOptionWidget(this.resource);
    }

    private void initOptionWidget(IP4Resource resource) {
        this.optionWidget = this.createWidget(resource);
        this.integrationOptions = this.optionWidget.getDefaultIntegrationOptions();
    }

    private IntegOptionWidget createWidget(IP4Resource resource) {
        IntegOptionWidget widget = null;
        IP4Connection connection = resource.getConnection();
        IServer server = connection.getServer();
        String stream = connection.getClient().getStream();
        if (StringUtils.isNotBlank((CharSequence)stream)) {
            widget = IntegOptionWidget.INTEG3;
        } else {
            int serverVer = server.getServerVersionNumber();
            String level = null;
            try {
                IServerInfo info = server.getServerInfo();
                level = info.getIntegEngine();
            }
            catch (Exception e) {
                PerforceProviderPlugin.logError((String)e.getLocalizedMessage());
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError(null, (String)Messages.getString("MessageDialog.error.connection.title"), (String)Messages.getString("MessageDialog.error.connection.msg"));
                    }
                });
            }
            widget = level == null ? (serverVer < 20111 ? IntegOptionWidget.INTEG2 : IntegOptionWidget.INTEG3) : IntegOptionWidget.valueOf("INTEG" + level.trim());
        }
        return widget;
    }

    public P4IntegrationOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultEnabledOptions(P4IntegrationOptions options) {
        this.defaultOptions = options;
    }

    public P4FileIntegration getCurrentFileIntegrationInfo() {
        P4FileIntegration integration = new P4FileIntegration();
        integration.setEnd(this.endOption);
        integration.setStart(this.startOption);
        integration.setSource(this.sourcePath);
        integration.setTarget(this.targetPath);
        return integration;
    }

    public boolean isFileIntegration() {
        return this.fileIntegration;
    }

    public boolean isAddPreviouslyLinkedJobs() {
        return this.isAddPreviouslyLinkedJobs;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.preview = this.createButton(parent, 13, Messages.getString("IntegrateDialog_Preview"), false);
        this.preview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateDialog.this.updateHistory();
                IntegrateDialog.this.runPreview(IntegrateDialog.this.getChangeListDescription());
            }
        });
        this.integrate = this.createButton(parent, 0, Messages.getString("IntegrateDialog_Integrate"), true);
        this.createButton(parent, 1, Messages.getString("IntegrateDialog_Cancel"), false);
    }

    private void runPreview(String description) {
        final int changelist = this.getPendingChangelistId();
        final IP4Connection connection = this.resource.getConnection();
        final String name = this.branchName;
        this.updateOptions();
        final P4IntegrationOptions options = this.integrationOptions;
        final P4FileIntegration integration = this.getCurrentFileIntegrationInfo();
        this.startPreview();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.getString("IntegrateDialog_GeneratingIntegPreview");
            }

            public void run(IProgressMonitor monitor) {
                final IP4Resource[] previewed = connection.integratePreview(integration, name, changelist, "", true, options, false);
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!IntegrateDialog.this.displayArea.isDisposed()) {
                            IntegrateDialog.this.stopPreview();
                            new IntegrationPreviewDialog(IntegrateDialog.this.getShell(), previewed).open();
                        }
                    }
                });
            }
        });
    }

    public int getPendingChangelistId() {
        return this.changelistCombo.getSelected();
    }

    private void startPreview() {
        this.progressBar.setEnabled(true);
        this.progressBar.setVisible(true);
        this.progressLabel.setText(Messages.getString("IntegrateDialog_GeneratingIntegPreview"));
        this.preview.setEnabled(false);
    }

    private void stopPreview() {
        this.progressBar.setEnabled(false);
        this.progressBar.setVisible(false);
        this.progressLabel.setText("");
        this.preview.setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(container, 0);
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.specTabs = new TabFolder(this.displayArea, 128);
        this.specTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateDialog.this.updatePaths();
                IntegrateDialog.this.validate();
            }
        });
        this.specTabs.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.resource instanceof IP4SubmittedChangelist) {
            this.setDefaultLimitOnIntegration((IP4SubmittedChangelist)this.resource);
        }
        this.createFileArea(this.specTabs);
        this.createBranchArea(this.specTabs);
        this.createLimitArea(this.displayArea);
        this.createOptionsArea(this.displayArea);
        this.createChangelistArea(this.displayArea);
        if (this.resource instanceof IP4Branch) {
            this.specTabs.setSelection(this.branchTab);
        } else if (StringUtils.isNotBlank((CharSequence)this.sourcePath) && StringUtils.isNotBlank((CharSequence)this.targetPath)) {
            this.specTabs.setSelection(this.fileTab);
        } else {
            this.specTabs.setSelection(this.branchTab);
        }
        this.specTabs.notifyListeners(13, null);
        this.validate();
        return container;
    }

    public void setDefaultLimitOnIntegration(IP4SubmittedChangelist changelist) {
        this.defaultLimit = changelist;
    }

    private void createFileArea(TabFolder folder) {
        this.fileTab = new TabItem(folder, 0);
        this.fileTab.setText(Messages.getString("IntegrateDialog_FileSpec"));
        Composite filePathArea = new Composite((Composite)folder, 0);
        this.fileTab.setControl((Control)filePathArea);
        GridLayout fpaLayout = new GridLayout(3, false);
        filePathArea.setLayout((Layout)fpaLayout);
        filePathArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label sourceLabel = new Label(filePathArea, 16384);
        sourceLabel.setText(Messages.getString("IntegrateDialog_SourceLabel"));
        this.sourceText = new Combo(filePathArea, 4);
        SessionManager.loadComboHistory(this.sourceText, "com.perforce.team.ui.preferences.SOURCE_FILE_HISTORY");
        this.sourceText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (StringUtils.isNotBlank((CharSequence)this.sourcePath)) {
            this.sourceText.setText(this.sourcePath);
        }
        this.sourceText.addModifyListener(this.pathListener);
        this.sourceText.addModifyListener(this.validateListener);
        this.createBrowseForFileButton(filePathArea, this.sourceText);
        Label targetLabel = new Label(filePathArea, 16384);
        targetLabel.setText(Messages.getString("IntegrateDialog_TargetLabel"));
        this.targetText = new Combo(filePathArea, 2052);
        SessionManager.loadComboHistory(this.targetText, "com.perforce.team.ui.preferences.TARGET_FILE_HISTORY");
        this.targetText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (StringUtils.isNotBlank((CharSequence)this.targetPath)) {
            this.targetText.setText(this.targetPath);
        }
        this.targetText.addModifyListener(this.pathListener);
        this.targetText.addModifyListener(this.validateListener);
        this.createBrowseForFileButton(filePathArea, this.targetText);
        new Label(filePathArea, 0);
    }

    private void createBrowseForFileButton(Composite parent, final Object update) {
        final Button browseSource = new Button(parent, 8);
        browseSource.setText(Messages.getString("IntegrateDialog_Browse"));
        browseSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Connection conn = IntegrateDialog.this.resource.getConnection();
                boolean showClientOnly = conn.showClientOnly();
                try {
                    String actionPath;
                    IP4Resource resource;
                    conn.setShowClientOnly(false);
                    ResourceBrowserDialog dialog = new ResourceBrowserDialog(browseSource.getShell(), conn.members());
                    if (dialog.open() == 0 && (resource = dialog.getSelectedResource()) != null && (actionPath = resource.getActionPath(IP4Resource.Type.REMOTE)) != null) {
                        if (update instanceof Combo) {
                            ((Combo)update).setText(actionPath);
                        } else if (update instanceof Text) {
                            ((Text)update).setText(actionPath);
                        }
                    }
                }
                finally {
                    conn.setShowClientOnly(showClientOnly);
                }
            }
        });
    }

    private void createBranchArea(TabFolder folder) {
        this.branchTab = new TabItem(folder, 0);
        this.branchTab.setText(Messages.getString("IntegrateDialog_BranchSpec"));
        Composite branchArea = new Composite((Composite)folder, 0);
        this.branchTab.setControl((Control)branchArea);
        GridLayout baLayout = new GridLayout(3, false);
        branchArea.setLayout((Layout)baLayout);
        branchArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label nameLabel = new Label(branchArea, 16384);
        nameLabel.setText(Messages.getString("IntegrateDialog_BranchName"));
        this.nameText = new Combo(branchArea, 4);
        SessionManager.loadComboHistory(this.nameText, "com.perforce.team.ui.preferences.BRANCH_HISTORY");
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.branchName != null) {
            this.nameText.setText(this.branchName);
        }
        this.nameText.addModifyListener(this.pathListener);
        this.nameText.addModifyListener(this.validateListener);
        final Button browseButton = new Button(branchArea, 8);
        browseButton.setText(Messages.getString("IntegrateDialog_Browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Branch selected;
                SelectBranchDialog dialog = new SelectBranchDialog(browseButton.getShell(), IntegrateDialog.this.resource.getConnection());
                if (dialog.open() == 0 && (selected = dialog.getSelected()) != null && selected.getName() != null) {
                    IntegrateDialog.this.nameText.setText(selected.getName());
                    IntegrateDialog.this.validate();
                }
            }
        });
        Composite limitArea = new Composite(branchArea, 0);
        GridData laData = new GridData(4, 4, true, false);
        laData.horizontalSpan = 3;
        limitArea.setLayoutData((Object)laData);
        GridLayout laLayout = new GridLayout(4, false);
        limitArea.setLayout((Layout)laLayout);
        this.limitButton = new Button(limitArea, 32);
        this.limitButton.setText(Messages.getString("IntegrateDialog_LimitIntegTo"));
        this.limitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = IntegrateDialog.this.limitButton.getSelection();
                IntegrateDialog.this.limitText.setEnabled(enabled);
                IntegrateDialog.this.targetButton.setEnabled(enabled);
                IntegrateDialog.this.sourceButton.setEnabled(enabled);
                IntegrateDialog.this.optionWidget.enableReverseButton(!enabled);
            }
        });
        this.limitText = new Text(limitArea, 2052);
        this.limitText.setEnabled(false);
        GridData ltData = new GridData(4, 0x1000000, true, false);
        ltData.horizontalSpan = 2;
        this.limitText.setLayoutData((Object)ltData);
        this.createBrowseForFileButton(limitArea, this.limitText);
        Label usePathLabel = new Label(limitArea, 16384);
        usePathLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        usePathLabel.setText(Messages.getString("IntegrateDialog_UsePathAs"));
        SelectionAdapter limitListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateDialog.this.updatePaths();
            }
        };
        this.limitText.addModifyListener(this.pathListener);
        this.limitButton.addSelectionListener((SelectionListener)limitListener);
        this.sourceButton = new Button(limitArea, 16);
        this.sourceButton.setText(Messages.getString("IntegrateDialog_Source"));
        this.sourceButton.setEnabled(false);
        this.sourceButton.setSelection(true);
        this.sourceButton.addSelectionListener((SelectionListener)limitListener);
        this.targetButton = new Button(limitArea, 16);
        this.targetButton.setText(Messages.getString("IntegrateDialog_Target"));
        this.targetButton.setEnabled(false);
        new Label(limitArea, 0);
        new Label(limitArea, 0);
        this.targetButton.addSelectionListener((SelectionListener)limitListener);
    }

    private void validate() {
        this.setErrorMessage(this.findFirstError(), null);
    }

    private String findFirstError() {
        TabItem[] tabs = this.specTabs.getSelection();
        String errorMessage = null;
        if (tabs.length == 1) {
            if (tabs[0] == this.fileTab) {
                if (StringUtils.isBlank((CharSequence)this.sourceText.getText())) {
                    errorMessage = Messages.getString("IntegrateDialog_MustEnterSourcePath");
                }
                if (StringUtils.isBlank((CharSequence)this.targetText.getText())) {
                    errorMessage = Messages.getString("IntegrateDialog_MustEnterTargetPath");
                }
            } else if (tabs[0] == this.branchTab && StringUtils.isBlank((CharSequence)this.nameText.getText())) {
                errorMessage = Messages.getString("IntegrateDialog_MustEnterBranchName");
            }
        }
        return errorMessage;
    }

    public void updatePaths() {
        TabItem[] tabs = this.specTabs.getSelection();
        if (tabs.length == 1) {
            if (tabs[0] == this.branchTab) {
                this.branchName = this.nameText.getText();
                if (this.limitButton.getSelection()) {
                    if (this.sourceButton.getSelection()) {
                        String limitSource = this.limitText.getText();
                        this.sourcePath = StringUtils.isNotEmpty((CharSequence)limitSource) ? limitSource : null;
                        this.targetPath = null;
                    } else {
                        this.sourcePath = "//...";
                        String limitTarget = this.limitText.getText();
                        this.targetPath = StringUtils.isNotEmpty((CharSequence)limitTarget) ? limitTarget : null;
                    }
                } else {
                    this.targetPath = null;
                    this.sourcePath = null;
                }
            } else if (tabs[0] == this.fileTab) {
                this.branchName = null;
                this.sourcePath = this.sourceText.getText();
                this.targetPath = this.targetText.getText();
            }
        }
    }

    private void createLimitArea(Composite parent) {
        this.limitArea = new Group(parent, 0);
        this.limitArea.setText(Messages.getString("IntegrateDialog_LimitRevRange"));
        this.limitArea.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout laLayout = new GridLayout(4, false);
        this.limitArea.setLayout((Layout)laLayout);
        this.startButton = new Button((Composite)this.limitArea, 32);
        this.startButton.setText(Messages.getString("IntegrateDialog_Start"));
        this.startButton.setEnabled(false);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = IntegrateDialog.this.startButton.getSelection();
                IntegrateDialog.this.startCombo.setEnabled(enabled);
                IntegrateDialog.this.startText.setEnabled(enabled);
                IntegrateDialog.this.startHelp.setVisible(enabled);
                if (!enabled) {
                    IntegrateDialog.this.startOption = null;
                }
            }
        });
        this.startCombo = new Combo((Composite)this.limitArea, 12);
        this.startCombo.add(Messages.getString("IntegrateDialog_Revision"));
        this.startCombo.add(Messages.getString("IntegrateDialog_Changelist"));
        this.startCombo.add(Messages.getString("IntegrateDialog_Label"));
        this.startCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String prefix = IntegrateDialog.this.getPrefix(IntegrateDialog.this.startCombo.getSelectionIndex());
                IntegrateDialog.this.startOption = String.valueOf(prefix) + IntegrateDialog.this.startText.getText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.startCombo.setEnabled(false);
        this.startText = new Text((Composite)this.limitArea, 2052);
        this.startText.setEnabled(false);
        this.startText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String prefix = IntegrateDialog.this.getPrefix(IntegrateDialog.this.startCombo.getSelectionIndex());
                IntegrateDialog.this.startOption = String.valueOf(prefix) + IntegrateDialog.this.startText.getText();
            }
        });
        this.startHelp = new Label((Composite)this.limitArea, 16384);
        this.startHelp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addComboListener(this.startCombo, this.startHelp);
        this.endButton = new Button((Composite)this.limitArea, 32);
        this.endButton.setText(Messages.getString("IntegrateDialog_End"));
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = IntegrateDialog.this.endButton.getSelection();
                IntegrateDialog.this.endCombo.setEnabled(enabled);
                IntegrateDialog.this.endText.setEnabled(enabled);
                IntegrateDialog.this.startButton.setEnabled(enabled);
                IntegrateDialog.this.startCombo.setEnabled(enabled);
                IntegrateDialog.this.startText.setEnabled(enabled);
                if (!enabled) {
                    IntegrateDialog.this.startButton.setSelection(false);
                    IntegrateDialog.this.endOption = null;
                    IntegrateDialog.this.startOption = null;
                }
            }
        });
        this.endCombo = new Combo((Composite)this.limitArea, 12);
        this.endCombo.add(Messages.getString("IntegrateDialog_Revision"));
        this.endCombo.add(Messages.getString("IntegrateDialog_Changelist"));
        this.endCombo.add(Messages.getString("IntegrateDialog_Label"));
        this.endCombo.setEnabled(false);
        this.endCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String prefix = IntegrateDialog.this.getPrefix(IntegrateDialog.this.endCombo.getSelectionIndex());
                IntegrateDialog.this.endOption = String.valueOf(prefix) + IntegrateDialog.this.endText.getText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.endText = new Text((Composite)this.limitArea, 2052);
        this.endText.setEnabled(false);
        this.endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String prefix = IntegrateDialog.this.getPrefix(IntegrateDialog.this.endCombo.getSelectionIndex());
                IntegrateDialog.this.endOption = String.valueOf(prefix) + IntegrateDialog.this.endText.getText();
            }
        });
        this.endHelp = new Label((Composite)this.limitArea, 16384);
        this.endHelp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addComboListener(this.endCombo, this.endHelp);
        if (this.defaultLimit != null) {
            this.startCombo.select(1);
            this.endCombo.select(1);
            this.startHelp.setText(Messages.getString("IntegrateDialog_EnterChangelistNumber"));
            this.endHelp.setText(Messages.getString("IntegrateDialog_EnterChangelistNumber"));
            this.startButton.setEnabled(true);
            this.startButton.setSelection(true);
            this.endButton.setSelection(true);
            this.startCombo.setEnabled(true);
            this.endCombo.setEnabled(true);
            this.startText.setEnabled(true);
            this.endText.setEnabled(true);
            int id = this.defaultLimit.getId();
            this.startText.setText(Integer.toString(id));
            this.endText.setText(Integer.toString(id));
        } else {
            this.startCombo.select(0);
            this.endCombo.select(0);
            this.startHelp.setText(Messages.getString("IntegrateDialog_EnterRevisionNumber"));
            this.endHelp.setText(Messages.getString("IntegrateDialog_EnterRevisionNumber"));
        }
    }

    private String getPrefix(int index) {
        String prefix = null;
        switch (index) {
            case 0: {
                prefix = "#";
                break;
            }
            case 1: 
            case 2: {
                prefix = "@";
                break;
            }
            default: {
                prefix = "";
            }
        }
        return prefix;
    }

    private void addComboListener(final Combo combo, final Label help) {
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = combo.getText();
                if (text.equals(Messages.getString("IntegrateDialog_Revision"))) {
                    help.setText(Messages.getString("IntegrateDialog_EnterRevisionNumber"));
                } else if (text.equals(Messages.getString("IntegrateDialog_Changelist"))) {
                    help.setText(Messages.getString("IntegrateDialog_EnterChangelistNumber"));
                } else if (text.equals(Messages.getString("IntegrateDialog_Label"))) {
                    help.setText(Messages.getString("IntegrateDialog_EnterLabel"));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createOptionsArea(Composite parent) {
        this.optionWidget.createOptionsArea(parent);
        this.specTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabItem[] tabs = IntegrateDialog.this.specTabs.getSelection();
                IntegrateDialog.this.optionWidget.enableReverseButton(tabs.length == 1 && tabs[0] == IntegrateDialog.this.branchTab);
            }
        });
        this.attemptSafeResolveButton = new Button(parent, 32);
        this.attemptSafeResolveButton.setText(Messages.getString("IntegrateDialog_PerformSafeAutoresolve"));
        this.attemptSafeResolveButton.setSelection(PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(TRY_AUTO_RESOLVE));
        this.optionWidget.initControl(this.defaultOptions);
    }

    private void createChangelistArea(Composite parent) {
        this.changelistCombo = new PendingCombo(this.resource);
        this.changelistCombo.createControl(parent, IP4Connection.INTEGRATE_DEFAULT_DESCRIPTION);
        PendingCombo.PendingComboSelectionAdapter defaultPendingComboSelectionAdapter = this.changelistCombo.getPendingComboSelectionAdapter();
        PendingCombo pendingCombo = this.changelistCombo;
        pendingCombo.getClass();
        this.changelistCombo.bindPendingComboSelectionAdapter(new PendingCombo.PendingComboSelectionAdapter(pendingCombo, defaultPendingComboSelectionAdapter){

            @Override
            protected void callbackIfIsNewChangeList() {
                IntegrateDialog.this.linkedJobDisabledPrompt.setVisible(false);
                IntegrateDialog.this.addPreviouslyLinkedJobButton.setEnabled(true);
                IntegrateDialog.this.addPreviouslyLinkedJobButton.setSelection(false);
            }

            @Override
            protected void callbackIfIsDefaultChangeList() {
                IntegrateDialog.this.linkedJobDisabledPrompt.setVisible(true);
                IntegrateDialog.this.addPreviouslyLinkedJobButton.setEnabled(false);
                IntegrateDialog.this.addPreviouslyLinkedJobButton.setSelection(false);
            }

            @Override
            protected void callbackIfIsNormalChangeList() {
                IntegrateDialog.this.linkedJobDisabledPrompt.setVisible(false);
                IntegrateDialog.this.addPreviouslyLinkedJobButton.setEnabled(true);
                IntegrateDialog.this.addPreviouslyLinkedJobButton.setSelection(false);
            }
        });
        this.createAddPreviouslyLinkedJobArea(this.displayArea);
        this.progressLabel = new Label(this.displayArea, 16384);
        this.progressLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressBar = new ProgressBar(this.displayArea, 65794);
        this.progressBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressBar.setEnabled(false);
        this.progressBar.setVisible(false);
    }

    private void createAddPreviouslyLinkedJobArea(Composite parent) {
        Composite panel = new Composite(parent, 1024);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        panel.setLayout((Layout)new GridLayout(1, true));
        this.addPreviouslyLinkedJobButton = new Button(panel, 32);
        this.addPreviouslyLinkedJobButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        this.addPreviouslyLinkedJobButton.setText(Messages.getString("IntegrateDialog_AddPreviouseLinkeJob"));
        this.addPreviouslyLinkedJobButton.setEnabled(false);
        this.addPreviouslyLinkedJobButton.setSelection(false);
        this.addPreviouslyLinkedJobButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateDialog.this.linkedJobDisabledPrompt.setVisible(!IntegrateDialog.this.addPreviouslyLinkedJobButton.getSelection());
                IntegrateDialog.this.isAddPreviouslyLinkedJobs = IntegrateDialog.this.addPreviouslyLinkedJobButton.getSelection();
            }
        });
        this.linkedJobDisabledPrompt = new Label(panel, 1024);
        this.linkedJobDisabledPrompt.setText(Messages.getString("IntegrateDialog_AddPreviouseLinkeJob_disabled"));
        this.linkedJobDisabledPrompt.setVisible(true);
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getChangeListDescription() {
        return this.changelistCombo.getDescription();
    }

    public String getEndRevisionOption() {
        return this.endOption;
    }

    public P4IntegrationOptions getSelectedIntegrationOptions() {
        return this.integrationOptions;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getStartRevisionOption() {
        return this.startOption;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    protected void okPressed() {
        this.updatePaths();
        this.updateOptions();
        this.updateHistory();
        this.updatePreferences();
        super.okPressed();
    }

    public void updateOptions() {
        this.optionWidget.updateOptions(this.integrationOptions);
        this.integrationOptions.setTrySafeResolve(this.attemptSafeResolveButton.getSelection());
    }

    private void updateHistory() {
        String target;
        String source;
        String branch = this.nameText.getText().trim();
        if (branch.length() > 0) {
            SessionManager.saveComboHistory(this.nameText, 10, "com.perforce.team.ui.preferences.BRANCH_HISTORY");
        }
        if ((source = this.sourceText.getText().trim()).length() > 0) {
            SessionManager.saveComboHistory(this.sourceText, 10, "com.perforce.team.ui.preferences.SOURCE_FILE_HISTORY");
        }
        if ((target = this.targetText.getText().trim()).length() > 0) {
            SessionManager.saveComboHistory(this.targetText, 10, "com.perforce.team.ui.preferences.TARGET_FILE_HISTORY");
        }
    }

    private void updatePreferences() {
        boolean tryResolve = this.attemptSafeResolveButton.getSelection();
        PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(TRY_AUTO_RESOLVE, tryResolve);
    }

    public void setBaselessMerge(boolean merge) {
        this.optionWidget.setBaselessMerge(merge);
    }

    public void setDisregardHistory(boolean disregard) {
        this.optionWidget.setDisregardHistory(disregard);
    }

    public void setDoNotCopy(boolean doNotCopy) {
        this.optionWidget.setDoNotCopy(doNotCopy);
    }

    public void setDoNotGetLatestRevision(boolean latest) {
        this.optionWidget.setDoNotGetLatest(latest);
    }

    public void setIntegrateAroundDeleted(boolean integrate) {
        this.optionWidget.setIntegrateAroundDeleted(integrate);
    }

    public void setPropogateFiletypes(boolean propogate) {
        this.optionWidget.setPropogateFiletypes(propogate);
    }

    public void setReverseMappings(boolean reverse) {
        this.optionWidget.setReverseMappings(reverse);
    }

    @Override
    protected void updateButtonsEnableState(IStatus status) {
        if (this.integrate != null && !this.integrate.isDisposed()) {
            this.integrate.setEnabled(!status.matches(4));
        }
    }
}

