/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.resource.LazyResourceBrowserDialog;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DepotFileChooser
extends Composite
implements IntegrateToStreamDialog.IDepotFileChooser {
    private IP4Resource resource;
    private Text pathText;
    private String path = "";
    private IWorkbenchAdapter adapter;

    DepotFileChooser(Composite parent, int style, IP4Resource resource, IWorkbenchAdapter adapter) {
        super(parent, style);
        this.resource = resource;
        this.adapter = adapter;
        this.createControl(this);
        this.addListeners();
    }

    private void addListeners() {
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public String getDepotPath() {
        return this.path;
    }

    private void createControl(Composite parent) {
        String actionPath;
        GridLayoutFactory.swtDefaults().margins(1, 5).numColumns(2).applyTo(parent);
        SWTUtils.createLabel(parent, Messages.DepotFileChooser_MergeOnlyFileFolders, 2);
        this.pathText = SWTUtils.createText(parent);
        if (this.resource != null && (actionPath = this.resource.getActionPath(IP4Resource.Type.REMOTE)) != null) {
            this.pathText.setText(actionPath);
        }
        Button browseBtn = SWTUtils.createButton(parent, Messages.DepotFileChooser_Browse, 8, 1);
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String actionPath;
                IP4Resource r;
                LazyResourceBrowserDialog dialog = new LazyResourceBrowserDialog(DepotFileChooser.this.getShell(), DepotFileChooser.this.adapter);
                if (dialog.open() == 0 && (r = dialog.getSelectedResource()) != null && (actionPath = r.getActionPath(IP4Resource.Type.REMOTE)) != null) {
                    DepotFileChooser.this.pathText.setText(actionPath);
                    DepotFileChooser.this.validate();
                }
            }
        });
    }

    @Override
    public IStatus validate() {
        this.path = this.pathText.getText().trim();
        return ValidationStatus.ok();
    }
}

