/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.client.ClientOptions;
import com.perforce.p4java.impl.generic.client.ClientSubmitOptions;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4TeamUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.SwitchStreamDialog;
import com.perforce.team.ui.p4java.actions.AbstractStreamAction;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.server.NewClientDialog;
import com.perforce.team.ui.streams.StreamUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class WorkinStreamAction
extends AbstractStreamAction {
    public void workinStream(IP4Stream target) {
        if (target != null) {
            this.doRun((IP4Resource)target);
        }
    }

    protected IClient createNewClient(IP4Connection connection, String stream, List<IClientSummary> clients) {
        IServerInfo info = connection.getServerInfo();
        if (info == null) {
            connection.refresh();
            info = connection.getServerInfo();
        }
        if (info == null) {
            return null;
        }
        String user = info.getUserName();
        String host = info.getClientHost();
        String streamSeg = StreamUtil.parseStream(stream)[1];
        StringBuilder sb = new StringBuilder();
        sb.append(user);
        sb.append("_");
        sb.append(host);
        sb.append("_");
        sb.append(streamSeg);
        sb.append("_");
        String clientName = sb.toString();
        int count = 0;
        Random random = new Random();
        while (count < 10) {
            ++count;
            int serial = 1000 + random.nextInt(9000);
            String name = String.valueOf(clientName) + serial;
            boolean existed = false;
            for (IClientSummary c : clients) {
                if (!name.equals(c.getName())) continue;
                existed = true;
                break;
            }
            if (existed) continue;
            clientName = name;
            break;
        }
        String clientRoot = String.valueOf(this.getPrefStore().getString("pref_client_root_parent_default")) + File.separator + clientName;
        ClientOptions options = new ClientOptions();
        ClientSubmitOptions submitOptions = new ClientSubmitOptions();
        ClientView clientView = new ClientView();
        Client candidate = new Client(clientName, new Date(), new Date(), String.valueOf(Messages.WorkinStreamAction_CreatedBy) + user, host, user, clientRoot, IClientSummary.ClientLineEnd.LOCAL, (IClientSummary.IClientOptions)options, (IClientSummary.IClientSubmitOptions)submitOptions, null, connection.getServer(), clientView, stream, null);
        try {
            NewClientDialog dialog = new NewClientDialog(this.getShell(), connection, (IClient)candidate);
            if (dialog.open() == 0) {
                return dialog.getEditedSpec();
            }
            return null;
        }
        catch (P4JavaException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EditClientAction_ClientNotFoundTitle, (String)Messages.EditClientAction_ClientNotFoundMessage);
            return null;
        }
    }

    @Override
    protected void doRun(IP4Resource target) {
        if (target != null) {
            if (WorkinStreamAction.isResourceInClientStream(target)) {
                return;
            }
            final String stream = this.getStreamFromResource(target);
            if (stream == null || stream.isEmpty() || stream.equals("none")) {
                return;
            }
            final IP4Connection connection = target.getConnection();
            final String jobTitle = MessageFormat.format(Messages.WorkinStreamAction_SwitchToStream, stream);
            final Shell shell = this.getShell();
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public String getTitle() {
                    return jobTitle;
                }

                public void run(IProgressMonitor monitor) {
                    GetClientsOptions opts = new GetClientsOptions();
                    opts.setUserName(connection.getUser());
                    opts.setStream(stream);
                    opts.setMaxResults(100);
                    final List clients = connection.getClients(opts);
                    final IClientSummary[] clientToSwitch = new IClientSummary[1];
                    final String switchStreamHow = WorkinStreamAction.this.getPrefStore().getString("pref_client_switch_on_stream_option");
                    final boolean noWarn = WorkinStreamAction.this.getPrefStore().getBoolean("pref_client_switch_no_warn");
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String NO_WARN_TEXT = Messages.WorkinStreamAction_DontWarnWheSwitchStream;
                            if ("diffStreamSameClient".equals(switchStreamHow)) {
                                String message = Messages.WorkinStreamAction_AboutToSwitchWorkspace;
                                int code = SwitchStreamDialog.open(3, WorkinStreamAction.this.getShell(), Messages.WorkinStreamAction_SwitchStream, message, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, new int[]{2, 3}, 0);
                                if (code == 2) {
                                    IClient c = connection.getClient();
                                    c.setStream(stream);
                                    clientToSwitch[0] = c;
                                    connection.updateClient(c);
                                }
                            } else if (clients.isEmpty()) {
                                if (noWarn) {
                                    clientToSwitch[0] = WorkinStreamAction.this.createNewClient(connection, stream, clients);
                                } else {
                                    String message = MessageFormat.format(Messages.WorkinStreamAction_MustSwitchWorkspaceToWorkWithStream, stream);
                                    int code = SwitchStreamDialog.open(3, WorkinStreamAction.this.getShell(), Messages.WorkinStreamAction_SwitchStream, message, NO_WARN_TEXT, new String[]{Messages.WorkinStreamAction_NewWorkspace, IDialogConstants.CANCEL_LABEL}, new int[]{2, 3}, 0);
                                    if (code == 2) {
                                        clientToSwitch[0] = WorkinStreamAction.this.createNewClient(connection, stream, clients);
                                    }
                                }
                            } else {
                                IClientSummary c = (IClientSummary)clients.get(0);
                                if (noWarn) {
                                    clientToSwitch[0] = c;
                                } else {
                                    String message = MessageFormat.format(Messages.WorkinStreamAction_MustSwitchWorkspaceByCreateNew, stream, c.getName());
                                    int[] nArray = new int[3];
                                    nArray[1] = 2;
                                    nArray[2] = 3;
                                    int code = SwitchStreamDialog.open(3, WorkinStreamAction.this.getShell(), Messages.WorkinStreamAction_SwitchStream, message, NO_WARN_TEXT, new String[]{Messages.WorkinStreamAction_SwitchWorkspace, Messages.WorkinStreamAction_NewWorkspace, IDialogConstants.CANCEL_LABEL}, nArray, 0);
                                    if (code == 0) {
                                        clientToSwitch[0] = c;
                                    } else if (code == 2) {
                                        clientToSwitch[0] = WorkinStreamAction.this.createNewClient(connection, stream, clients);
                                    }
                                }
                            }
                        }
                    });
                    if (clientToSwitch[0] == null) {
                        return;
                    }
                    ConnectionParameters newParam = new ConnectionParameters(connection.getParameters().toString());
                    newParam.setClient(clientToSwitch[0].getName());
                    IP4Connection newConn = P4ConnectionManager.getManager().getConnection(newParam);
                    newConn.refreshClient();
                    P4TeamUtils.processClientChange(newConn, shell, true, MessageFormat.format(Messages.AbstractStreamAction_StreamSwitchedDesc, stream));
                    newConn.markForRefresh();
                    P4ConnectionManager.getManager().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)newConn));
                }
            });
        }
    }

    protected IPreferenceStore getPrefStore() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore();
    }
}

