/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkOfflineAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = this.getConnectionSelection();
        if (!collection.isEmpty()) {
            this.updateConnections(collection.members());
        }
    }

    private void updateConnections(final IP4Resource[] resources) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IP4Resource[] iP4ResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4Connection && !((IP4Connection)resource).isOffline()) {
                        IP4Connection connection = (IP4Connection)resource;
                        connection.setOffline(true);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CHANGED, (IP4Resource)connection));
                    }
                    ++n2;
                }
                WorkOfflineAction.this.updateActionState();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    public boolean isEnabledEx() {
        IP4Resource[] resources;
        boolean enabled = false;
        P4Collection collection = this.getConnectionSelection();
        IP4Resource[] iP4ResourceArray = resources = collection.members();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            IP4Connection connection = resource.getConnection();
            if (connection != null && !connection.isOffline()) {
                enabled = true;
                break;
            }
            ++n2;
        }
        return enabled;
    }
}

