/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.FilePath;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIProgressListener;
import com.perforce.team.ui.dialogs.SyncRevisionDialog;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.actions.SyncPreviewAction;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SyncRevisionAction
extends P4Action {
    public void runAction(int revisionSpec) {
        this.runAction("#" + revisionSpec, false);
    }

    public void runAction(String revisionSpec) {
        this.runAction(revisionSpec, false);
    }

    public void runAction(String revisionSpec, boolean force) {
        P4Collection collection = this.getResourceSelection();
        if (!collection.isEmpty()) {
            this.sync(collection, revisionSpec, force);
        }
    }

    private void sync(final P4Collection collection, final String revisionSpec, final boolean force) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.SyncRevisionAction_Syncing;
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 300);
                monitor.setTaskName(SyncRevisionAction.this.generateTitle(CmdSpec.SYNC.name().toLowerCase(), collection));
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                P4UIProgressListener callback = new P4UIProgressListener(CmdSpec.SYNC, collection.getConnection(), (IProgressMonitor)subMonitor);
                List specs = collection.sync(force, false, revisionSpec, (IProgressMonitor)subMonitor, (IP4ProgressListener)callback);
                monitor.worked(100);
                monitor.setTaskName("Refresh local resources...");
                SyncRevisionAction.this.postSync(collection, specs);
                monitor.setTaskName("Update action state...");
                monitor.worked(100);
                SyncRevisionAction.this.updateActionState();
                monitor.done();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    protected void postSync(P4Collection collection, List<IFileSpec> specs) {
        if (specs == null) {
            return;
        }
        P4Collection newList = new P4Collection();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource r = iP4ResourceArray[n2];
            String p = r.getActionPath();
            if (p.endsWith("/...")) {
                p = p.substring(0, p.length() - 4);
            }
            for (IFileSpec s : specs) {
                FilePath cp = s.getClientPath();
                if (cp != null) {
                    String cpp = cp.getPathString();
                    if (cpp == null || !cpp.startsWith(p)) continue;
                    newList.add(r);
                    continue;
                }
                if (s.getStatusMessage() == null || !s.getStatusMessage().startsWith(p)) continue;
                newList.add(r);
            }
            ++n2;
        }
        newList.refresh();
        newList.refreshLocalResources(2);
    }

    public void runWithDialog(String initialSpec, boolean isOther) {
        SyncRevisionDialog dlg = new SyncRevisionDialog(this.getShell(), initialSpec, isOther);
        if (dlg.open() == 0) {
            if (dlg.preview()) {
                SyncPreviewAction action = new SyncPreviewAction();
                action.setAsync(this.isAsync());
                action.runAction(this.getResourceSelection(), dlg.forceSync(), dlg.getRevSpec());
            } else {
                this.runAction(dlg.getRevSpec(), dlg.forceSync());
            }
        }
    }

    @Override
    public void runAction() {
        this.runWithDialog(null, false);
    }

    @Override
    public boolean isEnabledEx() {
        return this.containsOnlineConnection();
    }
}

