/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.OpenAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class RevertEditAction
extends OpenAction {
    @Override
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4File file = (IP4File)resource;
                    if (this.isValidFile(file)) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    private void edit(final P4Collection collection, final int changelist, final String description, final boolean setActive) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return RevertEditAction.this.getJobTitle();
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 1);
                monitor.subTask(RevertEditAction.this.generateTitle(null, collection));
                collection.revertThenEdit(changelist, description, setActive);
                monitor.worked(1);
                monitor.done();
                collection.refreshLocalResources(2);
                RevertEditAction.this.updateActionState();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected void runModifyAction(int changelist, String description, P4Collection collection, boolean setActive) {
        this.edit(collection, changelist, description, setActive);
    }

    @Override
    public String getComboTitle() {
        return Messages.EditAction_OpenInChangelist;
    }

    @Override
    public String getDialogTitle() {
        return Messages.EditAction_CheckOut;
    }

    @Override
    protected boolean isValidFile(IP4File file) {
        return file.getP4JFile() != null && !file.isOpened();
    }

    @Override
    protected String getJobTitle() {
        return Messages.EditAction_CheckingOut;
    }

    @Override
    protected String getDefaultDescription() {
        return P4Collection.EDIT_DEFAULT_DESCRIPTION;
    }
}

