/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.actions.SyncRevisionAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class RecoverDeletedAction
extends P4Action {
    @Override
    protected void runAction() {
        final P4Collection collection = this.getResourceSelection();
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IP4Resource[] iP4ResourceArray = collection.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4File p4File;
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4File && RecoverDeletedAction.this.canRecover(p4File = (IP4File)resource) && p4File.getHaveRevision() == 0 && p4File.getHeadRevision() > 1) {
                        int previous = p4File.getHeadRevision() - 1;
                        SyncRevisionAction sync = new SyncRevisionAction();
                        sync.setAsync(false);
                        sync.selectionChanged(null, (ISelection)new StructuredSelection((Object)p4File));
                        sync.runAction("#" + previous);
                    }
                    RecoverDeletedAction.this.updateActionState();
                    ++n2;
                }
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private boolean canRecover(IP4File file) {
        return file != null && !file.isOpened() && file.isHeadActionDelete();
    }

    @Override
    protected boolean isEnabledEx() {
        boolean enabled = false;
        if (this.containsOnlineConnection()) {
            P4Collection collection = this.getResourceSelection();
            IP4Resource[] iP4ResourceArray = collection.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File && this.canRecover((IP4File)resource)) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }
}

