/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.OpenDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class OpenAction
extends P4Action {
    protected boolean wasDialogCancelled = false;

    public abstract String getDialogTitle();

    public abstract String getComboTitle();

    public boolean wasDialogCancelled() {
        return this.wasDialogCancelled;
    }

    protected abstract boolean isValidFile(IP4File var1);

    protected abstract String getJobTitle();

    protected abstract String getDefaultDescription();

    @Override
    protected void runAction() {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return OpenAction.this.getJobTitle();
            }

            public void run(IProgressMonitor monitor) {
                final P4Collection collection = OpenAction.this.getFileSelection();
                boolean showDialog = OpenAction.this.showDialog();
                HashMap<IP4Connection, ArrayList<IP4Resource>> connections = new HashMap<IP4Connection, ArrayList<IP4Resource>>();
                IP4Resource[] iP4ResourceArray = collection.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Connection connection;
                    IP4Resource resource = iP4ResourceArray[n2];
                    boolean valid = true;
                    if (showDialog) {
                        valid = resource instanceof IP4File ? OpenAction.this.isValidFile((IP4File)resource) : true;
                    }
                    if (valid && (connection = resource.getConnection()) != null) {
                        ArrayList<IP4Resource> resources = (ArrayList<IP4Resource>)connections.get(connection);
                        if (resources == null) {
                            resources = new ArrayList<IP4Resource>();
                            connections.put(connection, resources);
                        }
                        resources.add(resource);
                    }
                    ++n2;
                }
                for (Map.Entry entry : connections.entrySet()) {
                    P4Collection subCollection;
                    final IP4Connection connection = (IP4Connection)entry.getKey();
                    final List resources = (List)entry.getValue();
                    IP4PendingChangelist active = connection.getActivePendingChangelist();
                    if (showDialog && active == null) {
                        Runnable dialogRunnable = new Runnable(){

                            @Override
                            public void run() {
                                OpenDialog dialog = new OpenDialog(P4UIUtils.getDialogShell(), resources.toArray(new IP4Resource[0]), connection, OpenAction.this.getDialogTitle(), OpenAction.this.getComboTitle(), OpenAction.this.getDefaultDescription());
                                if (dialog.open() == 0) {
                                    IP4Resource[] selected = dialog.getSelectedFiles();
                                    if (selected.length > 0) {
                                        P4Collection subCollection = OpenAction.this.createCollection(selected);
                                        subCollection.setType(collection.getType());
                                        int listId = dialog.getSelectedChangeId();
                                        String description = dialog.getDescription();
                                        boolean useSelected = dialog.useSelected();
                                        OpenAction.this.runModifyAction(listId, description, subCollection, useSelected);
                                    } else {
                                        (this).OpenAction.this.wasDialogCancelled = true;
                                    }
                                } else {
                                    (this).OpenAction.this.wasDialogCancelled = true;
                                }
                            }
                        };
                        if (PerforceUIPlugin.isUIThread()) {
                            dialogRunnable.run();
                            continue;
                        }
                        PerforceUIPlugin.syncExec(dialogRunnable);
                        continue;
                    }
                    if (active != null) {
                        subCollection = new P4Collection(resources.toArray(new IP4Resource[resources.size()]));
                        OpenAction.this.runModifyAction(active.getId(), subCollection);
                        continue;
                    }
                    subCollection = new P4Collection(resources.toArray(new IP4Resource[resources.size()]));
                    OpenAction.this.runModifyAction(0, subCollection);
                }
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    protected void runModifyAction(int changelist, P4Collection collection) {
        this.runModifyAction(changelist, null, collection);
    }

    protected void runModifyAction(int changelist, String description, P4Collection collection) {
        this.runModifyAction(changelist, description, collection, false);
    }

    protected abstract void runModifyAction(int var1, String var2, P4Collection var3, boolean var4);

    protected boolean showDialog() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_open_default");
    }
}

