/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.dialogs.FileTypeDialog;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeFiletypeAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = super.getDirectFileSelection();
        IP4Resource[] resources = collection.members();
        int size = resources.length;
        if (size > 0) {
            FileTypeDialog dlg;
            IP4File first = (IP4File)resources[0];
            String type = first.getOpenedType();
            if (type == null) {
                type = "";
            }
            if ((dlg = new FileTypeDialog(this.getShell(), type)).open() == 0) {
                this.changeType(collection, dlg.getFileType());
            }
        }
    }

    public void changeType(String newType) {
        P4Collection collection = super.getDirectFileSelection();
        if (!collection.isEmpty()) {
            this.changeType(collection, newType);
        }
    }

    public void changeType(final P4Collection collection, final String newType) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 1);
                monitor.subTask(ChangeFiletypeAction.this.generateTitle(null, collection));
                collection.changeType(newType);
                monitor.worked(1);
                monitor.done();
            }

            public String getTitle() {
                return Messages.ChangeFiletypeAction_ChangingFileType;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    public boolean isEnabledEx() {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = false;
        if (this.containsOnlineConnection() && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4File file = (IP4File)resource;
                    if (file.isOpened()) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }
}

