/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.IgnoredFiles;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddIgnoreAction
extends P4Action {
    @Override
    protected void runAction() {
        List<IResource> resources = this.getLocalResourceSelection();
        if (resources != null && !resources.isEmpty()) {
            this.ignore(resources);
        }
    }

    private void ignore(final List<IResource> resources) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.AddIgnoreAction_IgnoringSelectedFoldersFiles;
            }

            public void run(IProgressMonitor monitor) {
                for (IResource resource : resources) {
                    IgnoredFiles.addIgnore(resource);
                    try {
                        resource.deleteMarkers("com.perforce.team.core.perforceadd", false, 0);
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
                AddIgnoreAction.this.updateActionState();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected boolean isEnabledEx() {
        boolean enabled = false;
        if (this.containsOnlineConnection()) {
            if (this.containsContainers()) {
                enabled = true;
            } else {
                P4Collection collection = super.getResourceSelection();
                IP4Resource[] resources = collection.members();
                if (resources.length > 0) {
                    IP4Resource[] iP4ResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Resource resource = iP4ResourceArray[n2];
                        if (resource.getRemotePath() == null) {
                            enabled = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }
        return enabled;
    }
}

