/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.editor.IP4PageFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class PageFactoryRegistry {
    public static final String PAGE_EXTENSION_POINT = "com.perforce.team.ui.page";
    public static final String PAGE_ELEMENT = "page";
    public static final String EDITOR_ID_ATTRIBUTE = "editorId";
    public static final String ID_ATTRIBUTE = "id";
    public static final String FACTORY_ATTRIBUTE = "factory";
    private static PageFactoryRegistry registry = null;
    private Map<String, Collection<IP4PageFactory>> factories = new HashMap<String, Collection<IP4PageFactory>>();

    public static synchronized PageFactoryRegistry getRegistry() {
        if (registry == null) {
            registry = new PageFactoryRegistry();
        }
        return registry;
    }

    private PageFactoryRegistry() {
        this.load();
    }

    private void load() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PAGE_EXTENSION_POINT);
        HashMap<String, TreeMap<String, IP4PageFactory>> loadedFactories = new HashMap<String, TreeMap<String, IP4PageFactory>>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (PAGE_ELEMENT.equals(element.getName())) {
                String factory = element.getAttribute(FACTORY_ATTRIBUTE);
                String editorId = element.getAttribute(EDITOR_ID_ATTRIBUTE);
                String id = element.getAttribute(ID_ATTRIBUTE);
                if (factory != null && editorId != null && id != null) {
                    Object pageFactory = null;
                    try {
                        pageFactory = element.createExecutableExtension(FACTORY_ATTRIBUTE);
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                    if (pageFactory instanceof IP4PageFactory) {
                        TreeMap<String, IP4PageFactory> editorFactories = (TreeMap<String, IP4PageFactory>)loadedFactories.get(editorId);
                        if (editorFactories == null) {
                            editorFactories = new TreeMap<String, IP4PageFactory>();
                            loadedFactories.put(editorId, editorFactories);
                        }
                        editorFactories.put(id, (IP4PageFactory)pageFactory);
                    }
                }
            }
            ++n2;
        }
        for (Map.Entry entry : loadedFactories.entrySet()) {
            this.factories.put((String)entry.getKey(), ((Map)entry.getValue()).values());
        }
    }

    public void addPages(FormEditor editor, String id) {
        Collection<IP4PageFactory> pageFactories;
        if (editor != null && id != null && (pageFactories = this.factories.get(id)) != null) {
            for (IP4PageFactory factory : pageFactories) {
                IFormPage page = factory.createPage(editor);
                if (page == null) continue;
                try {
                    editor.addPage(page);
                }
                catch (PartInitException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
        }
    }
}

