/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class P4BaseEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput,
IPathEditorInput {
    protected IStorage storage = null;
    protected File tempFile;

    protected IPath getTempStoragePath() {
        IPath path = null;
        if (this.tempFile != null) {
            path = Path.fromOSString((String)this.tempFile.getAbsolutePath());
        }
        return path;
    }

    protected String getSuffix() {
        return ".txt";
    }

    protected String getPrefix() {
        return "p4depotfile";
    }

    protected InputStream getStorageContents(IStorage wrapStorage) throws CoreException {
        InputStream stream;
        boolean useDirect;
        block34: {
            useDirect = false;
            stream = null;
            if (this.tempFile == null || !this.tempFile.exists()) {
                stream = wrapStorage.getContents();
                if (stream != null) {
                    OutputStream output = null;
                    InputStream input = stream;
                    try {
                        String prefix = this.getPrefix();
                        if (prefix.length() < 3) {
                            prefix = new StringBuilder("___").replace(0, prefix.length(), prefix).toString();
                        }
                        this.tempFile = File.createTempFile(prefix, this.getSuffix());
                        this.tempFile.deleteOnExit();
                        output = new FileOutputStream(this.tempFile);
                        byte[] buffer = new byte[4096];
                        int read = stream.read(buffer);
                        while (read > 0) {
                            ((FileOutputStream)output).write(buffer, 0, read);
                            read = stream.read(buffer);
                        }
                        stream = new FileInputStream(this.tempFile);
                    }
                    catch (FileNotFoundException e) {
                        useDirect = true;
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (output != null) {
                            try {
                                output.flush();
                                ((FileOutputStream)output).close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block34;
                    }
                    catch (IOException e) {
                        try {
                            useDirect = true;
                            break block34;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                            if (output != null) {
                                try {
                                    output.flush();
                                    ((FileOutputStream)output).close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (output != null) {
                        try {
                            output.flush();
                            ((FileOutputStream)output).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                try {
                    stream = new FileInputStream(this.tempFile);
                }
                catch (FileNotFoundException e) {
                    this.tempFile = null;
                    useDirect = true;
                }
            }
        }
        if (useDirect) {
            stream = wrapStorage.getContents();
        }
        return stream;
    }

    public Object getAdapter(Class adapter) {
        if (IStorage.class == adapter) {
            return this.storage;
        }
        if (IWorkbenchAdapter.class == adapter) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getImageDescriptor();
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public IPath getPath() {
        return this.getTempStoragePath();
    }
}

