/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.P4Storage;
import com.perforce.team.ui.editor.P4BaseEditorInput;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class DepotFileEditorInput
extends P4BaseEditorInput {
    private IP4File file = null;
    private String revision = null;
    private String name = null;

    public DepotFileEditorInput(IP4File file, String revision) {
        this.file = file;
        this.revision = revision;
    }

    public DepotFileEditorInput(IP4File file) {
        this(file, null);
    }

    public IStorage getStorage() throws CoreException {
        if (this.storage == null) {
            this.storage = new P4Storage(){

                public IPath getFullPath() {
                    return DepotFileEditorInput.this.getTempStoragePath();
                }

                public String getName() {
                    return DepotFileEditorInput.this.file.getName();
                }

                public InputStream getContents() throws CoreException {
                    P4Storage wrapStorage = new P4Storage(){

                        public InputStream getContents() throws CoreException {
                            if (DepotFileEditorInput.this.revision == null) {
                                return DepotFileEditorInput.this.file.getHeadContents();
                            }
                            return DepotFileEditorInput.this.file.getRemoteContents(DepotFileEditorInput.this.revision);
                        }
                    };
                    return DepotFileEditorInput.this.getStorageContents((IStorage)wrapStorage);
                }
            };
        }
        return this.storage;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.revision == null ? String.valueOf(this.file.getName()) + " #" + this.file.getHeadRevision() : String.valueOf(this.file.getName()) + " " + this.revision;
        }
        return this.name;
    }

    public String getToolTipText() {
        String tipRevision = null;
        tipRevision = this.revision != null ? this.revision : "#" + this.file.getHeadRevision();
        return String.valueOf(this.file.getActionPath()) + tipRevision;
    }

    @Override
    public String getLabel(Object o) {
        if (this.storage != null) {
            return this.storage.getName();
        }
        return null;
    }

    @Override
    protected String getSuffix() {
        int lastDot;
        String name = this.file.getName();
        if (name != null && (lastDot = name.lastIndexOf(46)) > 0) {
            return name.substring(lastDot);
        }
        return super.getSuffix();
    }

    @Override
    protected String getPrefix() {
        int lastDot;
        String name = this.file.getName();
        if (name != null && (lastDot = name.lastIndexOf(46)) > 0) {
            return name.substring(0, lastDot);
        }
        return super.getSuffix();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DepotFileEditorInput) {
            DepotFileEditorInput other = (DepotFileEditorInput)((Object)obj);
            if (this.file.equals(other.file)) {
                if (this.revision != null && other.revision != null) {
                    return this.revision.equals(other.revision);
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }
}

