/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.ui.editor.IProposal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public abstract class BaseContentAssistant
extends ContentAssistant {
    protected char[] activators = null;
    private Trigger keyTrigger = null;
    protected Set<Character> activatorSet = Collections.synchronizedSet(new HashSet());
    protected Comparator<ICompletionProposal> comparator = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
    };

    protected Trigger getContentAssistTrigger() {
        Trigger[] triggers;
        IBindingService service = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        Trigger trigger = null;
        TriggerSequence[] sequences = service.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (sequences.length > 0 && (triggers = sequences[0].getTriggers()).length > 0) {
            trigger = triggers[0];
        }
        return trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCharArray() {
        StringBuilder activateString = new StringBuilder();
        Set<Character> set = this.activatorSet;
        synchronized (set) {
            for (Character c : this.activatorSet) {
                activateString.append(c);
            }
        }
        this.activators = activateString.toString().toCharArray();
    }

    protected ICompletionProposal createProposal(IProposal proposal, int offset, int prefix) {
        return this.createProposal(proposal, offset - prefix, prefix, proposal.getValue().length());
    }

    protected ICompletionProposal createProposal(IProposal proposal, int replaceOffset, int replaceLength, int cursorOffset) {
        return new CompletionProposal(proposal.getValue(), replaceOffset, replaceLength, cursorOffset, proposal.getImage(), proposal.getDisplay(), null, null);
    }

    protected void createProposals(String prefix, Set<IProposal> proposals, Set<ICompletionProposal> realProposals, int offset, int selectOffset, int selectLength) {
        int prefixLength = prefix.length();
        if (prefixLength > 0) {
            for (IProposal raw : proposals) {
                String display = raw.getDisplay();
                if (prefixLength < display.length()) {
                    String match = display.substring(0, prefixLength);
                    if (!match.equalsIgnoreCase(prefix)) continue;
                    ICompletionProposal prop = this.createProposal(raw, offset, prefixLength);
                    realProposals.add(prop);
                    continue;
                }
                if (prefixLength != display.length() || display.equals(prefix) || !display.equalsIgnoreCase(prefix)) continue;
                ICompletionProposal prop = this.createProposal(raw, offset, prefixLength);
                realProposals.add(prop);
            }
        } else {
            int length = selectOffset == offset && selectLength > 0 ? selectLength : 0;
            for (IProposal raw : proposals) {
                ICompletionProposal prop = this.createProposal(raw, offset, length, raw.getValue().length());
                realProposals.add(prop);
            }
        }
    }

    protected void loadTrigger() {
        this.keyTrigger = this.getContentAssistTrigger();
    }

    protected boolean autoActivate() {
        return false;
    }

    protected void loadProcessor() {
        this.setContentAssistProcessor(this.createProcessor(), "__dftl_partition_content_type");
    }

    protected abstract IContentAssistProcessor createProcessor();

    public void init() {
        this.loadProcessor();
        this.loadTrigger();
        this.enableAutoActivation(this.autoActivate());
        this.enablePrefixCompletion(true);
        this.enableAutoInsert(true);
    }

    public void install(ITextViewer textViewer) {
        if (this.keyTrigger != null) {
            textViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    KeyStroke stroke = KeyStroke.getInstance((int)event.stateMask, (int)(event.character != '\u0000' ? event.character : event.keyCode));
                    if (BaseContentAssistant.this.keyTrigger.equals((Object)stroke)) {
                        event.doit = false;
                        BaseContentAssistant.this.showPossibleCompletions();
                    }
                }
            });
        }
        super.install(textViewer);
    }
}

