/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.preferences.RetrievePreferencePage;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class StreamsPreferencesDialog
extends RetrievePreferencePage {
    public static final int SHOW_NAME_ROOT = 0;
    public static final int SHOW_NAME_ONLY = 1;
    public static final int SHOW_ROOT_ONLY = 2;
    public static final String ID = "com.perforce.team.ui.dialogs.StreamsPreferencesDialog";
    private static final int NUM_COLS = 1;
    private Button nameAndRootRadio;
    private Button nameRadio;
    private Button rootRadio;
    private Button diffWorkspaceRadio;
    private Button sameWorkspaceRadio;
    private Button notPromptSwitch;

    public StreamsPreferencesDialog() {
        super(1);
        IPreferenceStore store = this.getPreferenceStore();
        if (StringUtils.isEmpty((CharSequence)store.getString("pref_client_switch_on_stream_option"))) {
            store.setDefault("pref_client_switch_on_stream_option", "diffStreamSameClient");
        }
    }

    protected Control createContents(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        displayArea.setLayout((Layout)daLayout);
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSwitchArea(displayArea);
        super.createRetrieveArea(displayArea);
        this.createStreamDisplayArea(displayArea);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.allElementsRadio, "com.perforce.team.ui.pref_all_streams_radio");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.maxElementsRadio, "com.perforce.team.ui.pref_max_streams_radio");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.maxElementsText, "com.perforce.team.ui.pref_max_streams_text");
        return displayArea;
    }

    private Composite createSwitchArea(Composite parent) {
        Group group = DialogUtils.createGroup(parent, Messages.StreamsPreferencesDialog_SwitchDesc, 1);
        int buttonStyle = P4CoreUtils.isWindows() ? 524288 : 0;
        this.sameWorkspaceRadio = DialogUtils.createRadio((Composite)group, buttonStyle, Messages.StreamsPreferencesDialog_AutoSwitch);
        this.diffWorkspaceRadio = DialogUtils.createRadio((Composite)group, buttonStyle, Messages.StreamsPreferencesDialog_ManualSwitch);
        this.notPromptSwitch = DialogUtils.createCheck((Composite)group, Messages.StreamsPreferencesDialog_NotWarnSwitch);
        GridData gd = new GridData(1, 0x1000000, true, false);
        gd.horizontalIndent += 20;
        this.notPromptSwitch.setLayoutData((Object)gd);
        this.sameWorkspaceRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StreamsPreferencesDialog.this.sameWorkspaceRadio.getSelection()) {
                    StreamsPreferencesDialog.this.notPromptSwitch.setSelection(false);
                }
                StreamsPreferencesDialog.this.notPromptSwitch.setEnabled(!StreamsPreferencesDialog.this.sameWorkspaceRadio.getSelection());
            }
        });
        Link link = new Link((Composite)group, 0);
        link.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        link.setText(Messages.StreamsPreferencesDialog_WorkspaceLink);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)StreamsPreferencesDialog.this.getShell(), (String)"com.perforce.team.ui.dialogs.ClientPreferencesDialog", null, (Object)"");
            }
        });
        this.initSwitchDisplayValues(this.getPrefInt(this.getStreamDisplayPref()));
        return group;
    }

    private void initSwitchDisplayValues(int prefInt) {
        String opt = this.getPrefString("pref_client_switch_on_stream_option");
        if (StringUtils.isEmpty((CharSequence)opt)) {
            opt = "diffStreamSameClient";
        }
        if ("diffStreamSameClient".equals(opt)) {
            this.sameWorkspaceRadio.setSelection(true);
        } else if ("diffStreamDiffClient".equals(opt)) {
            this.diffWorkspaceRadio.setSelection(true);
        }
        boolean noWarnSWitch = this.getPrefBoolean("pref_client_switch_no_warn");
        this.notPromptSwitch.setSelection(noWarnSWitch);
        this.notPromptSwitch.setEnabled(this.diffWorkspaceRadio.getSelection());
    }

    private Composite createStreamDisplayArea(Composite parent) {
        Group group = DialogUtils.createGroup(parent, Messages.StreamsPreferencesDialog_DisplayStreamAs, 1);
        int buttonStyle = P4CoreUtils.isWindows() ? 524288 : 0;
        this.nameAndRootRadio = DialogUtils.createRadio((Composite)group, buttonStyle, Messages.StreamsPreferencesDialog_NameAndRoot);
        this.nameRadio = DialogUtils.createRadio((Composite)group, buttonStyle, Messages.StreamsPreferencesDialog_NameOnly);
        this.rootRadio = DialogUtils.createRadio((Composite)group, buttonStyle, Messages.StreamsPreferencesDialog_RootOnly);
        this.initStreamDisplayValues(this.getPrefInt(this.getStreamDisplayPref()));
        return group;
    }

    private void initStreamDisplayValues(int num) {
        this.nameRadio.setSelection(false);
        this.rootRadio.setSelection(false);
        this.nameAndRootRadio.setSelection(false);
        switch (num) {
            case 1: {
                this.nameRadio.setSelection(true);
                break;
            }
            case 2: {
                this.rootRadio.setSelection(true);
                break;
            }
            default: {
                this.nameAndRootRadio.setSelection(true);
            }
        }
    }

    @Override
    protected String getName() {
        return Messages.StreamsPreferenceDialog_Streams;
    }

    @Override
    protected String getRetrievePref() {
        return "pref_retrieve_num_streams";
    }

    protected String getStreamDisplayPref() {
        return "pref_display_stream_name_root";
    }

    @Override
    public boolean performOk() {
        int num = this.nameAndRootRadio.getSelection() ? 0 : (this.nameRadio.getSelection() ? 1 : (this.rootRadio.getSelection() ? 2 : 0));
        this.setPrefInt(this.getStreamDisplayPref(), num);
        String switchOpt = "diffStreamSameClient";
        if (this.diffWorkspaceRadio.getSelection()) {
            switchOpt = "diffStreamDiffClient";
        }
        this.setPrefString("pref_client_switch_on_stream_option", switchOpt);
        this.setPrefBoolean("pref_client_switch_no_warn", this.notPromptSwitch.getSelection());
        return super.performOk();
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.diffWorkspaceRadio.setSelection(false);
        this.sameWorkspaceRadio.setSelection(true);
        this.notPromptSwitch.setEnabled(false);
        this.notPromptSwitch.setSelection(false);
        this.initStreamDisplayValues(this.getPrefDefInt(this.getStreamDisplayPref()));
    }
}

